/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.i18n;

import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.i18n.CatalogManager;
import com.vmware.vise.vim.commons.i18n.CatalogManagerAcceptingLocales;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizationUtil {
    private static final AtomicReference<CatalogManager> _catalogManagerRef = new AtomicReference();
    private static final Log _logger = LogFactory.getLog(LocalizationUtil.class);

    public static void setCatalogManager(CatalogManager catalogManager) {
        _catalogManagerRef.set(catalogManager);
    }

    public static String getLocalizedMessage(String string) {
        return LocalizationUtil.getLocalizedMessage(string, null, 0);
    }

    public static String getLocalizedMessageGivenLocale(String string, Locale locale) {
        return LocalizationUtil.getLocalizedMessageGivenLocale(string, null, 0, locale);
    }

    public static String getLocalizedMessage(String string, KeyAnyValue[] keyAnyValueArray) {
        return LocalizationUtil.getLocalizedMessage(string, keyAnyValueArray, 0);
    }

    public static String getLocalizedMessageGivenLocale(String string, KeyAnyValue[] keyAnyValueArray, Locale locale) {
        return LocalizationUtil.getLocalizedMessageGivenLocale(string, keyAnyValueArray, 0, locale);
    }

    public static String getLocalizedMessage(String string, KeyAnyValue[] keyAnyValueArray, int n) {
        return LocalizationUtil.getLocalizedMessageGivenLocale(string, keyAnyValueArray, n, null);
    }

    public static String getLocalizedMessageGivenLocale(String string, KeyAnyValue[] keyAnyValueArray, int n, Locale locale) {
        CatalogManager catalogManager = _catalogManagerRef.get();
        if (catalogManager == null) {
            _logger.error((Object)("CatalogManager is null. Cannot localize " + string));
            return string;
        }
        String string2 = locale != null && catalogManager instanceof CatalogManagerAcceptingLocales ? ((CatalogManagerAcceptingLocales)((Object)catalogManager)).getLocalizedMessage(string, keyAnyValueArray, n, locale) : catalogManager.getLocalizedMessage(string, keyAnyValueArray, n);
        return string2;
    }

    public static Map<String, String> getLocalizedMessage(String[] stringArray, KeyAnyValue[][] keyAnyValueArray) {
        return LocalizationUtil.getLocalizedMessage(stringArray, keyAnyValueArray, 0);
    }

    public static Map<String, String> getLocalizedMessageGivenLocale(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, Locale locale) {
        return LocalizationUtil.getLocalizedMessageGivenLocale(stringArray, keyAnyValueArray, 0, locale);
    }

    public static Map<String, String> getLocalizedMessage(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, int n) {
        return LocalizationUtil.getLocalizedMessageGivenLocale(stringArray, keyAnyValueArray, n, null);
    }

    public static Map<String, String> getLocalizedMessageGivenLocale(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, int n, Locale locale) {
        CatalogManager catalogManager = _catalogManagerRef.get();
        if (catalogManager == null) {
            _logger.error((Object)"CatalogManager is null.");
            return null;
        }
        Map<String, String> map = locale != null && catalogManager instanceof CatalogManagerAcceptingLocales ? ((CatalogManagerAcceptingLocales)((Object)catalogManager)).getLocalizedMessage(stringArray, keyAnyValueArray, n, locale) : catalogManager.getLocalizedMessage(stringArray, keyAnyValueArray, n);
        return map;
    }

    public static String formatLocalizedFloat(float f) {
        String string = NumberFormat.getInstance(ResourceUtil.getLocale()).format(f);
        return string;
    }

    public static String formatLocalizedDate(Date date) {
        return DateFormat.getDateInstance(2, ResourceUtil.getLocale()).format(date);
    }
}

