/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.ssl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.KeystoreUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeystoreServiceImpl
implements KeystoreService {
    private static final Log _logger = LogFactory.getLog(KeystoreServiceImpl.class);
    private final ConfigurationService _configService;
    private AtomicReference<KeystoreData> _keyStoreRef = new AtomicReference();

    public KeystoreServiceImpl(ConfigurationService configurationService) {
        this._configService = configurationService;
    }

    public void initialize() {
        KeystoreUtil.keyStoreService = this;
    }

    @Override
    public KeyStore getKeyStore() {
        KeystoreData keystoreData = this.getKeystoreData();
        if (keystoreData.ks == null) {
            throw new IllegalStateException("Keystore to be used for remote connections is null.");
        }
        return keystoreData.ks;
    }

    @Override
    public String getKeyStorePassword() {
        return this.getKeystoreData().ksPassword;
    }

    @Override
    public X509Certificate[] getSslTrustCertificates() {
        return KeystoreServiceImpl.loadSslTrustCertificates(this.getKeyStore());
    }

    private KeystoreData getKeystoreData() {
        KeystoreData keystoreData = this._keyStoreRef.get();
        if (keystoreData == null) {
            keystoreData = this.loadKeyStoreData();
            this._keyStoreRef.compareAndSet(null, keystoreData);
        }
        if (keystoreData != null && keystoreData.ks != null && _logger.isTraceEnabled()) {
            String string = KeystoreUtil.getInfoAboutKeyStore(keystoreData.ks);
            _logger.trace((Object)string);
        }
        return keystoreData;
    }

    private static X509Certificate[] loadSslTrustCertificates(KeyStore keyStore) {
        X509Certificate[] x509CertificateArray;
        if (keyStore == null) {
            return new X509Certificate[0];
        }
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        try {
            x509CertificateArray = keyStore.aliases();
            while (x509CertificateArray.hasMoreElements()) {
                String string = x509CertificateArray.nextElement();
                Certificate certificate = keyStore.getCertificate(string);
                if (!(certificate instanceof X509Certificate)) continue;
                linkedList.add((X509Certificate)certificate);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            _logger.error((Object)"Cannot initialize SSL trust certificates", (Throwable)generalSecurityException);
        }
        x509CertificateArray = linkedList.toArray(new X509Certificate[linkedList.size()]);
        return x509CertificateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeystoreData loadKeyStoreData() {
        Object object;
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        String string = null;
        try {
            if (StringUtil.isNullOrEmpty((String)this._configService.getProperty("keystore.jks.path"))) {
                keyStore = KeyStore.getInstance("VKS2");
                object = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
                KeyStore.LoadStoreParameter loadStoreParameter = (KeyStore.LoadStoreParameter)((Class)object).getConstructor(String.class).newInstance("TRUSTED_ROOTS");
                keyStore.load(loadStoreParameter);
                _logger.info((Object)"VECS keystore is now loaded successfully.");
            } else {
                String string2;
                keyStore = KeyStore.getInstance("JKS");
                object = this._configService.getProperty("keystore.jks.path");
                string = string2 = this._configService.getProperty("keystore.jks.password");
                fileInputStream = new FileInputStream((String)object);
                char[] cArray = string2 != null ? string2.toCharArray() : null;
                keyStore.load(fileInputStream, cArray);
                _logger.info((Object)"Local JKS keystore is now loaded successfully.");
            }
            StreamUtil.close((Closeable)fileInputStream);
        }
        catch (Exception exception) {
            _logger.error((Object)"An error occurred when loading keystore.", (Throwable)exception);
        }
        finally {
            StreamUtil.close(fileInputStream);
        }
        object = new KeystoreData(keyStore, string);
        return object;
    }

    private class KeystoreData {
        public final KeyStore ks;
        public final String ksPassword;

        public KeystoreData(KeyStore keyStore, String string) {
            this.ks = keyStore;
            this.ksPassword = string;
        }
    }
}

