/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.sso;

import com.google.common.collect.ImmutableMap;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenAcquisitionResult;
import com.vmware.sso.tokenmgmt.TokenException;
import com.vmware.sso.tokenmgmt.TokenProvider;
import com.vmware.sso.tokenmgmt.impl.SingleDomainTokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.annotations.Beta;
import com.vmware.vise.util.session.SessionUtil;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public class AuthSessionUtil {
    public static final String SSO_TOKEN_PRIVATE_KEY = "SSO_TOKEN_PRIVATE_KEY";
    public static final String SSO_TOKEN_PROVIDER = "SSO_TOKEN_PROVIDER";

    @Deprecated
    public static SamlToken getSsoToken() {
        return AuthSessionUtil.getSsoToken((HttpSession)null);
    }

    public static SamlToken getSsoToken(@Nonnull SsoDomain ssoDomain) {
        return AuthSessionUtil.getSsoToken(ssoDomain, (HttpSession)null);
    }

    @Deprecated
    public static SamlToken getSsoToken(HttpSession httpSession) {
        return AuthSessionUtil.getSsoToken(SsoDomain.getLocal(), httpSession);
    }

    @Nullable
    public static SamlToken getSsoToken(@Nonnull SsoDomain ssoDomain, @Nullable HttpSession httpSession) {
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_PROVIDER, (HttpSession)httpSession);
        if (tokenProvider == null) {
            return null;
        }
        try {
            SamlToken samlToken = tokenProvider.getTokenForSsoDomain(ssoDomain);
            return samlToken;
        }
        catch (TokenException tokenException) {
            return null;
        }
    }

    @Deprecated
    public static SamlToken getSsoToken(String string) {
        return AuthSessionUtil.getSsoToken(SsoDomain.getLocal(), string);
    }

    @Nullable
    public static SamlToken getSsoToken(@Nonnull SsoDomain ssoDomain, @Nonnull String string) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)string);
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_PROVIDER, (String)string);
        if (tokenProvider == null) {
            return null;
        }
        try {
            SamlToken samlToken = tokenProvider.getTokenForSsoDomain(ssoDomain);
            return samlToken;
        }
        catch (TokenException tokenException) {
            return null;
        }
    }

    @Nonnull
    public static Map<SsoDomain, SamlToken> getAllSsoTokens() {
        return AuthSessionUtil.getAllSsoTokens((HttpSession)null);
    }

    @Nonnull
    public static Map<SsoDomain, SamlToken> getAllSsoTokens(@Nullable HttpSession httpSession) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            return Collections.emptyMap();
        }
        return AuthSessionUtil.getAllSsoTokens(string);
    }

    @Nonnull
    public static Map<SsoDomain, SamlToken> getAllSsoTokens(@Nonnull String string) {
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_PROVIDER, (String)string);
        if (tokenProvider == null) {
            return Collections.emptyMap();
        }
        HashMap<SsoDomain, SamlToken> hashMap = new HashMap<SsoDomain, SamlToken>();
        Collection collection = tokenProvider.getAllTokens();
        for (TokenAcquisitionResult tokenAcquisitionResult : collection) {
            SamlToken samlToken = (SamlToken)tokenAcquisitionResult.getToken().orElse(null);
            if (samlToken == null) continue;
            SsoDomain ssoDomain = tokenAcquisitionResult.getSsoDomain();
            hashMap.put(ssoDomain, samlToken);
        }
        if (hashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf(hashMap);
    }

    @Deprecated
    public static void setSsoToken(SamlToken samlToken) {
        AuthSessionUtil.setSsoToken(samlToken, (HttpSession)null);
    }

    @Beta(value="provide a real implementation")
    public static void setSsoToken(SsoDomain ssoDomain, SamlToken samlToken) {
        AuthSessionUtil.setSsoToken(ssoDomain, samlToken, (HttpSession)null);
    }

    @Deprecated
    public static void setSsoToken(SamlToken samlToken, HttpSession httpSession) {
        AuthSessionUtil.setSsoToken(SsoDomain.getLocal(), samlToken, httpSession);
    }

    @Beta(value="provide a real implementation")
    public static void setSsoToken(@Nonnull SsoDomain ssoDomain, @Nonnull SamlToken samlToken, @Nullable HttpSession httpSession) {
        SingleDomainTokenProvider singleDomainTokenProvider = new SingleDomainTokenProvider(ssoDomain, samlToken);
        SessionUtil.setData((String)SSO_TOKEN_PROVIDER, (Object)singleDomainTokenProvider, (HttpSession)httpSession);
    }

    @Deprecated
    public static void setSsoToken(SamlToken samlToken, String string) {
        AuthSessionUtil.setSsoToken(SsoDomain.getLocal(), samlToken, string);
    }

    @Beta(value="provide a real implementation")
    public static void setSsoToken(@Nonnull SsoDomain ssoDomain, @Nonnull SamlToken samlToken, @Nonnull String string) {
        Validate.notNull((Object)string);
        SingleDomainTokenProvider singleDomainTokenProvider = new SingleDomainTokenProvider(ssoDomain, samlToken);
        SessionUtil.setData((String)SSO_TOKEN_PROVIDER, (Object)singleDomainTokenProvider, (String)string);
    }

    public static PrivateKey getSsoTokenPrivateKey() {
        return AuthSessionUtil.getSsoTokenPrivateKey((HttpSession)null);
    }

    public static void setSsoTokenPrivateKey(PrivateKey privateKey) {
        AuthSessionUtil.setSsoTokenPrivateKey(privateKey, (HttpSession)null);
    }

    public static PrivateKey getSsoTokenPrivateKey(HttpSession httpSession) {
        return (PrivateKey)SessionUtil.getData((String)SSO_TOKEN_PRIVATE_KEY, (HttpSession)httpSession);
    }

    public static void setSsoTokenPrivateKey(PrivateKey privateKey, HttpSession httpSession) {
        SessionUtil.setData((String)SSO_TOKEN_PRIVATE_KEY, (Object)privateKey, (HttpSession)httpSession);
    }

    public static PrivateKey getSsoTokenPrivateKey(String string) {
        return (PrivateKey)SessionUtil.getData((String)SSO_TOKEN_PRIVATE_KEY, (String)string);
    }

    public static void setSsoTokenPrivateKey(PrivateKey privateKey, String string) {
        SessionUtil.setData((String)SSO_TOKEN_PRIVATE_KEY, (Object)privateKey, (String)string);
    }
}

