/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi;

import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.AllowKnownThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.KeystoreUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedHttpConfigPool
implements HttpConfigurationProvider {
    public static final int DEFAULT_MAX_CONNECTIONS = 500;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 500;
    public static final int DEFAULT_KEEP_ALIVE_PERIOD = 45000;
    public static final int DEFAULT_TIMEOUT_MILLIS = 1200000;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 120000;
    public static final String DEFAULT_USER_AGENT = "web-client/6.5.0";
    private static final Log _logger = LogFactory.getLog(SharedHttpConfigPool.class);
    private static final String DEFAULT_ALIAS = "SslTrustAnchor";
    protected static final ThumbprintVerifier ALLOW_ALL_THUMBPRINT_VERIFIER = ThumbprintVerifier.Factory.createAllowAllThumbprintVerifier();
    protected final int _maxConnections;
    protected final int _maxConnectionsPerRoute;
    protected final int _timeoutInMillis;
    protected final int _connectionTimeoutInMillis;
    protected final int _keepAlivePeriodMillis;
    protected final String _userAgent;
    protected final String[] _enabledProtocols;
    @Nullable
    protected final KeystoreService _keystoreService;
    protected final ReadWriteLock _lock = new ReentrantReadWriteLock();
    @GuardedBy(value="_lock")
    protected final Map<String, SharedHttpConfig> _httpConfigDataByUrl = new HashMap<String, SharedHttpConfig>();

    public SharedHttpConfigPool(@Nonnegative int n, @Nonnegative int n2) {
        this(null, n, n2);
    }

    public SharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2) {
        this(keystoreService, n, n2, 45000);
    }

    public SharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2, int n3) {
        this(keystoreService, n, n2, 120000, n3);
    }

    public SharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, int n4) {
        this(keystoreService, n, n2, n3, n4, DEFAULT_USER_AGENT, null);
    }

    public SharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, int n4, @Nonnull String string, @Nullable String[] stringArray) {
        this(keystoreService, n, n, n2, n3, n4, string, stringArray);
    }

    protected SharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, int n5, @Nonnull String string, @Nullable String[] stringArray) {
        Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"Connection Pool must have at least 1 connection: ", (long)n);
        Validate.isTrue((n2 >= 1 ? 1 : 0) != 0, (String)"Connection Pool must have at least 1 connection per route: ", (long)n2);
        Validate.isTrue((n3 >= 1 ? 1 : 0) != 0, (String)"Timeout must be at least 1 millisecond: ", (long)n3);
        Validate.isTrue((n4 >= 1 ? 1 : 0) != 0, (String)"Connection Timeout must be at least 1 millisecond: ", (long)n4);
        Validate.notEmpty((String)string, (String)"User agent cannot be null or empty.");
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        this._keystoreService = keystoreService;
        this._maxConnections = n;
        this._maxConnectionsPerRoute = n2;
        this._timeoutInMillis = n3;
        this._connectionTimeoutInMillis = n4;
        this._keepAlivePeriodMillis = n5;
        this._userAgent = string;
        this._enabledProtocols = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
    }

    @Override
    public HttpConfiguration getHttpConfig(@Nonnull String string) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"identifier is empty");
        return this.getHttpConfig(string, null, null, null);
    }

    @Override
    public HttpConfiguration getHttpConfig(@Nonnull String string, @Nullable KeyStore keyStore) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"identifier is empty");
        return this.getHttpConfig(string, keyStore, null, null);
    }

    @Override
    public HttpConfiguration getHttpConfig(@Nonnull String string, @Nullable KeyStore keyStore, @Nullable String string2) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"identifier is empty");
        return this.getHttpConfig(string, keyStore, null, string2);
    }

    @Override
    public HttpConfiguration getHttpConfig(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"identifier is empty");
        return this.getHttpConfig(string, null, string2, string3);
    }

    private HttpConfiguration getHttpConfig(@Nonnull String string, @Nullable KeyStore keyStore, @Nullable String string2, @Nullable String string3) {
        HttpConfiguration httpConfiguration = this.getPreexistingConfiguration(string);
        if (httpConfiguration != null) {
            return httpConfiguration;
        }
        HttpConfiguration httpConfiguration2 = this.createHttpConfigInternal(keyStore, string2, string3);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created a new HttpConfiguration for " + string + ": " + Integer.toHexString(System.identityHashCode(httpConfiguration2))));
        }
        SharedHttpConfig sharedHttpConfig = new SharedHttpConfig(httpConfiguration2);
        httpConfiguration = this.insertOrUpdateSharedHttpConfig(string, sharedHttpConfig);
        return httpConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpConfiguration getPreexistingConfiguration(String string) {
        this._lock.readLock().lock();
        try {
            SharedHttpConfig sharedHttpConfig = this._httpConfigDataByUrl.get(string);
            if (sharedHttpConfig != null) {
                sharedHttpConfig.incrementAndGetActiveSessionCount();
                HttpConfiguration httpConfiguration = sharedHttpConfig.getHttpConfiguration();
                KeyStore keyStore = httpConfiguration.getTrustStore();
                ThumbprintVerifier thumbprintVerifier = httpConfiguration.getThumbprintVerifier();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Found a pre-existing HTTP configuration for " + string + ": instance=" + Integer.toHexString(System.identityHashCode(httpConfiguration)) + ", trustStore=" + KeystoreUtil.getInfoAboutKeyStore(keyStore) + "\n\nthumbprintVerifier=" + SharedHttpConfigPool.getInfoAboutThumbprintVerifier(thumbprintVerifier)));
                }
                HttpConfiguration httpConfiguration2 = httpConfiguration;
                return httpConfiguration2;
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
        return null;
    }

    protected static String getInfoAboutThumbprintVerifier(ThumbprintVerifier thumbprintVerifier) {
        if (thumbprintVerifier == null) {
            return null;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (thumbprintVerifier instanceof AllowKnownThumbprintVerifier) {
                Field field = AllowKnownThumbprintVerifier.class.getDeclaredField("_knownThumbprints");
                field.setAccessible(true);
                Object[] objectArray = (String[])field.get(thumbprintVerifier);
                stringBuilder.append(thumbprintVerifier.getClass().getName()).append("(").append(Arrays.toString(objectArray)).append(")");
            } else {
                stringBuilder.append(thumbprintVerifier);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            if (_logger.isDebugEnabled()) {
                _logger.error((Object)"Failed to extract info about the thumbprint verifier", (Throwable)exception);
            } else {
                _logger.error((Object)("Failed to extract info about the thumbprint verifier: " + exception.getMessage()));
            }
            return "?";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpConfiguration insertOrUpdateSharedHttpConfig(@Nonnull String string, @Nonnull SharedHttpConfig sharedHttpConfig) {
        this._lock.writeLock().lock();
        try {
            SharedHttpConfig sharedHttpConfig2 = this._httpConfigDataByUrl.get(string);
            if (sharedHttpConfig2 != null) {
                sharedHttpConfig = sharedHttpConfig2;
            } else {
                this._httpConfigDataByUrl.put(string, sharedHttpConfig);
            }
            sharedHttpConfig.incrementAndGetActiveSessionCount();
            HttpConfiguration httpConfiguration = sharedHttpConfig.getHttpConfiguration();
            return httpConfiguration;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected KeyStore getSystemKeyStore() {
        KeyStore keyStore = this._keystoreService != null ? this._keystoreService.getKeyStore() : KeystoreUtil.getKeyStore();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Fetched the system-wide keystore from " + (this._keystoreService != null ? "KeystoreService" : "KeystoreUtil") + ". The keystore is " + (keyStore != null ? "not " : "") + "null"));
        }
        return keyStore;
    }

    private HttpConfiguration createHttpConfigInternal(@Nullable KeyStore keyStore, @Nullable String string, @Nullable String string2) {
        StringBuilder stringBuilder;
        if (keyStore == null && string == null && string2 == null) {
            keyStore = this.getSystemKeyStore();
        } else if (_logger.isDebugEnabled()) {
            stringBuilder = new StringBuilder(200);
            boolean bl = false;
            stringBuilder.append("Will not use the system-wide keystore because the caller has provided ");
            if (keyStore != null) {
                stringBuilder.append("a non-null keyStore");
                bl = true;
            }
            if (string != null) {
                if (bl) {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append("a non-null certificate");
                bl = true;
            }
            if (string2 != null) {
                if (bl) {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append("a non-null thumbprint");
                bl = true;
            }
            _logger.debug((Object)stringBuilder.toString());
        }
        stringBuilder = this.createHttpConfig(keyStore, string, string2);
        return stringBuilder;
    }

    protected HttpConfiguration createHttpConfig(@Nullable KeyStore keyStore, @Nullable String string, @Nullable String string2) {
        X509Certificate x509Certificate;
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("Creating a new HttpConfiguration:\n" + ExceptionUtil.getCurrentStackTrace()));
        } else {
            _logger.debug((Object)"Creating a new HttpConfiguration");
        }
        HttpConfigurationImpl httpConfigurationImpl = new HttpConfigurationImpl();
        httpConfigurationImpl.setMaxConnections(this._maxConnections);
        httpConfigurationImpl.setDefaultMaxConnectionsPerRoute(this._maxConnectionsPerRoute);
        httpConfigurationImpl.setDefaultMaxConnectionsPerRoute(this._maxConnections);
        httpConfigurationImpl.setTimeoutMs(this._timeoutInMillis);
        httpConfigurationImpl.setConnectTimeoutMs(this._connectionTimeoutInMillis);
        httpConfigurationImpl.setKeepAlivePeriod((long)this._keepAlivePeriodMillis);
        httpConfigurationImpl.setUserAgent(this._userAgent);
        if (this._enabledProtocols != null) {
            httpConfigurationImpl.setEnabledProtocols(this._enabledProtocols);
        }
        if (keyStore == null && !StringUtil.isNullOrWhitespace((String)string)) {
            try {
                x509Certificate = (X509Certificate)CertificateUtil.generateCertificate((String)string);
                _logger.debug((Object)"No keystore available. Creating a custom keystore");
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null);
                keyStore.setEntry(DEFAULT_ALIAS, new KeyStore.TrustedCertificateEntry(x509Certificate), null);
            }
            catch (Exception exception) {
                _logger.warn((Object)"Error when creating IS certificate keystore.", (Throwable)exception);
            }
        }
        if (keyStore != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Setting KeyStore: " + KeystoreUtil.getInfoAboutKeyStore(keyStore)));
            }
            httpConfigurationImpl.setTrustStore(keyStore);
        }
        if (!StringUtil.isNullOrWhitespace((String)string2)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Setting a thumbprint verifier for thumbprint: " + string2));
            }
            x509Certificate = ThumbprintVerifier.Factory.createAllowKnownThumbprintVerifier((String[])new String[]{string2});
        } else {
            _logger.debug((Object)"Setting an allow-all thumbprint verifier");
            x509Certificate = ALLOW_ALL_THUMBPRINT_VERIFIER;
        }
        httpConfigurationImpl.setThumbprintVerifier((ThumbprintVerifier)x509Certificate);
        return httpConfigurationImpl;
    }

    @Override
    public void releaseHttpConfig(String string) {
        this.releaseHttpConfig(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseHttpConfig(String string, boolean bl) {
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("identifier is null or whitespace");
        }
        this._lock.writeLock().lock();
        try {
            SharedHttpConfig sharedHttpConfig = this._httpConfigDataByUrl.get(string);
            if (sharedHttpConfig == null) {
                return;
            }
            int n = sharedHttpConfig.decrementAndGetActiveSessionCount();
            if (bl || n == 0) {
                this._httpConfigDataByUrl.remove(string);
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        protected KeystoreService _keystoreService;
        @Nonnegative
        protected int _maxConnections = 500;
        @Nonnegative
        protected int _maxConnectionsPerRoute = 500;
        @Nonnegative
        protected int _connectionTimeoutInMillis = 120000;
        @Nonnegative
        protected int _timeoutInMillis = 1200000;
        protected int _keepAlivePeriodMillis = 45000;
        @Nonnull
        protected String _userAgent = "web-client/6.5.0";
        @Nullable
        protected String[] _enabledProtocols;

        public SharedHttpConfigPool build() {
            return new SharedHttpConfigPool(this._keystoreService, this._maxConnections, this._maxConnectionsPerRoute, this._timeoutInMillis, this._connectionTimeoutInMillis, this._keepAlivePeriodMillis, this._userAgent, this._enabledProtocols);
        }

        public Builder keyStoreService(@Nullable KeystoreService keystoreService) {
            this._keystoreService = keystoreService;
            return this;
        }

        public Builder maxConnections(@Nonnegative int n) {
            Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The connection Pool must have at least 1 connection: ", (long)n);
            this._maxConnections = n;
            return this;
        }

        public Builder maxConnectionsPerRoute(@Nonnegative int n) {
            Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The connection Pool must have at least 1 connection per route: ", (long)n);
            this._maxConnectionsPerRoute = n;
            return this;
        }

        public Builder connectionTimeoutInMillis(@Nonnegative int n) {
            Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The connection Timeout must be at least 1 millisecond: ", (long)n);
            this._connectionTimeoutInMillis = n;
            return this;
        }

        public Builder timeoutInMillis(@Nonnegative int n) {
            Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The timeout must be at least 1 millisecond: ", (long)n);
            this._timeoutInMillis = n;
            return this;
        }

        public Builder keepAlivePeriodMillis(@Nonnegative int n) {
            this._keepAlivePeriodMillis = n;
            return this;
        }

        public Builder userAgent(@Nonnull String string) {
            Validate.notEmpty((String)string, (String)"User agent cannot be null or empty.");
            this._userAgent = string;
            return this;
        }

        public Builder enabledProtocols(@Nonnull String string) {
            Validate.notNull((Object)string, (String)"commaSeparatedProtocols is null");
            String[] stringArray = string.split(",");
            this.enabledProtocols(stringArray);
            return this;
        }

        public Builder enabledProtocols(@Nonnull String[] stringArray) {
            ValidationUtil.noNullOrWhitespaceElements((String[])stringArray, (boolean)false);
            this._enabledProtocols = stringArray;
            return this;
        }

        public Builder sslConfigurationProvider(@Nonnull SSLConfigurationProvider sSLConfigurationProvider) {
            Validate.notNull((Object)sSLConfigurationProvider, (String)"sslConfigurationProvider is null");
            this._enabledProtocols = sSLConfigurationProvider.getEnabledProtocols();
            return this;
        }
    }

    protected static class SharedHttpConfig {
        private final HttpConfiguration _httpConfig;
        @GuardedBy(value="SharedHttpConfigPool._lock")
        private int _activeSessionCount;

        public SharedHttpConfig(@Nonnull HttpConfiguration httpConfiguration) {
            Validate.notNull((Object)httpConfiguration, (String)"httpConfig is null");
            this._httpConfig = httpConfiguration;
            this._activeSessionCount = 0;
        }

        public HttpConfiguration getHttpConfiguration() {
            return this._httpConfig;
        }

        public int incrementAndGetActiveSessionCount() {
            ++this._activeSessionCount;
            return this._activeSessionCount;
        }

        public int decrementAndGetActiveSessionCount() {
            --this._activeSessionCount;
            return this._activeSessionCount;
        }

        public void setTheSameActiveSessionCountAs(@Nonnull SharedHttpConfig sharedHttpConfig) {
            this._activeSessionCount = sharedHttpConfig._activeSessionCount;
        }
    }
}

