/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi;

import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.FactoryBean;

public class SharedHttpConfigPoolFactoryBean
implements FactoryBean<SharedHttpConfigPool> {
    @Nullable
    protected KeystoreService _keystoreService;
    @Nullable
    protected Integer _maxConnections;
    @Nullable
    protected Integer _maxConnectionsPerRoute;
    @Nullable
    protected Integer _connectionTimeoutInMillis;
    @Nullable
    protected Integer _timeoutInMillis;
    @Nullable
    protected Integer _keepAlivePeriodMillis;
    @Nullable
    protected String _commaSeparatedEnabledProtocols;
    @Nullable
    protected String _userAgent;
    @Nullable
    protected String[] _enabledProtocols;
    @Nullable
    protected SSLConfigurationProvider _sslConfigurationProvider;

    public SharedHttpConfigPool getObject() throws Exception {
        SharedHttpConfigPool.Builder builder = new SharedHttpConfigPool.Builder();
        this.populateBuilderFields(builder);
        return builder.build();
    }

    protected void populateBuilderFields(SharedHttpConfigPool.Builder builder) {
        builder.keyStoreService(this._keystoreService);
        if (this._maxConnections != null) {
            builder.maxConnections(this._maxConnections);
        }
        if (this._maxConnectionsPerRoute != null) {
            builder.maxConnectionsPerRoute(this._maxConnectionsPerRoute);
        }
        if (this._connectionTimeoutInMillis != null) {
            builder.connectionTimeoutInMillis(this._connectionTimeoutInMillis);
        }
        if (this._timeoutInMillis != null) {
            builder.timeoutInMillis(this._timeoutInMillis);
        }
        if (this._keepAlivePeriodMillis != null) {
            builder.keepAlivePeriodMillis(this._keepAlivePeriodMillis);
        }
        if (this._commaSeparatedEnabledProtocols != null) {
            builder.enabledProtocols(this._commaSeparatedEnabledProtocols);
        }
        if (this._userAgent != null) {
            builder.userAgent(this._userAgent);
        }
        if (this._enabledProtocols != null) {
            builder.enabledProtocols(this._enabledProtocols);
        }
        if (this._sslConfigurationProvider != null) {
            builder.sslConfigurationProvider(this._sslConfigurationProvider);
        }
    }

    public Class<?> getObjectType() {
        return SharedHttpConfigPool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setKeyStoreService(@Nullable KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setMaxConnections(Integer n) {
        if (n == null) {
            return;
        }
        Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The connection pool must have at least 1 connection: ", (Object)n);
        this._maxConnections = n;
    }

    public void setMaxConnectionsPerRoute(Integer n) {
        if (n == null) {
            return;
        }
        Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The connection pool must have at least 1 connection per route: ", (Object)n);
        this._maxConnectionsPerRoute = n;
    }

    public void setConnectionTimeoutInMillis(Integer n) {
        if (n == null) {
            return;
        }
        Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The connection timeout must be at least 1 millisecond: ", (Object)n);
        this._connectionTimeoutInMillis = n;
    }

    public void setTimeoutInMillis(Integer n) {
        if (n == null) {
            return;
        }
        Validate.isTrue((n >= 1 ? 1 : 0) != 0, (String)"The timeout must be at least 1 millisecond: ", (Object)n);
        this._timeoutInMillis = n;
    }

    public void setKeepAlivePeriodMillis(Integer n) {
        this._keepAlivePeriodMillis = n;
    }

    public void setUserAgent(String string) {
        this._userAgent = string;
    }

    public void setEnabledProtocols(String string) {
        this._commaSeparatedEnabledProtocols = string;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this._enabledProtocols = stringArray;
    }

    public void setSslConfigurationProvider(SSLConfigurationProvider sSLConfigurationProvider) {
        this._sslConfigurationProvider = sSLConfigurationProvider;
    }
}

