/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.versionId;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vise.util.StringUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public class VmomiClientHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ManagedObject> T createStub(@Nonnull Client client, @Nonnull Class<T> clazz, @Nonnull ManagedObjectReference managedObjectReference, @Nullable ClassLoader classLoader) {
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"client is null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz is null");
        Preconditions.checkArgument((managedObjectReference != null ? 1 : 0) != 0, (Object)"mor is null");
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            ManagedObject managedObject;
            Thread.currentThread().setContextClassLoader(classLoader);
            ManagedObject managedObject2 = managedObject = client.createStub(clazz, managedObjectReference);
            return (T)managedObject2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ManagedObject> T createStub(@Nonnull Client client, @Nonnull Class<T> clazz, @Nonnull String string, @Nullable ClassLoader classLoader) {
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"client is null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz is null");
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"moId is null");
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            ManagedObject managedObject;
            Thread.currentThread().setContextClassLoader(classLoader);
            ManagedObject managedObject2 = managedObject = client.createStub(clazz, string);
            return (T)managedObject2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    public static VmodlVersion getVmodlVersion(Class<?> clazz) {
        Validate.notNull(clazz, (String)"vmodlVersionClass is null");
        VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        VmodlVersion vmodlVersion = vmodlVersionMap.getVersion(clazz);
        if (vmodlVersion == null) {
            throw new IllegalArgumentException("The class " + clazz.getCanonicalName() + " is not a VMODL version");
        }
        return vmodlVersion;
    }

    public static String getVersionIdOfVmodlVersion(Class<?> clazz) {
        Validate.notNull(clazz, (String)"vmodlVersion is null");
        versionId versionId2 = clazz.getAnnotation(versionId.class);
        if (versionId2 == null) {
            throw new IllegalArgumentException("The provided VIM version doesn't contain a @" + versionId.class.getSimpleName() + " annotation: " + clazz);
        }
        String string = versionId2.value();
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("The provided VIM version's @" + versionId.class.getSimpleName() + " annotation doesn't specify a version number: " + clazz);
        }
        return string;
    }
}

