/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.context.support;

import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.messaging.util.WebUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class ClientSessionScope
implements Scope,
UserSessionListener {
    private static final String REFERENCE_CLIENT_SESSION = "client_session";
    private static final String CONTEXTUAL_OBJECT_KEY = "CONTEXTUAL_OBJECT_KEY";
    private static final String DESTRUCTION_CALLBACK_LIST_KEY = "DESTRUCTION_CALLBACK_LIST_KEY";

    public Object get(String string, ObjectFactory<?> objectFactory) {
        Map<String, Object> map = this.getOrCreateContextualObject();
        if (!map.containsKey(string)) {
            map.put(string, objectFactory.getObject());
        }
        return map.get(string);
    }

    public Object remove(String string) {
        return this.getOrCreateContextualObject().remove(string);
    }

    public void registerDestructionCallback(String string, Runnable runnable) {
        this.getOrCreateDestructionCallbackList(this.getOrCreateContextualObject()).add(runnable);
    }

    public Object resolveContextualObject(String string) {
        Map<String, Object> map = null;
        if (REFERENCE_CLIENT_SESSION.equals(string)) {
            map = this.getOrCreateContextualObject();
        }
        return map;
    }

    public String getConversationId() {
        return null;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.getData((String)CONTEXTUAL_OBJECT_KEY, (HttpSession)httpSessionEvent.getSession());
        List<Runnable> list = this.getOrCreateDestructionCallbackList(map);
        for (Runnable runnable : list) {
            runnable.run();
        }
    }

    private List<Runnable> getOrCreateDestructionCallbackList(Map<String, Object> map) {
        List<Runnable> list = new ArrayList<Runnable>();
        if (map != null && (list = (List)map.get(DESTRUCTION_CALLBACK_LIST_KEY)) == null) {
            list = new ArrayList();
            map.put(DESTRUCTION_CALLBACK_LIST_KEY, list);
        }
        return list;
    }

    private Map<String, Object> getOrCreateContextualObject() {
        String string = WebUtils.getCurrentClientId();
        HashMap hashMap = (HashMap)SessionUtil.getData((String)CONTEXTUAL_OBJECT_KEY, (String)string);
        if (hashMap == null) {
            hashMap = new HashMap();
            SessionUtil.setData((String)CONTEXTUAL_OBJECT_KEY, hashMap, (String)string);
        }
        return hashMap;
    }
}

