/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.util;

import com.vmware.vise.util.ValidationUtil;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LiveUpdatesExecutor
implements Executor {
    private static final Log _logger = LogFactory.getLog(LiveUpdatesExecutor.class);
    private static final int QUEUE_LIMIT = 2048;
    private final ConcurrentLinkedQueue<Runnable> _queue = new ConcurrentLinkedQueue();
    private final AtomicInteger _queuedTasks = new AtomicInteger(0);
    private final ThreadPoolExecutor _executor;
    private final AtomicBoolean _isTaskExecuting = new AtomicBoolean(false);

    private boolean offer(Runnable runnable) {
        if (this._queuedTasks.get() >= 2048) {
            _logger.error((Object)"Queue size full. Number of queued tasks for user:2048");
            return false;
        }
        this._queuedTasks.incrementAndGet();
        return this._queue.offer(runnable);
    }

    private Runnable poll() {
        Runnable runnable = this._queue.poll();
        if (runnable != null) {
            this._queuedTasks.decrementAndGet();
        }
        return runnable;
    }

    public LiveUpdatesExecutor(ThreadPoolExecutor threadPoolExecutor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{threadPoolExecutor});
        this._executor = threadPoolExecutor;
    }

    @Override
    public void execute(Runnable runnable) {
        if (!this.offer(runnable)) {
            _logger.error((Object)"Couldn't execute the task!");
            return;
        }
        if (this._isTaskExecuting.compareAndSet(false, true)) {
            try {
                this._executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Runnable runnable;
                        if (!LiveUpdatesExecutor.this._isTaskExecuting.get()) {
                            _logger.error((Object)"Invalid _taskExecutingFlag before processing the queue. Expected true.");
                        }
                        LiveUpdatesExecutor.this.processQueue();
                        if (!LiveUpdatesExecutor.this._isTaskExecuting.compareAndSet(true, false)) {
                            _logger.error((Object)"Invalid _taskExecutingFlag after processed the queue. Expected true.");
                        }
                        if ((runnable = LiveUpdatesExecutor.this.poll()) != null) {
                            LiveUpdatesExecutor.this.execute(runnable);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                _logger.error((Object)"Rejected execution:", (Throwable)rejectedExecutionException);
                this._isTaskExecuting.set(false);
            }
        }
    }

    private void processQueue() {
        Runnable runnable = null;
        while ((runnable = this.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                _logger.error((Object)"Error running task:", (Throwable)exception);
            }
        }
    }
}

