/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.messaging.marshall.Marshaller;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.websocket.CloseReason;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageSender {
    private static final Log _logger = LogFactory.getLog(MessageSender.class);
    private final List<Session> _sessions = new CopyOnWriteArrayList<Session>();
    private final Marshaller _marshaller;
    private Runnable _onCloseCallback;

    public MessageSender(Marshaller marshaller) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{marshaller});
        this._marshaller = marshaller;
    }

    public void onClose(Runnable runnable) {
        this._onCloseCallback = runnable;
    }

    public void addSession(Session session) {
        this._sessions.add(session);
    }

    public void removeSession(Session session) {
        this._sessions.remove(session);
        if (this._sessions.isEmpty() && this._onCloseCallback != null) {
            this._onCloseCallback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object object) {
        String string;
        if (object == null) {
            return;
        }
        try {
            string = this._marshaller.marshall(object);
        }
        catch (IOException iOException) {
            _logger.error((Object)"Error marshalling message", (Throwable)iOException);
            return;
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        for (Session session : this._sessions) {
            RemoteEndpoint.Basic basic;
            if (!session.isOpen()) {
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug((Object)("Skip sending message to websocket session: " + session.getId() + " as it is already closed."));
                continue;
            }
            RemoteEndpoint.Basic basic2 = basic = session.getBasicRemote();
            synchronized (basic2) {
                try {
                    basic.sendText(string);
                }
                catch (IllegalStateException illegalStateException) {
                    _logger.error((Object)("Error sending message to websocket session: " + session.getId()), (Throwable)illegalStateException);
                    try {
                        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, "Error sending message to ws."));
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("Error closing websocket session: " + session.getId()), (Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    _logger.error((Object)("Error sending message to websocket session: " + session.getId()), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToSession(Object object, Session session) {
        RemoteEndpoint.Basic basic;
        String string;
        if (object == null) {
            return;
        }
        if (!session.isOpen() && _logger.isDebugEnabled()) {
            _logger.debug((Object)("Skip sending message to websocket session: " + session.getId() + " as it is already closed."));
        }
        try {
            string = this._marshaller.marshall(object);
        }
        catch (IOException iOException) {
            _logger.error((Object)"Error marshalling message", (Throwable)iOException);
            return;
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        RemoteEndpoint.Basic basic2 = basic = session.getBasicRemote();
        synchronized (basic2) {
            try {
                basic.sendText(string);
            }
            catch (IllegalStateException illegalStateException) {
                _logger.error((Object)("Error sending message to websocket session: " + session.getId()), (Throwable)illegalStateException);
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, "Error sending message to ws."));
                }
                catch (Exception exception) {
                    _logger.error((Object)("Error closing websocket session: " + session.getId()), (Throwable)exception);
                }
            }
            catch (Exception exception) {
                _logger.error((Object)("Error sending message to websocket session: " + session.getId()), (Throwable)exception);
            }
        }
    }
}

