/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket;

import com.vmware.vise.vim.messaging.websocket.EndpointConfig;
import com.vmware.vise.vim.messaging.websocket.LiveUpdatesEndpoint;
import com.vmware.vise.vim.messaging.websocket.SelfRefreshEndpoint;
import com.vmware.vise.vim.messaging.websocket.webconsole.RemoteConsoleEndpoint;
import com.vmware.vise.vim.messaging.websocket.webconsole.RemoteConsoleEndpointConfig;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebsocketInitializer
implements ServletContextListener {
    private static final Log _logger = LogFactory.getLog(WebsocketInitializer.class);
    private static final String SERVER_CONTAINER_ATTRIBUTE = "javax.websocket.server.ServerContainer";
    private static final String LIVE_UPDATES_WEBSOCKET_ENDPOINT = "/live-updates";
    private static final String SELF_REFRESH_WEBSOCKET_ENDPOINT = "/messaging";
    private static final String REMOTE_CONSOLE_WEBSOCKET_ENDPOINT = "/webconsole/authd";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute(SERVER_CONTAINER_ATTRIBUTE);
        try {
            serverContainer.addEndpoint((ServerEndpointConfig)new EndpointConfig(LiveUpdatesEndpoint.class, LIVE_UPDATES_WEBSOCKET_ENDPOINT));
            _logger.info((Object)"Registered websocket endpoint at /live-updates");
            serverContainer.addEndpoint((ServerEndpointConfig)new EndpointConfig(SelfRefreshEndpoint.class, SELF_REFRESH_WEBSOCKET_ENDPOINT));
            _logger.info((Object)"Registered websocket endpoint at /messaging");
            serverContainer.addEndpoint((ServerEndpointConfig)new RemoteConsoleEndpointConfig(RemoteConsoleEndpoint.class, REMOTE_CONSOLE_WEBSOCKET_ENDPOINT));
            _logger.info((Object)"Registered websocket endpoint at /webconsole/authd");
        }
        catch (DeploymentException deploymentException) {
            _logger.error((Object)"Error registering websocket endpoint:", (Throwable)deploymentException);
        }
        Set set = serverContainer.getInstalledExtensions();
        _logger.info((Object)("Installed extensions: " + set.size()));
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        _logger.info((Object)"WebsocketInitializer context destroyed.");
    }
}

