/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket.webconsole;

import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RelayTask
implements Runnable {
    private static final Log _logger = LogFactory.getLog(RelayTask.class);
    private static final int BUFFER_SIZE = 4096;
    private static final long END_OF_FILE_WAIT_INTERVAL_MILLIS = 100L;
    private final Socket _authdSocket;
    private final Session _websocketSession;

    public RelayTask(Socket socket, Session session) {
        this._authdSocket = socket;
        this._websocketSession = session;
    }

    @Override
    public void run() {
        this.runSocket();
    }

    private void runSocket() {
        InputStream inputStream;
        try {
            inputStream = this._authdSocket.getInputStream();
        }
        catch (IOException iOException) {
            _logger.error((Object)"Error getting an input stream from the authd socket: ", (Throwable)iOException);
            return;
        }
        try {
            byte[] byArray = new byte[4096];
            this.runLoop(byArray, inputStream);
        }
        catch (SocketException socketException) {
            _logger.info((Object)("The _authdSocket was closed. Stopping the remote console thread.SocketException code (expected, not an error): " + socketException));
        }
        catch (IOException iOException) {
            _logger.error((Object)"An error occurred while reading from the _authdSocket to the outbound", (Throwable)iOException);
        }
        finally {
            StreamUtil.close((Closeable)inputStream);
            try {
                this._authdSocket.close();
                this._websocketSession.close();
            }
            catch (IOException iOException) {
                _logger.error((Object)"Failed to close socket connections", (Throwable)iOException);
            }
        }
    }

    private void runLoop(byte[] byArray, InputStream inputStream) throws IOException {
        while (this._websocketSession.isOpen()) {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
                this._websocketSession.getBasicRemote().sendBinary(byteBuffer);
            }
            _logger.info((Object)"Encountered EOF character, sleeping for 100 ms.");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

