/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket.webconsole;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.vim.messaging.websocket.webconsole.AuthdClient;
import com.vmware.vise.vim.messaging.websocket.webconsole.RelayTask;
import com.vmware.vise.vim.messaging.websocket.webconsole.RemoteConsoleBinaryMessageHandler;
import com.vmware.vise.vim.messaging.websocket.webconsole.RemoteConsoleConnectionHolder;
import com.vmware.vise.vim.messaging.websocket.webconsole.RemoteConsoleTextMessageHandler;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteConsoleEndpoint
extends Endpoint {
    private static final Log _logger = LogFactory.getLog(RemoteConsoleEndpoint.class);
    private static final int MAX_CONNECTIONS = 300;
    private static final String TICKET = "ticket";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String CFG_FILE = "cfgFile";
    private static final String THUMBPRINT = "thumbprint";
    private static final String ENCODING = "encoding";
    private static final String VM_ID = "vmId";
    private final RemoteConsoleConnectionHolder _connectionHolder;
    private final Executor _executor;

    public RemoteConsoleEndpoint(RemoteConsoleConnectionHolder remoteConsoleConnectionHolder) {
        this._connectionHolder = remoteConsoleConnectionHolder;
        this._executor = ThreadPoolFactory.newQueingCachedThreadPool((int)300, (ThreadFactory)new WorkerThreadFactory("remote-console-message-pool"), (long)2L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CANCEL);
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        Socket socket;
        String string;
        String string2;
        Map map = session.getRequestParameterMap();
        this.validateRequiredParams(map, HOST, PORT, CFG_FILE, TICKET, THUMBPRINT, VM_ID);
        String string3 = this.getRequestParamValue(map, ENCODING);
        if (StandardCharsets.UTF_8.name().equals(string3)) {
            string2 = this.getRequestParamValue(map, HOST);
            string = this.getRequestParamValue(map, CFG_FILE);
        } else {
            string2 = new String(this.getRequestParamValue(map, HOST).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            string = new String(this.getRequestParamValue(map, CFG_FILE).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        string2 = this.sanitize(string2);
        string = this.sanitize(string);
        String string4 = this.sanitize(this.getRequestParamValue(map, VM_ID));
        String string5 = this.sanitize(this.getRequestParamValue(map, PORT));
        int n = string5 != null ? Integer.parseInt(string5) : -1;
        String string6 = this.sanitize(this.getRequestParamValue(map, TICKET));
        String string7 = this.sanitize(this.getRequestParamValue(map, THUMBPRINT));
        try {
            AuthdClient authdClient = RemoteConsoleEndpoint.createSocketConnection(string2, string4, n, string, string6, string7);
            socket = authdClient.connect();
            this._connectionHolder.addConnection(session, authdClient);
            _logger.info((Object)("[webconsole] opened for vm -  " + string4 + " and the socket on which opened " + socket));
            if ("binary".equals(session.getNegotiatedSubprotocol())) {
                session.addMessageHandler((MessageHandler)new RemoteConsoleBinaryMessageHandler(session, string4, socket, socket.getOutputStream()));
            } else {
                session.addMessageHandler((MessageHandler)new RemoteConsoleTextMessageHandler(socket.getOutputStream()));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this._executor.execute(new RelayTask(socket, session));
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        AuthdClient authdClient = this._connectionHolder.removeConnection(session);
        if (authdClient == null) {
            return;
        }
        try {
            String string = this.sanitize(this.getRequestParamValue(session.getRequestParameterMap(), VM_ID));
            _logger.info((Object)("[webconsole] onclose called for vm -  " + string));
            authdClient.disconnect();
        }
        catch (IOException iOException) {
            _logger.error((Object)"[webconsole] An error occurred while calling the authdclient disconnect method ", (Throwable)iOException);
        }
    }

    public void onError(Session session, Throwable throwable) {
        if (throwable != null) {
            _logger.error((Object)("[webconsole] An error occurred and the throwable is " + ExceptionUtil.getStackTrace((Throwable)throwable)));
        }
        super.onError(session, throwable);
        AuthdClient authdClient = this._connectionHolder.removeConnection(session);
        if (authdClient == null) {
            return;
        }
        try {
            String string = this.sanitize(this.getRequestParamValue(session.getRequestParameterMap(), VM_ID));
            _logger.info((Object)("[webconsole] onError called for vm -  " + string));
            authdClient.disconnect();
        }
        catch (IOException iOException) {
            _logger.error((Object)"[webconsole] An error occurred while calling the authdclient disconnect method ", (Throwable)iOException);
        }
    }

    private void validateRequiredParams(Map<String, List<String>> map, String ... stringArray) {
        for (String string : stringArray) {
            if (map.containsKey(string)) continue;
            _logger.error((Object)("[webconsole]  Required parameter '" + string + "' is missing."));
            throw new IllegalArgumentException("[webconsole]  Required parameter '" + string + "' is missing.");
        }
    }

    private String sanitize(String string) {
        if (string == null || "".equals(string.trim())) {
            return null;
        }
        return string;
    }

    private static AuthdClient createSocketConnection(String string, String string2, int n, String string3, String string4, String string5) throws IOException {
        AuthdClient authdClient = new AuthdClient(string, string2, n, string3, string4, string5);
        return authdClient;
    }

    private String getRequestParamValue(Map<String, List<String>> map, String string) {
        List<String> list = map.get(string);
        if (ArrayUtil.isNullOrEmpty(list)) {
            return null;
        }
        return list.get(0);
    }
}

