/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.client.vcenter;

import com.vmware.cdc.client.vcenter.AsyncCallback;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.vcenter.listener.vmomi.VmomiServiceStubFactory;
import com.vmware.vim.binding.vim.cdc.ChangeLogCollector;
import com.vmware.vim.binding.vim.cdc.ChangeSet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.RequestCanceled;
import com.vmware.vim.vmomi.core.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncVmomiChangeLogCollector {
    private static final Logger _logger = LoggerFactory.getLogger(AsyncVmomiChangeLogCollector.class);
    private static final String CHANGE_LOG_COLLECTOR_TYPE_NAME = "CDCChangeLogCollector";
    private static final String CHANGE_LOG_COLLECTOR_MO_NAME = "ChangeLogCollector";
    private final ChangeLogCollector _stub;
    private final AtomicReference<String> _sequenceToken = new AtomicReference();
    private final AtomicBoolean _pendingSubscription = new AtomicBoolean(false);
    private final AtomicReference<Runnable> _scheduledModify = new AtomicReference();

    public AsyncVmomiChangeLogCollector(VmomiServiceStubFactory vmomiServiceStubFactory) {
        if (vmomiServiceStubFactory == null) {
            throw new IllegalArgumentException("Argument 'vmomiServiceStubFactory' must not be null.");
        }
        ManagedObjectReference moRef = new ManagedObjectReference(CHANGE_LOG_COLLECTOR_TYPE_NAME, CHANGE_LOG_COLLECTOR_MO_NAME, null);
        this._stub = vmomiServiceStubFactory.createServiceStub(ChangeLogCollector.class, moRef);
    }

    public void subscribe(ChangeLog changeLog, AsyncCallback<Void> callback) {
        if (changeLog == null) {
            throw new IllegalArgumentException("Argument 'changeLog' must no be null.");
        }
        this.validateCallback(callback);
        this.modifySubscription(new String[]{changeLog.value()}, null, callback);
    }

    public void subscribe(ChangeLog[] changeLogs, AsyncCallback<Void> callback) {
        if (changeLogs == null || changeLogs.length == 0) {
            throw new IllegalArgumentException("Argument 'changeLogs' must no be null or empty.");
        }
        this.validateCallback(callback);
        String[] changeLogNames = new String[changeLogs.length];
        for (int i = 0; i < changeLogs.length; ++i) {
            changeLogNames[i] = changeLogs[i].value();
        }
        this.modifySubscription(changeLogNames, null, callback);
    }

    public void unsubscribe(ChangeLog changeLog, AsyncCallback<Void> callback) {
        if (changeLog == null) {
            throw new IllegalArgumentException("Argument 'changeLog' must no be null.");
        }
        if (!this._pendingSubscription.get() && this._sequenceToken.get() == null) {
            throw new IllegalStateException("Method subscribe() must be called before modifying subscription.");
        }
        this.validateCallback(callback);
        this.modifySubscription(null, new String[]{changeLog.value()}, callback);
    }

    private void modifySubscription(final String[] add, final String[] remove, final AsyncCallback<Void> callback) {
        if (this._pendingSubscription.compareAndSet(false, true)) {
            this.executeSubscription(add, remove, callback);
            return;
        }
        Runnable modifyTask = new Runnable(){

            @Override
            public void run() {
                AsyncVmomiChangeLogCollector.this.executeSubscription(add, remove, callback);
            }
        };
        if (!this._scheduledModify.compareAndSet(null, modifyTask)) {
            throw new IllegalStateException("Cannot schedule more than one subcription modification.");
        }
        this.executeIfScheduledModify();
    }

    private void executeSubscription(String[] add, String[] remove, AsyncCallback<Void> callback) {
        String sequence = this._sequenceToken.get();
        if (sequence == null) {
            this._stub.initializeSequence(add, this.getSubscriptionFuture(callback));
        } else {
            this._stub.exchangeSequence(sequence, add, remove, this.getSubscriptionFuture(callback));
        }
    }

    private ChangeLogFuture<String> getSubscriptionFuture(final AsyncCallback<Void> callback) {
        return new ChangeLogFuture<String>(){

            @Override
            public void set(String sequence) {
                _logger.info("Sequence token set to: {}", (Object)sequence);
                AsyncVmomiChangeLogCollector.this._sequenceToken.set(sequence);
                AsyncVmomiChangeLogCollector.this._pendingSubscription.set(false);
                AsyncVmomiChangeLogCollector.this.executeIfScheduledModify();
                callback.onResult(null);
            }

            @Override
            public void setException(Exception e) {
                _logger.error("Error during subcription.", (Throwable)e);
                AsyncVmomiChangeLogCollector.this._scheduledModify.set(null);
                AsyncVmomiChangeLogCollector.this._pendingSubscription.set(false);
                callback.onException(e);
            }
        };
    }

    private void executeIfScheduledModify() {
        if (this._scheduledModify.get() != null && this._pendingSubscription.compareAndSet(false, true)) {
            Runnable modifyTask = this._scheduledModify.getAndSet(null);
            if (modifyTask != null) {
                modifyTask.run();
            } else {
                this._pendingSubscription.set(false);
            }
        }
    }

    public boolean waitForChanges(final AsyncCallback<ChangeSet> callback) {
        this.validateCallback(callback);
        if (this._pendingSubscription.get()) {
            return false;
        }
        final String sequenceToken = this._sequenceToken.get();
        if (sequenceToken == null) {
            throw new IllegalStateException("Method subscribe() must be called before waitForChanges()");
        }
        this._stub.waitForChanges(sequenceToken, (Future)new ChangeLogFuture<ChangeSet>(){

            @Override
            public void set(ChangeSet changes) {
                if (AsyncVmomiChangeLogCollector.this._pendingSubscription.get()) {
                    callback.onCancelled();
                    return;
                }
                if (AsyncVmomiChangeLogCollector.this._sequenceToken.compareAndSet(sequenceToken, changes.getSequence())) {
                    if (_logger.isTraceEnabled()) {
                        _logger.trace("Received change set: {}", (Object)changes);
                    }
                    callback.onResult(changes);
                } else {
                    callback.onCancelled();
                }
            }

            @Override
            public void setException(Exception e) {
                if (e instanceof InvalidArgument) {
                    _logger.warn("Sequence token expired: {}", (Object)sequenceToken, (Object)e);
                    callback.onException(new SequenceExpiredException(sequenceToken));
                } else if (e instanceof RequestCanceled) {
                    callback.onCancelled();
                } else {
                    _logger.warn("Exception during waitForChanges() call with sequence: {}", (Object)sequenceToken, (Object)e);
                    callback.onException(e);
                }
            }
        });
        return true;
    }

    private <T> void validateCallback(AsyncCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Argument callback must no be null.");
        }
    }

    private static abstract class ChangeLogFuture<T>
    implements Future<T> {
        private ChangeLogFuture() {
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public boolean isCancelled() {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public boolean isDone() {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public T get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public void set() {
            throw new UnsupportedOperationException("Method is not supported and should never be called.");
        }

        public abstract void set(T var1);

        public abstract void setException(Exception var1);
    }

    public static final class ChangeLog
    extends Enum<ChangeLog> {
        public static final /* enum */ ChangeLog INVENTORY = new ChangeLog("inventory");
        public static final /* enum */ ChangeLog ALARM_STATUS = new ChangeLog("alarmStatus");
        private final String _value;
        private static final /* synthetic */ ChangeLog[] $VALUES;

        public static ChangeLog[] values() {
            return (ChangeLog[])$VALUES.clone();
        }

        public static ChangeLog valueOf(String name) {
            return Enum.valueOf(ChangeLog.class, name);
        }

        private ChangeLog(String value) {
            assert (value != null);
            this._value = value;
        }

        public String value() {
            return this._value;
        }

        static {
            $VALUES = new ChangeLog[]{INVENTORY, ALARM_STATUS};
        }
    }
}

