/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.client.transport.vmomi;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.ImmutableChangeEvent;
import com.vmware.cdc.internal.ImmutableChangeList;
import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.vim.binding.vim.cdc.ChangeLogCollector;
import com.vmware.vim.binding.vim.cdc.ChangeSet;
import com.vmware.vim.binding.vim.cdc.InventoryChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VmomiChangeLogProxy
implements ChangeLog {
    private static final String CHANGE_LOG_COLLECTOR_MO_NAME = "ChangeLogCollector";
    private static final Logger _logger = LoggerFactory.getLogger(VmomiChangeLogProxy.class);
    private final ChangeLogCollector _changeLogCollectorStub;

    public VmomiChangeLogProxy(VmodlContext vmodlContext, Client vlsiClient) {
        assert (vmodlContext != null);
        assert (vlsiClient != null);
        this._changeLogCollectorStub = this.createStub(vmodlContext, vlsiClient);
    }

    @Override
    public ChangeList getChanges(String sequenceToken) throws SequenceExpiredException {
        try {
            ChangeSet vmodlChangeSet = this._changeLogCollectorStub.waitForChanges(sequenceToken);
            return this.convertFromBinding(vmodlChangeSet);
        }
        catch (InvalidArgument e) {
            String msg = "Invalid token '{}' used, will signal SequenceExpiredException: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Object)sequenceToken, (Object)e);
            } else {
                _logger.warn(msg + e.getMessage(), (Object)sequenceToken);
            }
            throw new SequenceExpiredException(sequenceToken);
        }
    }

    private ChangeList convertFromBinding(ChangeSet vmodlChangeSet) {
        List<ChangeEvent> changeEvents;
        if (ArrayUtils.isEmpty((Object[])vmodlChangeSet.inventoryChanges)) {
            changeEvents = Collections.emptyList();
        } else {
            changeEvents = new ArrayList(vmodlChangeSet.inventoryChanges.length);
            for (InventoryChange vmodlInventoryChange : vmodlChangeSet.inventoryChanges) {
                ChangeEvent event = this.convertFromBinding(vmodlInventoryChange);
                changeEvents.add(event);
            }
        }
        return new ImmutableChangeList(vmodlChangeSet.sequence, changeEvents);
    }

    private ChangeEvent convertFromBinding(InventoryChange vmodlInventoryChange) {
        ChangeEvent.ChangeKind kind;
        if (InventoryChange.Kind.created.name().equals(vmodlInventoryChange.kind)) {
            kind = ChangeEvent.ChangeKind.CREATE;
        } else if (InventoryChange.Kind.updated.name().equals(vmodlInventoryChange.kind)) {
            kind = ChangeEvent.ChangeKind.UPDATE;
        } else if (InventoryChange.Kind.deleted.name().equals(vmodlInventoryChange.kind)) {
            kind = ChangeEvent.ChangeKind.DELETE;
        } else {
            _logger.info("Ignoring ChangeEvent with unexpected ChangeKind = {}", (Object)vmodlInventoryChange.kind);
            return null;
        }
        ManagedObjectReference resourceId = vmodlInventoryChange.getObject();
        List<String> properties = ArrayUtils.isEmpty((Object[])vmodlInventoryChange.properties) ? null : Arrays.asList(vmodlInventoryChange.properties);
        return new ImmutableChangeEvent(kind, resourceId, resourceId.getType(), properties);
    }

    @Override
    public String getCurrentSequence() {
        return this._changeLogCollectorStub.initializeSequence(new String[]{ChangeLogCollector.ChangeLog.RESOURCE.value()});
    }

    private ChangeLogCollector createStub(VmodlContext vmodlContext, Client client) {
        String changeLogTypeName = vmodlContext.getVmodlTypeMap().getVmodlType(ChangeLogCollector.class).getWsdlName();
        ManagedObjectReference ref = new ManagedObjectReference(changeLogTypeName, CHANGE_LOG_COLLECTOR_MO_NAME, null);
        return (ChangeLogCollector)client.createStub(ChangeLogCollector.class, ref);
    }
}

