/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.provider.transport.vapi;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.provider.transport.ChangeLogResolver;
import com.vmware.cdc.transport.vapi.ChangeLogProvider;
import com.vmware.cdc.transport.vapi.ChangeLogTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.InternalServerError;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeLogProviderImpl
implements ChangeLogProvider,
Runnable {
    private static Logger _logger = LoggerFactory.getLogger(ChangeLogProviderImpl.class);
    private final ChangeLogResolver _changeLogResolver;
    private final int _maxConcurrentInvocations;
    private final long _pollIntervalMs;
    private final int _maxPollCount;
    private final BlockingQueue<GetChangesInvocation> _pendingInvocations;
    private final AtomicInteger _pendingInvocationCount;
    private final AtomicBoolean _monitorIsAlive;

    public ChangeLogProviderImpl(ChangeLogResolver changeLogResolver, Executor executor, int maxConcurrentInvocations, long pollIntervalMs, int maxPollCount) {
        assert (changeLogResolver != null);
        assert (executor != null);
        assert (maxConcurrentInvocations > 0);
        assert (pollIntervalMs > 0L);
        assert (maxPollCount > 0);
        this._changeLogResolver = changeLogResolver;
        this._maxConcurrentInvocations = maxConcurrentInvocations;
        this._pollIntervalMs = pollIntervalMs;
        this._maxPollCount = maxPollCount;
        this._pendingInvocations = new ArrayBlockingQueue<GetChangesInvocation>(maxConcurrentInvocations);
        this._pendingInvocationCount = new AtomicInteger(0);
        this._monitorIsAlive = new AtomicBoolean(false);
        executor.execute(this);
    }

    @Override
    public void getChanges(String sequenceToken, AsyncContext<ChangeLogTypes.ChangeList> context) {
        assert (sequenceToken != null);
        assert (context != null);
        ChangeLog changeLog = this._changeLogResolver.fromInvocationContext(context.getInvocationContext());
        if (!this._monitorIsAlive.get()) {
            context.setError((RuntimeException)ChangeLogProviderImpl.newInternalError("Monitor of long-running ChangeLog operations is dead.", "error.cdc.monitorDead"));
            return;
        }
        int count = this._pendingInvocationCount.incrementAndGet();
        if (count > this._maxConcurrentInvocations) {
            this._pendingInvocationCount.decrementAndGet();
            context.setError((RuntimeException)ChangeLogProviderImpl.newInternalError("Too many concurrent invocations", "error.cdc.tooManyConcurrentInvocations"));
            return;
        }
        GetChangesInvocation invocation = new GetChangesInvocation(changeLog, sequenceToken, context, this._maxPollCount);
        this._pendingInvocations.add(invocation);
    }

    @Override
    public void getCurrentSequence(AsyncContext<String> context) {
        assert (context != null);
        ChangeLog changeLog = this._changeLogResolver.fromInvocationContext(context.getInvocationContext());
        String sequence = changeLog.getCurrentSequence();
        context.setResult((Object)sequence);
    }

    private static ChangeLogTypes.ChangeList toVapiChangeList(ChangeList changeList) {
        assert (changeList != null);
        ArrayList<ChangeLogTypes.ChangeEvent> vapiChanges = new ArrayList<ChangeLogTypes.ChangeEvent>(changeList.getChanges().size());
        for (ChangeEvent changeEvent : changeList.getChanges()) {
            ChangeLogTypes.ChangeEvent vapiChangeEvent = ChangeLogProviderImpl.toVapiChangeEvent(changeEvent);
            vapiChanges.add(vapiChangeEvent);
        }
        ChangeLogTypes.ChangeList vapiChangeList = new ChangeLogTypes.ChangeList();
        vapiChangeList.setChanges(vapiChanges);
        vapiChangeList.setSequence(changeList.getSequence());
        return vapiChangeList;
    }

    private static ChangeLogTypes.ChangeEvent toVapiChangeEvent(ChangeEvent changeEvent) {
        String vapiResType;
        String vapiResId;
        assert (changeEvent != null);
        ChangeLogTypes.ChangeEvent vapiChangeEvent = new ChangeLogTypes.ChangeEvent();
        vapiChangeEvent.setKind(ChangeLogProviderImpl.toVapiChangeKind(changeEvent.getKind()));
        Object resource = changeEvent.getResource();
        if (resource instanceof ManagedObjectReference) {
            ManagedObjectReference moRef = (ManagedObjectReference)resource;
            vapiResId = CisIdConverter.toGlobalCisId((ManagedObjectReference)moRef, (String)moRef.getServerGuid());
            vapiResType = moRef.getType();
        } else if (resource instanceof String) {
            vapiResId = (String)resource;
            vapiResType = changeEvent.getResourceType();
        } else {
            throw new IllegalArgumentException(String.format("Can't handle resource identifier of type %s: %s", changeEvent.getResource().getClass(), changeEvent.getResource()));
        }
        DynamicID vapiId = new DynamicID(vapiResType, vapiResId);
        vapiChangeEvent.setResource(vapiId);
        vapiChangeEvent.setProperties(changeEvent.getProperties());
        return vapiChangeEvent;
    }

    private static ChangeLogTypes.ChangeEvent.ChangeKind toVapiChangeKind(ChangeEvent.ChangeKind changeKind) {
        assert (changeKind != null);
        switch (changeKind) {
            case CREATE: {
                return ChangeLogTypes.ChangeEvent.ChangeKind.CREATE;
            }
            case DELETE: {
                return ChangeLogTypes.ChangeEvent.ChangeKind.DELETE;
            }
            case UPDATE: {
                return ChangeLogTypes.ChangeEvent.ChangeKind.UPDATE;
            }
        }
        throw new IllegalArgumentException("Unsupported change kind: " + (Object)((Object)changeKind));
    }

    private static InvalidArgument newInvalidToken(String defaultMessage, String messageKey, String sequenceToken) {
        LocalizableMessage errMsg = new LocalizableMessage(messageKey, defaultMessage, Arrays.asList(sequenceToken));
        return new InvalidArgument(Arrays.asList(errMsg), null);
    }

    private static InternalServerError newInternalError(String defaultMessage, String messageKey) {
        LocalizableMessage errMsg = new LocalizableMessage(messageKey, defaultMessage, Collections.emptyList());
        return new InternalServerError(Arrays.asList(errMsg), null);
    }

    @Override
    public void run() {
        this._monitorIsAlive.set(true);
        _logger.info("Monitoring long-running ChangeLog operations ...");
        try {
            this.monitorPendingInvocations();
        }
        catch (InterruptedException ex) {
            _logger.info("Monitoring long-running ChangeLog operations interrupted");
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException ex) {
            _logger.error("Monitoring long-running ChangeLog operations killed by unexpected error", (Throwable)ex);
        }
        this._monitorIsAlive.set(false);
    }

    private void monitorPendingInvocations() throws InterruptedException {
        ArrayList<GetChangesInvocation> invocations = new ArrayList<GetChangesInvocation>(this._maxConcurrentInvocations);
        while (true) {
            invocations.add(this._pendingInvocations.take());
            this._pendingInvocations.drainTo(invocations);
            for (GetChangesInvocation invocation : invocations) {
                boolean ready = invocation.poll();
                if (ready) {
                    invocation.complete();
                    this._pendingInvocationCount.decrementAndGet();
                    continue;
                }
                this._pendingInvocations.add(invocation);
            }
            invocations.clear();
            Thread.sleep(this._pollIntervalMs);
        }
    }

    private static final class GetChangesInvocation {
        private final ChangeLog _changeLog;
        private final String _sequenceToken;
        private final AsyncContext<ChangeLogTypes.ChangeList> _context;
        private final int _maxPolls;
        private int _polls;
        private ChangeList _result;
        private RuntimeException _error;

        GetChangesInvocation(ChangeLog changeLog, String sequenceToken, AsyncContext<ChangeLogTypes.ChangeList> context, int maxPolls) {
            assert (changeLog != null);
            assert (sequenceToken != null);
            assert (context != null);
            assert (maxPolls > 0);
            this._changeLog = changeLog;
            this._sequenceToken = sequenceToken;
            this._context = context;
            this._maxPolls = maxPolls;
            this._polls = 0;
        }

        public boolean poll() {
            try {
                return this.pollImpl();
            }
            catch (RuntimeException ex) {
                _logger.error("Unexpected error while processing getChanges('{}')", (Object)this._sequenceToken, (Object)ex);
                this._error = ex;
                return true;
            }
        }

        private boolean pollImpl() {
            ChangeList changes;
            ++this._polls;
            try {
                changes = this._changeLog.getChanges(this._sequenceToken);
            }
            catch (SequenceExpiredException e) {
                this._error = ChangeLogProviderImpl.newInvalidToken(e.getMessage(), "error.cdc.sequenceTokenExpired", this._sequenceToken);
                return true;
            }
            catch (IllegalArgumentException e) {
                this._error = ChangeLogProviderImpl.newInvalidToken(e.getMessage(), "error.cdc.invalidTokenFormat", this._sequenceToken);
                return true;
            }
            if (!changes.getChanges().isEmpty() || this._polls >= this._maxPolls) {
                this._result = changes;
                return true;
            }
            return false;
        }

        public void complete() {
            assert (this._result != null || this._error != null);
            try {
                if (this._result != null) {
                    this._context.setResult((Object)ChangeLogProviderImpl.toVapiChangeList(this._result));
                } else {
                    this._context.setError(this._error);
                }
            }
            catch (RuntimeException t) {
                _logger.error("Unexpected error while returning result for getChanges('{}')", (Object)this._sequenceToken, (Object)t);
            }
        }
    }
}

