/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.listener;

import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.ChangeSet;
import com.vmware.cdc.internal.vcenter.exception.WaitForChangesCanceledException;
import com.vmware.cdc.internal.vcenter.listener.ChangeDemultiplexer;
import com.vmware.cdc.internal.vcenter.listener.ListenerSpec;
import com.vmware.vapi.CoreException;
import com.vmware.vapi.client.exception.SslException;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class ChangeLogCollectorPoller {
    private static final Logger _logger = LoggerFactory.getLogger(ChangeLogCollectorPoller.class);
    private static final byte TEMPORARY_ERROR_BACKOFF_RETRY_COUNT = 15;
    private final String _serviceName;
    private final ExecutorService _pollingExecutor;
    private final long _pollingInterval;
    private final ChangeLogCollector _changeLogCollector;
    private final ChangeDemultiplexer _changeDemultiplexer;
    private Future<?> _pollingTask = null;
    private volatile String _sequenceToken = null;

    ChangeLogCollectorPoller(String serviceName, ExecutorService pollingExecutor, long pollingInterval, ChangeLogCollector changeLogCollector, ChangeDemultiplexer changeDemultiplexer) {
        assert (serviceName != null);
        assert (pollingExecutor != null);
        assert (pollingInterval > 0L);
        assert (changeLogCollector != null);
        assert (changeDemultiplexer != null);
        this._serviceName = serviceName;
        this._pollingExecutor = pollingExecutor;
        this._pollingInterval = pollingInterval;
        this._changeLogCollector = changeLogCollector;
        this._changeDemultiplexer = changeDemultiplexer;
    }

    private ChangeLogCollectorPoller(String sequenceToken, String serviceName, ExecutorService pollingExecutor, long pollingInterval, ChangeLogCollector changeLogCollector, ChangeDemultiplexer changeDemultiplexer) {
        this(serviceName, pollingExecutor, pollingInterval, changeLogCollector, changeDemultiplexer);
        this._sequenceToken = sequenceToken;
    }

    void start() {
        assert (this._pollingTask == null) : "A poller may be started only once";
        final ChangeLogCollector.ChangeLog[] subscribedChangeLogs = this._changeDemultiplexer.getSubscribedChangeLogs();
        if (this._sequenceToken == null) {
            this._sequenceToken = this.initializeSequenceToken(subscribedChangeLogs);
        }
        final Map mdcContext = MDC.getCopyOfContextMap();
        _logger.debug("[{}] Starting polling for changes", (Object)this._serviceName);
        this._pollingTask = this._pollingExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                _logger.info("[{}] Started polling for changes on topics [{}]", (Object)ChangeLogCollectorPoller.this._serviceName, (Object)Arrays.toString((Object[])subscribedChangeLogs));
                if (mdcContext != null) {
                    MDC.setContextMap((Map)mdcContext);
                }
                try {
                    ChangeLogCollectorPoller.this.pollChangesTask();
                }
                finally {
                    MDC.clear();
                }
                ChangeLogCollectorPoller.this._sequenceToken = null;
                _logger.info("[{}] Stopped polling for changes on topics [{}]", (Object)ChangeLogCollectorPoller.this._serviceName, (Object)Arrays.toString((Object[])subscribedChangeLogs));
            }

            public String toString() {
                return ChangeLogCollectorPoller.this._serviceName;
            }
        });
    }

    synchronized ChangeLogCollectorPoller exchangeChangePoller(ChangeDemultiplexer newChangeDemultiplexer, ListenerSpec newListenerSpec) {
        assert (newChangeDemultiplexer != null);
        assert (newListenerSpec != null);
        String exchangedSequenceToken = this.exchangeSequenceToken(this._sequenceToken, newListenerSpec.getChangeLogsToAdd(), newListenerSpec.getChangeLogsToRemove());
        this.stop();
        return new ChangeLogCollectorPoller(exchangedSequenceToken, this._serviceName, this._pollingExecutor, this._pollingInterval, this._changeLogCollector, newChangeDemultiplexer);
    }

    synchronized void stop() {
        if (this._pollingTask != null) {
            _logger.debug("[{}] Stopping polling for changes", (Object)this._serviceName);
            this._pollingTask.cancel(true);
            this._pollingTask = null;
        }
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this._serviceName);
    }

    private String initializeSequenceToken(ChangeLogCollector.ChangeLog[] changeLogsToSubscribe) {
        assert (changeLogsToSubscribe != null);
        assert (changeLogsToSubscribe.length > 0);
        String initialSequenceToken = null;
        if (_logger.isDebugEnabled()) {
            _logger.debug("[{}] Sync current sequence for change logs [{}]", (Object)this._serviceName, (Object)Arrays.toString((Object[])changeLogsToSubscribe));
        }
        try {
            initialSequenceToken = this._changeLogCollector.initializeSequence(changeLogsToSubscribe);
        }
        catch (Exception e) {
            _logger.error("[{}] Error while initializing sequence", (Object)this._serviceName, (Object)e);
            throw e;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("[{}] Synced current sequence for change logs [{}] to [{}]", new Object[]{this._serviceName, Arrays.toString((Object[])changeLogsToSubscribe), initialSequenceToken});
        }
        return initialSequenceToken;
    }

    private String exchangeSequenceToken(String currentSequenceToken, ChangeLogCollector.ChangeLog[] changeLogsToAdd, ChangeLogCollector.ChangeLog[] changeLogsToRemove) {
        assert (currentSequenceToken != null);
        assert (changeLogsToAdd != null);
        assert (changeLogsToRemove != null);
        if (_logger.isDebugEnabled()) {
            _logger.debug("[{}] Exchanging current sequence [{}], adding ChangeLogs [{}] and removing ChangeLogs [{}]", new Object[]{this._serviceName, currentSequenceToken, changeLogsToAdd, changeLogsToRemove});
        }
        String exchangedSequenceToken = null;
        try {
            exchangedSequenceToken = this._changeLogCollector.exchangeSequence(currentSequenceToken, changeLogsToAdd, changeLogsToRemove);
        }
        catch (Exception e) {
            _logger.error("[{}] Error while exchanging sequence [{}]", new Object[]{this._serviceName, currentSequenceToken, e});
            throw e;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("[{}] Exchanged sequence token [{}] for new token [{}]", new Object[]{this._serviceName, currentSequenceToken, exchangedSequenceToken});
        }
        return exchangedSequenceToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollChangesTask() {
        int connectionErrors = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ChangeSet changeSet = this.waitForChanges(this._sequenceToken);
                ChangeLogCollectorPoller changeLogCollectorPoller = this;
                synchronized (changeLogCollectorPoller) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    this._sequenceToken = changeSet.getSequence();
                }
                this._changeDemultiplexer.notifyForChanges(changeSet);
                connectionErrors = 0;
                Thread.sleep(this._pollingInterval);
            }
            catch (InterruptedException ie) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("[{}] Polling for changes was interrupted: {} {}", new Object[]{this._serviceName, ie.getClass().getName(), ie.getMessage(), ie});
                }
                return;
            }
            catch (SequenceExpiredException e) {
                this.notifySequenceExpiredError(e);
                return;
            }
            catch (WaitForChangesCanceledException e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("[{}] Polling for changes was canceled (probably due to exchange of a sequence token), a new poll (with the exchanged token) should be attempted: {} {}", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), e});
                }
                return;
            }
            catch (Exception e) {
                if (connectionErrors < 15 && ChangeLogCollectorPoller.exceptionIndicatesTemporaryError(e)) {
                    connectionErrors = (byte)(connectionErrors + 1);
                    try {
                        this.backOffOnTemporaryError(connectionErrors, e);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("[{}] Retry of polling for changes was interrupted: {} {}", new Object[]{this._serviceName, ie.getClass().getName(), ie.getMessage(), ie});
                        }
                        return;
                    }
                }
                this.notifyFatalError(e);
                return;
            }
            catch (Throwable t) {
                _logger.error("[{}] Polling for changes terminated because of an internal error", (Object)this._serviceName, (Object)t);
                throw t;
            }
        }
    }

    private ChangeSet waitForChanges(String sequenceToken) throws SequenceExpiredException, WaitForChangesCanceledException {
        _logger.debug("[{}] Get changes for sequence {}", (Object)this._serviceName, (Object)sequenceToken);
        ChangeSet changeSet = this._changeLogCollector.waitForChanges(sequenceToken);
        if (_logger.isDebugEnabled()) {
            _logger.debug("[{}] Received [{}] ResourceChanges and [{}] AlarmChanges for sequence [{}]", new Object[]{this._serviceName, changeSet.getResourceChanges().size(), changeSet.getAlarmChanges().size(), sequenceToken});
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace("[{}] Received changes for sequence {}: {}", new Object[]{this._serviceName, sequenceToken, changeSet});
        }
        return changeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySequenceExpiredError(SequenceExpiredException see) {
        ChangeLogCollectorPoller changeLogCollectorPoller = this;
        synchronized (changeLogCollectorPoller) {
            if (Thread.currentThread().isInterrupted()) {
                _logger.warn("[{}] Expired sequence token [{}] was detected during polling for changes: {} {}", new Object[]{this._serviceName, this._sequenceToken, see.getClass().getName(), see.getMessage(), see});
                return;
            }
        }
        _logger.error("[{}] Polling changes terminated because the sequence token [{}] has expired: {} {}", new Object[]{this._serviceName, this._sequenceToken, see.getClass().getName(), see.getMessage(), see});
        this._changeDemultiplexer.notifyFatalError(new IllegalStateException("Changes lost because of an expired sequence token, please re-subscribe", see));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFatalError(Exception e) {
        ChangeLogCollectorPoller changeLogCollectorPoller = this;
        synchronized (changeLogCollectorPoller) {
            if (Thread.currentThread().isInterrupted()) {
                _logger.warn("[{}] Unexpected error occurred during polling for changes: {} {}", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), e});
                return;
            }
        }
        _logger.error("[{}] Polling for changes terminated because of an unexpected error: {} {}", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), e});
        this._changeDemultiplexer.notifyFatalError(new IllegalStateException("Polling for changes terminated because of an unexpected error, please re-subscribe", e));
    }

    private static boolean exceptionIndicatesTemporaryError(Exception e) {
        if (e instanceof UnexpectedStatusCodeException) {
            return ((UnexpectedStatusCodeException)e).getStatusCode() == 503;
        }
        if (e instanceof ConnectionException) {
            return e.getCause() instanceof SocketTimeoutException;
        }
        if (e instanceof com.vmware.vim.vmomi.client.exception.TransportProtocolException) {
            return e.getCause() instanceof NoHttpResponseException;
        }
        if (e instanceof TransportProtocolException) {
            return !(e instanceof SslException) && !(e.getCause() instanceof UnknownHostException) && !(e.getCause() instanceof InterruptedIOException) && !(e.getCause() instanceof HttpException) && !(e.getCause() instanceof ParseException) && !(e.getCause() instanceof CoreException);
        }
        return false;
    }

    private void backOffOnTemporaryError(int connectionErrors, Exception e) throws InterruptedException {
        long backOffTimeSec = connectionErrors < 5 ? 5L : (connectionErrors < 10 ? 10L : 30L);
        _logger.info("[{}] Connection error while reading changes: {} {}. Will retry after {} seconds.", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), backOffTimeSec});
        _logger.debug("", (Throwable)e);
        Thread.sleep(TimeUnit.SECONDS.toMillis(backOffTimeSec));
    }
}

