/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.vcenter;

import java.util.Calendar;
import org.apache.commons.lang.Validate;

public final class AlarmChange {
    private final Kind _kind;
    private final Object _resource;
    private final Object _alarm;
    private final String _overallStatus;
    private final Calendar _time;
    private final Integer _eventKey;
    private final String _acknowledgedByUser;
    private final Calendar _acknowledgedTime;

    public AlarmChange(Kind kind, Object resource, Object alarm, String overallStatus, Calendar time, Integer eventKey, String acknowledgedByUser, Calendar acknowledgedTime) {
        Validate.notNull((Object)((Object)kind));
        Validate.notNull((Object)resource);
        Validate.notNull((Object)alarm);
        this._kind = kind;
        this._resource = resource;
        this._alarm = alarm;
        this._overallStatus = overallStatus;
        this._time = time;
        this._eventKey = eventKey;
        this._acknowledgedByUser = acknowledgedByUser;
        this._acknowledgedTime = acknowledgedTime;
    }

    public Kind getKind() {
        return this._kind;
    }

    public Object getResource() {
        return this._resource;
    }

    public Object getAlarm() {
        return this._alarm;
    }

    public String getOverallStatus() {
        return this._overallStatus;
    }

    public Calendar getTime() {
        return this._time;
    }

    public Integer getEventKey() {
        return this._eventKey;
    }

    public String getAcknowledgedByUser() {
        return this._acknowledgedByUser;
    }

    public Calendar getAcknowledgedTime() {
        return this._acknowledgedTime;
    }

    public int hashCode() {
        int hash = 23;
        hash = 31 * hash + this._kind.hashCode();
        hash = 31 * hash + this._resource.hashCode();
        hash = 31 * hash + this._alarm.hashCode();
        hash = 31 * hash + (this._overallStatus != null ? this._overallStatus.hashCode() : 0);
        hash = 31 * hash + (this._time != null ? this._time.hashCode() : 0);
        hash = 31 * hash + (this._eventKey != null ? this._eventKey.hashCode() : 0);
        hash = 31 * hash + (this._acknowledgedByUser != null ? this._acknowledgedByUser.hashCode() : 0);
        hash = 31 * hash + (this._acknowledgedTime != null ? this._acknowledgedTime.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AlarmChange)) {
            return false;
        }
        AlarmChange other = (AlarmChange)obj;
        if (this._overallStatus == null ? other._overallStatus != null : !this._overallStatus.equals(other._overallStatus)) {
            return false;
        }
        if (this._time == null ? other._time != null : !this._time.equals(other._time)) {
            return false;
        }
        if (this._eventKey == null ? other._eventKey != null : !this._eventKey.equals(other._eventKey)) {
            return false;
        }
        if (this._acknowledgedByUser == null ? other._acknowledgedByUser != null : !this._acknowledgedByUser.equals(other._acknowledgedByUser)) {
            return false;
        }
        if (this._acknowledgedTime == null ? other._acknowledgedTime != null : !this._acknowledgedTime.equals(other._acknowledgedTime)) {
            return false;
        }
        return this._kind.equals((Object)other._kind) && this._resource.equals(other._resource) && this._alarm.equals(other._alarm);
    }

    public String toString() {
        return "AlarmChange [_kind=" + (Object)((Object)this._kind) + ", _resource=" + this._resource + ", _alarm=" + this._alarm + (this._overallStatus != null ? ", _overallStatus=" + this._overallStatus : "") + "]" + (this._time != null ? ",_time=" + this._time : "") + "]" + (this._eventKey != null ? ", _eventKey=" + this._eventKey : "") + "]" + (this._acknowledgedByUser != null ? ", _acknowledgedByUser=" + this._acknowledgedByUser : "") + "]" + (this._acknowledgedTime != null ? ", _acknowledgedTime=" + this._acknowledgedTime : "") + "]";
    }

    public static enum Kind {
        TRIGGER,
        RETRIGGER,
        ACKNOWLEDGE,
        CLEAR;

    }
}

