/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.vcenter;

import java.util.List;
import org.apache.commons.lang.Validate;

public final class ResourceChange {
    private final Kind _kind;
    private final Object _resource;
    private final String _resourceType;
    private final List<String> _properties;

    public ResourceChange(Kind kind, Object resource, String resourceType, List<String> properties) {
        Validate.notNull((Object)((Object)kind));
        Validate.notNull((Object)resource);
        Validate.notNull((Object)resourceType);
        Validate.isTrue((properties == null || !properties.isEmpty() ? 1 : 0) != 0, (String)"Properties parameter should be either null or not empty.");
        this._kind = kind;
        this._resource = resource;
        this._resourceType = resourceType;
        this._properties = properties;
    }

    public Kind getKind() {
        return this._kind;
    }

    public Object getResource() {
        return this._resource;
    }

    public String getResourceType() {
        return this._resourceType;
    }

    public List<String> getProperties() {
        return this._properties;
    }

    public int hashCode() {
        int hash = 23;
        hash = 31 * hash + this._kind.hashCode();
        hash = 31 * hash + this._resource.hashCode();
        hash = 31 * hash + this._resourceType.hashCode();
        hash = 31 * hash + (this._properties != null ? this._properties.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange)obj;
        if (this._properties == null ? other._properties != null : !this._properties.equals(other._properties)) {
            return false;
        }
        return this._kind.equals((Object)other._kind) && this._resource.equals(other._resource) && this._resourceType.equals(other._resourceType);
    }

    public String toString() {
        return "ResourceChange [_kind=" + (Object)((Object)this._kind) + ", _resource=" + this._resource + ", _resourceType=" + this._resourceType + (this._properties != null ? ",_properties=" + this._properties : "") + "]";
    }

    public static enum Kind {
        CREATE,
        UPDATE,
        DELETE;

    }
}

