/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.applmgmt;

import com.vmware.appliance.Monitoring;
import com.vmware.appliance.MonitoringTypes;
import com.vmware.appliance.Shutdown;
import com.vmware.appliance.access.Consolecli;
import com.vmware.appliance.access.Dcui;
import com.vmware.appliance.access.Shell;
import com.vmware.appliance.access.Ssh;
import com.vmware.appliance.health.Load;
import com.vmware.appliance.health.Mem;
import com.vmware.appliance.health.Storage;
import com.vmware.appliance.health.Swap;
import com.vmware.appliance.health.System;
import com.vmware.appliance.networking.Interfaces;
import com.vmware.appliance.networking.dns.Domains;
import com.vmware.appliance.networking.dns.Hostname;
import com.vmware.appliance.networking.dns.Servers;
import com.vmware.appliance.system.Uptime;
import com.vmware.appliance.techpreview.networking.Ipv4;
import com.vmware.appliance.techpreview.networking.Ipv6;
import com.vmware.appliance.techpreview.networking.Routes;
import com.vmware.appliance.techpreview.networking.firewall.addr.Inbound;
import com.vmware.vapi.bindings.Service;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.cloudvm.CpuStats;
import com.vmware.vise.vim.cloudvm.DnsServerConfig;
import com.vmware.vise.vim.cloudvm.FirewallAddressRule;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.MemStats;
import com.vmware.vise.vim.cloudvm.NetStats;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.cloudvm.NetworkRoute;
import com.vmware.vise.vim.cloudvm.PowerOperationConfig;
import com.vmware.vise.vim.cloudvm.ShellConfig;
import com.vmware.vise.vim.cloudvm.StorageStats;
import com.vmware.vise.vim.cloudvm.SystemStats;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vsphere.client.cm.applmgmt.VapiToXmlRpcConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VapiBackedCloudVmService
extends CloudVmService {
    private static final Log _logger = LogFactory.getLog(VapiBackedCloudVmService.class);
    private final VapiConnectionManager _applmgmtConnectionManager;

    public VapiBackedCloudVmService(VapiConnectionManager vapiConnectionManager) {
        super(null);
        this._applmgmtConnectionManager = vapiConnectionManager;
    }

    public boolean isConsoleCliEnabled() throws CloudVmServiceException {
        return this.getService(Consolecli.class).get();
    }

    public void setConsoleCliEnabled(boolean bl) throws CloudVmServiceException {
        this.getService(Consolecli.class).set(bl);
    }

    public boolean isDcuiEnabled() throws CloudVmServiceException {
        return this.getService(Dcui.class).get();
    }

    public void setDcuiEnabled(boolean bl) throws CloudVmServiceException {
        this.getService(Dcui.class).set(bl);
    }

    public ShellConfig getShellConfig() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiStruct(this.getService(Shell.class).get());
    }

    public void setShellConfig(ShellConfig shellConfig) throws CloudVmServiceException {
        this.getService(Shell.class).set(VapiToXmlRpcConverter.toVapiStruct(shellConfig));
    }

    public boolean isSshEnabled() throws CloudVmServiceException {
        return this.getService(Ssh.class).get();
    }

    public void setSshEnabled(boolean bl) throws CloudVmServiceException {
        this.getService(Ssh.class).set(bl);
    }

    public String[] listDnsDomains() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.toStringArray(this.getService(Domains.class).list());
    }

    public void setDnsDomains(String[] stringArray) throws CloudVmServiceException {
        this.getService(Domains.class).set(Arrays.asList(stringArray));
    }

    public void addDnsDomains(String string) throws CloudVmServiceException {
        this.getService(Domains.class).add(string);
    }

    public String getHostname() throws CloudVmServiceException {
        return this.getService(Hostname.class).get();
    }

    public void setHostname(String string) throws CloudVmServiceException {
        this.getService(Hostname.class).set(string);
    }

    public DnsServerConfig getDnsServersConfig() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiStruct(this.getService(Servers.class).get());
    }

    public void setDnsServersConfig(DnsServerConfig dnsServerConfig) throws CloudVmServiceException {
        this.getService(Servers.class).set(VapiToXmlRpcConverter.toVapiStruct(dnsServerConfig));
    }

    public void addDnsServersConfig(String string) throws CloudVmServiceException {
        this.getService(Servers.class).add(string);
    }

    public NetworkInterfaceInfo getNic(String string) throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiStruct(this.getService(Interfaces.class).get(string));
    }

    public NetworkInterfaceInfo[] listNics() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiList(this.getService(Interfaces.class).list());
    }

    public IPv4Config[] getIPv4Config(String[] stringArray) throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv4List(this.getService(Ipv4.class).get(VapiToXmlRpcConverter.toVapiList(stringArray)));
    }

    public IPv4Config[] listIPv4Config() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv4List(this.getService(Ipv4.class).list());
    }

    public void setIPv4Config(IPv4Config[] iPv4ConfigArray) throws CloudVmServiceException {
        this.getService(Ipv4.class).set(VapiToXmlRpcConverter.toVapiIpv4List(iPv4ConfigArray));
    }

    public void renewIPv4Config(String[] stringArray) throws CloudVmServiceException {
        this.getService(Ipv4.class).renew(VapiToXmlRpcConverter.toVapiList(stringArray));
    }

    public IPv6Config[] getIPv6Config(String[] stringArray) throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv6ConfigList(this.getService(Ipv6.class).get(VapiToXmlRpcConverter.toVapiList(stringArray)));
    }

    public void setIPv6Config(IPv6Config[] iPv6ConfigArray) throws CloudVmServiceException {
        this.getService(Ipv6.class).set(VapiToXmlRpcConverter.toVapiIpv6List(iPv6ConfigArray));
    }

    public IPv6Config[] listIPv6Config() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv6ConfigList(this.getService(Ipv6.class).list());
    }

    public FirewallAddressRule[] listFirewallRules() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiFirewallRuleList(this.getService(Inbound.class).list());
    }

    public void setFirewallRules(FirewallAddressRule[] firewallAddressRuleArray) throws CloudVmServiceException {
        this.getService(Inbound.class).set(VapiToXmlRpcConverter.toVapiFirewallRuleList(firewallAddressRuleArray));
    }

    public void addFirewallRule(int n, FirewallAddressRule firewallAddressRule) throws CloudVmServiceException {
        this.getService(Inbound.class).add((long)n, VapiToXmlRpcConverter.toVapiStruct(firewallAddressRule));
    }

    public NetworkRoute[] listRoutes() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiRouteList(this.getService(Routes.class).list());
    }

    public void setRoutes(NetworkRoute[] networkRouteArray) throws CloudVmServiceException {
        this.getService(Routes.class).set(VapiToXmlRpcConverter.toVapiRouteList(networkRouteArray));
    }

    public String getSystemHealth() throws CloudVmServiceException {
        return this.getService(System.class).get().name();
    }

    public String getStorageHealth() throws CloudVmServiceException {
        return this.getService(Storage.class).get().name();
    }

    public String getMemHealth() throws CloudVmServiceException {
        return this.getService(Mem.class).get().name();
    }

    public String getLoadHealth() throws CloudVmServiceException {
        return this.getService(Load.class).get().name();
    }

    public String getSwapHealth() throws CloudVmServiceException {
        return this.getService(Swap.class).get().name();
    }

    public SystemStats getSystemStats() throws CloudVmServiceException {
        SystemStats systemStats = new SystemStats();
        Uptime uptime = this.getService(Uptime.class);
        systemStats.uptime = uptime.get();
        return systemStats;
    }

    public CpuStats getCpuStats() throws CloudVmServiceException {
        Monitoring monitoring = this.getService(Monitoring.class);
        MonitoringTypes.MonitoredItemDataRequest monitoredItemDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        monitoredItemDataRequest.setNames(Arrays.asList("cpu.util", "cpu.totalfrequency"));
        monitoredItemDataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        monitoredItemDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        this.setRequestIntervalLastNMinutes(monitoredItemDataRequest, 5);
        List list = monitoring.query(monitoredItemDataRequest);
        CpuStats cpuStats = new CpuStats();
        cpuStats.timeIntervalMins = 5;
        for (MonitoringTypes.MonitoredItemData monitoredItemData : list) {
            if ("cpu.util".equals(monitoredItemData.getName())) {
                cpuStats.used = Double.parseDouble((String)monitoredItemData.getData().get(0));
                continue;
            }
            if (!"cpu.totalfrequency".equals(monitoredItemData.getName())) continue;
            cpuStats.total = Double.parseDouble((String)monitoredItemData.getData().get(0));
        }
        return cpuStats;
    }

    public MemStats getMemStats() throws CloudVmServiceException {
        Monitoring monitoring = this.getService(Monitoring.class);
        MonitoringTypes.MonitoredItemDataRequest monitoredItemDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        monitoredItemDataRequest.setNames(Arrays.asList("mem.util", "mem.total"));
        monitoredItemDataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        monitoredItemDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        this.setRequestIntervalLastNMinutes(monitoredItemDataRequest, 5);
        List list = monitoring.query(monitoredItemDataRequest);
        MemStats memStats = new MemStats();
        long l = 0L;
        for (MonitoringTypes.MonitoredItemData monitoredItemData : list) {
            if ("mem.util".equals(monitoredItemData.getName())) {
                l = (long)Double.parseDouble((String)monitoredItemData.getData().get(0));
                continue;
            }
            if (!"mem.total".equals(monitoredItemData.getName())) continue;
            memStats.total = (long)Double.parseDouble((String)monitoredItemData.getData().get(0));
        }
        memStats.free = memStats.total - l;
        return memStats;
    }

    public NetStats getNetStats(String string) throws CloudVmServiceException {
        throw new NotImplementedException();
    }

    public NetStats[] listNetStats() throws CloudVmServiceException {
        Object object2;
        Monitoring monitoring = this.getService(Monitoring.class);
        List list = monitoring.list();
        HashMap<String, MonitoringTypes.MonitoredItem> hashMap = new HashMap<String, MonitoringTypes.MonitoredItem>();
        HashMap<String, NetStats> hashMap2 = new HashMap<String, NetStats>();
        for (Object object2 : list) {
            if (!object2.getCategory().equals("com.vmware.applmgmt.mon.cat.network") || !object2.getId().startsWith("net.rx.activity") && !object2.getId().startsWith("net.tx.activity") && !object2.getId().startsWith("net.rx.packetRate") && !object2.getId().startsWith("net.tx.packetRate")) continue;
            hashMap.put(object2.getId(), (MonitoringTypes.MonitoredItem)object2);
        }
        MonitoringTypes.MonitoredItemDataRequest monitoredItemDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        monitoredItemDataRequest.setNames(new ArrayList(hashMap.keySet()));
        monitoredItemDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        monitoredItemDataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        this.setRequestIntervalLastNMinutes(monitoredItemDataRequest, 5);
        object2 = monitoring.query(monitoredItemDataRequest);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            NetStats netStats;
            MonitoringTypes.MonitoredItemData monitoredItemData = (MonitoringTypes.MonitoredItemData)iterator.next();
            String string = monitoredItemData.getName();
            MonitoringTypes.MonitoredItem monitoredItem = (MonitoringTypes.MonitoredItem)hashMap.get(string);
            if (monitoredItem == null) {
                _logger.warn((Object)("Received data that wasn't requested: " + string));
                continue;
            }
            String string2 = monitoredItem.getInstance();
            if (!hashMap2.containsKey(string2)) {
                netStats = new NetStats();
                netStats.nic = string2;
                netStats.rxBytes = -1L;
                netStats.rxPackets = -1L;
                netStats.txBytes = -1L;
                netStats.txPackets = -1L;
                hashMap2.put(string2, netStats);
            } else {
                netStats = (NetStats)hashMap2.get(string2);
            }
            if (monitoredItem.getId().startsWith("net.rx.activity")) {
                netStats.rxBytes = (long)(Double.parseDouble((String)monitoredItemData.getData().get(0)) * 5.0 * 60.0 * 1024.0 * 1024.0);
                continue;
            }
            if (monitoredItem.getId().startsWith("net.tx.activity")) {
                netStats.txBytes = (long)(Double.parseDouble((String)monitoredItemData.getData().get(0)) * 5.0 * 60.0 * 1024.0 * 1024.0);
                continue;
            }
            if (monitoredItem.getId().startsWith("net.rx.packetRate")) {
                netStats.rxPackets = (long)(Double.parseDouble((String)monitoredItemData.getData().get(0)) * 60.0 * 5.0 * 1000000.0);
                continue;
            }
            if (!monitoredItem.getId().startsWith("net.tx.packetRate")) continue;
            netStats.txPackets = (long)(Double.parseDouble((String)monitoredItemData.getData().get(0)) * 60.0 * 5.0 * 1000000.0);
        }
        return hashMap2.values().toArray(new NetStats[0]);
    }

    public StorageStats[] listStorageStats() throws CloudVmServiceException {
        Object object2;
        Monitoring monitoring = this.getService(Monitoring.class);
        List list = monitoring.list();
        HashMap<String, MonitoringTypes.MonitoredItem> hashMap = new HashMap<String, MonitoringTypes.MonitoredItem>();
        HashMap<String, StorageStats> hashMap2 = new HashMap<String, StorageStats>();
        for (Object object2 : list) {
            if (!object2.getCategory().equals("com.vmware.applmgmt.mon.cat.storage") || !object2.getId().startsWith("storage.totalsize") && !object2.getId().startsWith("storage.used")) continue;
            hashMap.put(object2.getId(), (MonitoringTypes.MonitoredItem)object2);
        }
        MonitoringTypes.MonitoredItemDataRequest monitoredItemDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        monitoredItemDataRequest.setNames(new ArrayList(hashMap.keySet()));
        monitoredItemDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES30);
        monitoredItemDataRequest.setFunction(MonitoringTypes.FunctionType.MAX);
        this.setRequestIntervalLastNMinutes(monitoredItemDataRequest, 30);
        object2 = monitoring.query(monitoredItemDataRequest);
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            StorageStats storageStats;
            MonitoringTypes.MonitoredItemData monitoredItemData = (MonitoringTypes.MonitoredItemData)object3.next();
            String string = monitoredItemData.getName();
            MonitoringTypes.MonitoredItem monitoredItem = (MonitoringTypes.MonitoredItem)hashMap.get(string);
            if (monitoredItem == null) {
                _logger.warn((Object)("Received data that wasn't requested: " + string));
                continue;
            }
            String string2 = monitoredItem.getInstance();
            if (!hashMap2.containsKey(string2)) {
                storageStats = new StorageStats();
                storageStats.name = string2;
                storageStats.totalKBytes = -1L;
                storageStats.usedKBytes = -1L;
                hashMap2.put(string2, storageStats);
            } else {
                storageStats = (StorageStats)hashMap2.get(string2);
            }
            if (monitoredItem.getId().startsWith("storage.totalsize")) {
                storageStats.totalKBytes = (long)Double.parseDouble((String)monitoredItemData.getData().get(0));
                continue;
            }
            if (!monitoredItem.getId().startsWith("storage.used")) continue;
            storageStats.usedKBytes = (long)Double.parseDouble((String)monitoredItemData.getData().get(0));
        }
        object3 = new ArrayList();
        for (String string : hashMap2.values()) {
            if (((StorageStats)string).usedKBytes == -1L || ((StorageStats)string).totalKBytes == -1L) continue;
            ((ArrayList)object3).add(string);
        }
        return ((ArrayList)object3).toArray(new StorageStats[0]);
    }

    private void setRequestIntervalLastNMinutes(MonitoringTypes.MonitoredItemDataRequest monitoredItemDataRequest, int n) {
        long l = java.lang.System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l - (long)(n * 60 * 1000));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(l);
        monitoredItemDataRequest.setStartTime(calendar);
        monitoredItemDataRequest.setEndTime(calendar2);
    }

    public String control(String string, String[] stringArray, int n) throws CloudVmServiceException {
        throw new NotImplementedException();
    }

    public void restart(PowerOperationConfig powerOperationConfig) throws CloudVmServiceException {
        this.getService(Shutdown.class).reboot(Long.valueOf(powerOperationConfig.delay).longValue(), powerOperationConfig.reason);
    }

    public void shutdown(PowerOperationConfig powerOperationConfig) throws CloudVmServiceException {
        this.getService(Shutdown.class).poweroff(Long.valueOf(powerOperationConfig.delay).longValue(), powerOperationConfig.reason);
    }

    private <C extends Service> C getService(Class<C> clazz) {
        return (C)this._applmgmtConnectionManager.createServiceStub(clazz);
    }
}

