/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CmDataProviderAdapterBase<T>
extends DataProviderAdapterBase {
    private static final ResultItem[] EMPTY_RESULT_ITEMS_ARRAY = new ResultItem[0];
    private static final Log _logger = LogFactory.getLog(CmDataProviderAdapterBase.class);
    private final CmAuthorizationService _cmAuthorizationService;

    public CmDataProviderAdapterBase(CmAuthorizationService cmAuthorizationService) {
        this._cmAuthorizationService = cmAuthorizationService;
    }

    protected ResultSet processQuery(Constraint constraint, QuerySpec querySpec) {
        return this.handleQuery(constraint, querySpec);
    }

    protected ResultSet processQuery(CompositeConstraint compositeConstraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)compositeConstraint, querySpec);
    }

    protected ResultSet processQuery(RelationalConstraint relationalConstraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)relationalConstraint, querySpec);
    }

    protected ResultSet processQuery(ObjectIdentityConstraint objectIdentityConstraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)objectIdentityConstraint, querySpec);
    }

    protected ResultSet processQuery(PropertyConstraint propertyConstraint, QuerySpec querySpec) {
        return this.handleQuery((Constraint)propertyConstraint, querySpec);
    }

    protected abstract ResultSet processQueryInternal(Constraint var1, QuerySpec var2);

    protected ResultSet createResultSet(QuerySpec querySpec, DataRetrieverResult<? extends T> dataRetrieverResult) {
        DataRetrieverResult<? extends T> dataRetrieverResult2 = this.pageProviders(dataRetrieverResult, querySpec.resultSpec);
        ResultSet resultSet = this.createResultSetInternal(querySpec, dataRetrieverResult, dataRetrieverResult2);
        return resultSet;
    }

    protected ResultSet createEmptyResultSet(QuerySpec querySpec, String string) {
        assert (querySpec != null);
        ResultSet resultSet = new ResultSet();
        resultSet.items = EMPTY_RESULT_ITEMS_ARRAY;
        resultSet.queryName = querySpec.name;
        if (string != null) {
            resultSet.error = new Exception(CmUtil.getLocalizedString(string, new String[0]));
        }
        return resultSet;
    }

    private ResultSet createResultSetInternal(QuerySpec querySpec, DataRetrieverResult<? extends T> dataRetrieverResult, DataRetrieverResult<? extends T> dataRetrieverResult2) {
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        resultSet.error = dataRetrieverResult.getException();
        resultSet.items = this.createResultItems(querySpec, dataRetrieverResult2.getResult());
        T[] TArray = dataRetrieverResult.getResult();
        resultSet.totalMatchedObjectCount = TArray == null ? 0 : TArray.length;
        return resultSet;
    }

    private ResultItem[] createResultItems(QuerySpec querySpec, T[] TArray) {
        if (TArray == null || TArray.length == 0) {
            return new ResultItem[0];
        }
        String[] stringArray = this.getRelevantPropertyNames(querySpec.resourceSpec.constraint.targetType, querySpec.resourceSpec.propertySpecs);
        Object[][] objectArray = this.getPropertyValues(TArray, stringArray);
        ResultItem[] resultItemArray = new ResultItem[TArray.length];
        for (int i = 0; i < TArray.length; ++i) {
            URI uRI = this.getUri(TArray[i]);
            resultItemArray[i] = this.createResultItem(querySpec, uRI, stringArray, objectArray, i);
        }
        return resultItemArray;
    }

    private ResultItem createResultItem(QuerySpec querySpec, URI uRI, String[] stringArray, Object[][] objectArray, int n) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = uRI;
        resultItem.properties = this.createPropertyValues(uRI, stringArray, objectArray, n);
        return resultItem;
    }

    private PropertyValue[] createPropertyValues(URI uRI, String[] stringArray, Object[][] objectArray, int n) {
        PropertyValue[] propertyValueArray = new PropertyValue[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            propertyValueArray[i] = this.createPropertyValue(uRI, stringArray[i], objectArray[i][n]);
        }
        return propertyValueArray;
    }

    private PropertyValue createPropertyValue(URI uRI, String string, Object object) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = uRI;
        propertyValue.propertyName = string;
        propertyValue.value = object;
        return propertyValue;
    }

    private String[] getRelevantPropertyNames(String string, PropertySpec[] propertySpecArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertySpec propertySpec : propertySpecArray) {
            String[] stringArray = this.getRelevantPropertyNames(string, propertySpec);
            hashSet.addAll(Arrays.asList(stringArray));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private String[] getRelevantPropertyNames(String string, PropertySpec propertySpec) {
        if (string != null && propertySpec.type != null && !propertySpec.type.equals(string)) {
            _logger.warn((Object)("Unexpected PropertySpec type '" + propertySpec.type + "'! Expected '" + string + "'"));
            return new String[0];
        }
        return propertySpec.propertyNames;
    }

    private DataRetrieverResult<? extends T> pageProviders(DataRetrieverResult<? extends T> dataRetrieverResult, ResultSpec resultSpec) {
        int n;
        if (dataRetrieverResult == null) {
            return null;
        }
        T[] TArray = dataRetrieverResult.getResult();
        if (TArray == null || TArray.length == 0 || resultSpec == null) {
            return dataRetrieverResult;
        }
        int n2 = resultSpec.maxResultCount != null ? resultSpec.maxResultCount : -1;
        int n3 = n = resultSpec.offset != null ? resultSpec.offset : 0;
        if (n == 0 && n2 < 0) {
            return dataRetrieverResult;
        }
        int n4 = n;
        int n5 = n4 + n2;
        if (n4 < 0 || n4 >= TArray.length) {
            n4 = TArray.length;
        }
        if (n5 > TArray.length || n2 < 0) {
            n5 = TArray.length;
        }
        return dataRetrieverResult.slice(n4, n5);
    }

    protected abstract Object[][] getPropertyValues(T[] var1, String[] var2);

    protected abstract URI getUri(T var1);

    private ResultSet handleQuery(Constraint constraint, QuerySpec querySpec) {
        assert (constraint != null && querySpec != null);
        if (!this._cmAuthorizationService.isCurrentUserAuthorized()) {
            return this.createEmptyResultSet(querySpec, null);
        }
        return this.processQueryInternal(constraint, querySpec);
    }
}

