/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.vmomi.client.exception.ClientHaltException;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.sca.ScaServiceProvider;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.net.URI;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmScaServiceProviderImpl
implements ScaServiceProvider {
    private static final Log _logger = LogFactory.getLog(CmScaServiceProviderImpl.class);
    private final Object weakHashSetSentinel = new Object();
    private final WeakHashMap<ScaService, Object> _scasWithInterceptor = new WeakHashMap();
    private final ScaConnectionInterceptor _unreachableServerInterceptor;
    ScaServiceManager _manager = null;

    public CmScaServiceProviderImpl(ScaServiceManager scaServiceManager, PropertyCache<String> propertyCache) {
        _logger.info((Object)"instantiated");
        this._manager = scaServiceManager;
        this._unreachableServerInterceptor = new ScaConnectionInterceptor(propertyCache);
    }

    @type(value="cm:Server,cm:Service")
    public ScaService getService(URI uRI) throws CloudVmServiceException {
        String string = this.getHostname(uRI);
        ScaService scaService = this._manager.getService((Object)string);
        this.addInterceptorToService(scaService);
        return scaService;
    }

    @type(value="cm:Server,cm:Service")
    public ScaService getSolutionService(URI uRI) throws CloudVmServiceException {
        String string = this.getHostname(uRI);
        return this._manager.getSolutionService((Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInterceptorToService(ScaService scaService) {
        if (this._scasWithInterceptor.containsKey(scaService)) {
            return;
        }
        CmScaServiceProviderImpl cmScaServiceProviderImpl = this;
        synchronized (cmScaServiceProviderImpl) {
            if (this._scasWithInterceptor.containsKey(scaService)) {
                return;
            }
            HttpProtocolBindingBase httpProtocolBindingBase = (HttpProtocolBindingBase)scaService.getVmomiClient().getBinding();
            httpProtocolBindingBase.setInvocationInterceptor((InvocationInterceptor)this._unreachableServerInterceptor);
            this._scasWithInterceptor.put(scaService, this.weakHashSetSentinel);
        }
    }

    private String getHostname(URI uRI) throws CloudVmServiceException {
        String string = CmReferenceUtil.getServerId(uRI);
        return string;
    }

    private static class ScaConnectionInterceptor
    implements InvocationInterceptor {
        private final Object _sentinelValue = new Object();
        private final PropertyCache<String> _cache;

        ScaConnectionInterceptor(PropertyCache<String> propertyCache) {
            this._cache = propertyCache;
        }

        public void beginInvocation(InvocationContext invocationContext) {
            String string = ScaConnectionInterceptor.getServerName(invocationContext);
            if (this._cache.getProperty(string, "__singleton") != null) {
                throw new ClientHaltException();
            }
        }

        public void completeInvocation(InvocationContext invocationContext, boolean bl) {
            String string;
            if (!bl && this._cache.getProperty(string = ScaConnectionInterceptor.getServerName(invocationContext), "__singleton") == null) {
                this._cache.setProperty(string, "__singleton", this._sentinelValue);
            }
        }

        private static String getServerName(InvocationContext invocationContext) {
            return invocationContext.getBinding().getEndpointUri().getHost();
        }
    }
}

