/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.query.type;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.lookup.UserSpecificLsFactory;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmSsoServiceProviderImpl
implements SsoServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(CmSsoServiceProviderImpl.class);
    private static final String LS_SSO_SERVICE_CACHE_KEY = "lsSsoServiceCache";
    private UserSpecificLsFactory _lsFactory = null;
    private SsoService _ssoService = null;
    private final KeystoreService _keystoreService;

    public CmSsoServiceProviderImpl(UserSpecificLsFactory userSpecificLsFactory, SsoService ssoService, KeystoreService keystoreService) {
        Validate.notNull((Object)userSpecificLsFactory);
        Validate.notNull((Object)ssoService);
        this._lsFactory = userSpecificLsFactory;
        this._ssoService = ssoService;
        this._keystoreService = keystoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.removeData((String)LS_SSO_SERVICE_CACHE_KEY, (HttpSession)httpSessionEvent.getSession());
        if (map == null || map.isEmpty()) {
            return;
        }
        CmSsoServiceProviderImpl cmSsoServiceProviderImpl = this;
        synchronized (cmSsoServiceProviderImpl) {
            for (String string : map.keySet()) {
                SsoAdminService ssoAdminService = (SsoAdminService)map.get(string);
                try {
                    ssoAdminService.logout();
                }
                catch (Exception exception) {
                    _logger.error((Object)("Failed to log out of service " + ssoAdminService), (Throwable)exception);
                }
            }
        }
        map.clear();
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    @type(value="cm:Server")
    public SsoAdminService getAdminService(URI uRI) throws Exception {
        SsoAdminService ssoAdminService;
        String string = CmReferenceUtil.getServerId(uRI);
        Map map = (Map)SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (map != null && (ssoAdminService = (SsoAdminService)map.get(string)) != null) {
            return ssoAdminService;
        }
        return this.getAdminServiceSynchronized(uRI);
    }

    private synchronized SsoAdminService getAdminServiceSynchronized(URI uRI) throws Exception {
        Object object;
        String string = CmReferenceUtil.getServerId(uRI);
        Object object2 = SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (object2 != null && (object = (SsoAdminService)object2.get(string)) != null) {
            return object;
        }
        if (object2 == null && (object = (HashMap)SessionUtil.setDataIfAbsent((String)LS_SSO_SERVICE_CACHE_KEY, object2 = new HashMap())) != null) {
            object2 = object;
        }
        if ((object = this.findSsoServiceInfo(uRI)) == null) {
            throw CmUtil.getFault("error.ssoServiceInfoNotFound", uRI.toString());
        }
        SsoServerInfo ssoServerInfo = this.createServerInfo((ServiceRegistration.Info)object);
        SsoAdminService ssoAdminService = SsoUtil.getAdminService((SsoServerInfo)ssoServerInfo, (SsoService)this._ssoService, (SamlToken)AuthSessionUtil.getSsoToken(), (boolean)false);
        object2.put(string, ssoAdminService);
        return ssoAdminService;
    }

    private ServiceRegistration.Info findSsoServiceInfo(URI uRI) throws ComponentManagerFault {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setType("com.vmware.cis.cs.identity.admin");
        filter.setEndpointType(endpointType);
        Object[] objectArray = this._lsFactory.getLookupService().getServiceRegistrationInfos(filter);
        String string = CmReferenceUtil.getServerId(uRI);
        if (string == null) {
            _logger.warn((Object)("hostname is null: " + uRI));
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Searching for hostname '" + string + "' among " + Arrays.toString(objectArray)));
        }
        for (ServiceRegistration.Info info : (ServiceRegistration.Info[])ArrayUtil.toSafe((Object[])objectArray, ServiceRegistration.Info.class)) {
            String string2 = CmUtil.getServerHostname(info);
            if (!string.equals(string2)) continue;
            return info;
        }
        return null;
    }

    private SsoServerInfo createServerInfo(ServiceRegistration.Info info) throws Exception {
        ServiceRegistration.Endpoint[] endpointArray;
        for (ServiceRegistration.Endpoint endpoint : endpointArray = info.getServiceEndpoints()) {
            if (!endpoint.getEndpointType().getType().equals("com.vmware.cis.cs.identity.admin")) continue;
            SsoServerInfo.Builder builder = new SsoServerInfo.Builder();
            SsoDomain ssoDomain = (SsoDomain)LookupUtil.getSsoDomain((ServiceRegistration.Info)info).orElse((Object)SsoDomain.getLocal());
            builder.ssoDomain(ssoDomain);
            builder.adminAppUrl = endpoint.getUrl().toString();
            builder.keyStore = this._keystoreService.getKeyStore();
            return builder.getInstance();
        }
        return null;
    }
}

