/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectReferencePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ObjectReferencePropertyProvider.class);
    private final DataService _dataService;
    private final SsoService _ssoService;
    private final CmAuthorizationService _cmAuthorizationService;
    private final UserSessionService _usService;

    public ObjectReferencePropertyProvider(DataService dataService, SsoService ssoService, CmAuthorizationService cmAuthorizationService, UserSessionService userSessionService) {
        this._dataService = dataService;
        this._ssoService = ssoService;
        this._cmAuthorizationService = cmAuthorizationService;
        this._usService = userSessionService;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:adminServer")
    public URI getAdminServer(URI uRI) throws Exception {
        SsoServerInfo ssoServerInfo = this._ssoService.getServerInfo();
        String string = ssoServerInfo.getAdminAppUrl();
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)"cm:Server", (String)"hostname", (Comparator)Comparator.EQUALS, (Object)string2);
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)propertyConstraint, (String[])new String[]{"cm.service.getAdminServer"});
        ResultSet resultSet = null;
        try {
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        if (resultSet != null && resultSet.error != null) {
            _logger.error((Object)resultSet.error.getMessage(), (Throwable)resultSet.error);
        }
        if (resultSet == null || ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            _logger.info((Object)"SSO Admin Server was not found!");
            return null;
        }
        URI uRI2 = (URI)resultSet.items[0].resourceObject;
        return uRI2;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:serviceList")
    public URI[] getVsphereServices(URI uRI, Object[] objectArray) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || !this._cmAuthorizationService.isCurrentUserAuthorized()) {
            return new URI[0];
        }
        URI[] uRIArray = new URI[objectArray.length];
        Map<String, String> map = this.getVcHostnamesByGuid();
        for (int i = 0; i < objectArray.length; ++i) {
            Pair pair = (Pair)objectArray[i];
            Validate.isTrue((!StringUtil.isNullOrEmpty((String)((String)pair.first)) ? 1 : 0) != 0, (String)"Empty service ID in service URI.");
            Validate.isTrue((!StringUtil.isNullOrEmpty((String)((String)pair.second)) ? 1 : 0) != 0, (String)"Empty server guid in service URI.");
            String string = (String)pair.first;
            String string2 = map.get(pair.second);
            uRIArray[i] = "applmgmt".equalsIgnoreCase(string) ? CmReferenceUtil.getServerReference(string2) : CmReferenceUtil.getServiceReference(string, string2);
        }
        return uRIArray;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:isSysAdminPrivilegeGranted")
    public Boolean getIsSysAdminPrivilegeGranted(URI uRI) {
        return this._cmAuthorizationService.isCurrentUserAuthorized();
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:isCaAdminPrivilegeGranted")
    public Boolean getIsCaAdminPrivilegeGranted(URI uRI) {
        return this._cmAuthorizationService.isCaAdminsUser();
    }

    private Map<String, String> getVcHostnamesByGuid() {
        ServerInfo[] serverInfoArray = this._usService.getUserSession().serversInfo;
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (ServerInfo serverInfo : serverInfoArray) {
            treeMap.put(serverInfo.serviceGuid, serverInfo.name);
        }
        return treeMap;
    }
}

