/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.binding.sca.control.ServiceControlManager;
import com.vmware.vim.binding.sca.control.StartupType;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vsphere.client.cm.ServiceOperationSpec;
import com.vmware.vsphere.client.cm.ServiceStartupTypeSpec;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import java.net.URI;
import java.util.Locale;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScaServiceControlProvider {
    private static final Log _logger = LogFactory.getLog(ScaServiceControlProvider.class);
    private final ScaServiceManager _scaServiceManager;

    public ScaServiceControlProvider(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public OperationResult apply(URI uRI, ServiceOperationSpec serviceOperationSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            Validate.notNull((Object)((Object)serviceOperationSpec), (String)"The spec must not be null");
            operationResult.entity = uRI;
            String string = CmReferenceUtil.getServerId(uRI);
            String string2 = CmReferenceUtil.getId(uRI);
            ScaService scaService = this._scaServiceManager.getService((Object)string);
            ServiceControlManager serviceControlManager = (ServiceControlManager)scaService.getManagedObject(scaService.getServiceContent().controlManager);
            switch (serviceOperationSpec.operation) {
                case START: {
                    serviceControlManager.startService(string2, 10L);
                    break;
                }
                case STOP: {
                    serviceControlManager.stopService(string2, 10L);
                    break;
                }
                case RESTART: {
                    serviceControlManager.restartService(string2, 10L);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown runtime state: " + (Object)((Object)serviceOperationSpec.operation));
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage());
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult apply(URI uRI, ServiceStartupTypeSpec serviceStartupTypeSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            Validate.notNull((Object)((Object)serviceStartupTypeSpec), (String)"The spec must not be null");
            String string = CmReferenceUtil.getServerId(uRI);
            String string2 = CmReferenceUtil.getId(uRI);
            ScaService scaService = this._scaServiceManager.getService((Object)string);
            ServiceControlManager serviceControlManager = (ServiceControlManager)scaService.getManagedObject(scaService.getServiceContent().controlManager);
            StartupType startupType = new StartupType(serviceStartupTypeSpec.type.toString().toUpperCase(Locale.ENGLISH));
            serviceControlManager.setStartupType(string2, startupType);
        }
        catch (ServiceManagerFault serviceManagerFault) {
            _logger.error((Object)"Error while trying to chage service startup type", (Throwable)serviceManagerFault);
            operationResult.error = serviceManagerFault;
        }
        return operationResult;
    }
}

