/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vapi.std.errors.Error;
import com.vmware.vim.binding.sso.admin.SystemManagementService;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.PowerOperationConfig;
import com.vmware.vise.vim.security.certificates.PasswordVerifySpec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vmca.VmcaService;
import com.vmware.vsphere.client.cm.ServerActiveDirectorySpec;
import com.vmware.vsphere.client.cm.ServerEditAccessSpec;
import com.vmware.vsphere.client.cm.ServerEditFirewallSpec;
import com.vmware.vsphere.client.cm.ServerEditNetworkingSpec;
import com.vmware.vsphere.client.cm.ServerOperationSpec;
import com.vmware.vsphere.client.cm.ServersEditSpec;
import com.vmware.vsphere.client.cm.util.ApplmgmtServiceRegistry;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServersMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ServersMutationProvider.class);
    private final ApplmgmtServiceRegistry _applmgmtRegistry;
    private final VmcaService _vmcaService;
    private SsoServiceManager _ssoServiceManager;

    public ServersMutationProvider(ApplmgmtServiceRegistry applmgmtServiceRegistry, VmcaService vmcaService) {
        this._applmgmtRegistry = applmgmtServiceRegistry;
        this._vmcaService = vmcaService;
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public OperationResult apply(URI uRI, ServerOperationSpec serverOperationSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            Validate.notNull((Object)((Object)serverOperationSpec), (String)"The spec must not be null");
            operationResult.entity = uRI;
            CloudVmService cloudVmService = this._applmgmtRegistry.getCloudVmService(CmReferenceUtil.getServerId(uRI));
            PowerOperationConfig powerOperationConfig = ServersMutationProvider.getPowerOpConfig(serverOperationSpec);
            ServerOperationSpec.Operation operation = serverOperationSpec.operation;
            switch (operation) {
                case RESTART: {
                    cloudVmService.restart(powerOperationConfig);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown server operation: " + (Object)((Object)operation));
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage());
            operationResult.error = ServersMutationProvider.getMethodFault(exception);
        }
        return operationResult;
    }

    public OperationResult apply(URI uRI, ServersEditSpec serversEditSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            Validate.notNull((Object)((Object)serversEditSpec), (String)"The spec must not be null");
            CloudVmService cloudVmService = this._applmgmtRegistry.getCloudVmService(CmReferenceUtil.getServerId(uRI));
            this.setAccessSpec(cloudVmService, serversEditSpec.accessSpec);
            this.setNetworkingSpec(cloudVmService, serversEditSpec.netSpec);
            this.setFirewallSpec(cloudVmService, serversEditSpec.firewallSpec);
            operationResult.entity = uRI;
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            operationResult.error = ServersMutationProvider.getMethodFault(exception);
        }
        return operationResult;
    }

    public OperationResult apply(URI uRI, PasswordVerifySpec passwordVerifySpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            Validate.notNull((Object)passwordVerifySpec, (String)"The spec must not be null");
            String string = CmReferenceUtil.getServerId(uRI);
            String string2 = passwordVerifySpec.password;
            String string3 = passwordVerifySpec.user;
            String string4 = passwordVerifySpec.domain;
            this._vmcaService.createVmcaClient(string, string3, string2, string4);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage());
            operationResult.error = ServersMutationProvider.getMethodFault(exception);
            operationResult.parameter = false;
        }
        return operationResult;
    }

    private void setAccessSpec(CloudVmService cloudVmService, ServerEditAccessSpec serverEditAccessSpec) throws CloudVmServiceException {
        if (serverEditAccessSpec == null) {
            return;
        }
        if (serverEditAccessSpec.isConsoleCliEndabled != null) {
            cloudVmService.setConsoleCliEnabled(serverEditAccessSpec.isConsoleCliEndabled.booleanValue());
        }
        if (serverEditAccessSpec.shellEnabledConfig != null) {
            cloudVmService.setShellConfig(serverEditAccessSpec.shellEnabledConfig);
        }
        if (serverEditAccessSpec.isSshEndabled != null) {
            cloudVmService.setSshEnabled(serverEditAccessSpec.isSshEndabled.booleanValue());
        }
    }

    private void setNetworkingSpec(CloudVmService cloudVmService, ServerEditNetworkingSpec serverEditNetworkingSpec) throws CloudVmServiceException {
        if (serverEditNetworkingSpec == null) {
            return;
        }
        if (serverEditNetworkingSpec.hostname != null) {
            cloudVmService.setHostname(serverEditNetworkingSpec.hostname);
        }
        if (serverEditNetworkingSpec.domains != null) {
            cloudVmService.setDnsDomains(serverEditNetworkingSpec.domains);
        }
        if (serverEditNetworkingSpec.dnsConfig != null) {
            cloudVmService.setDnsServersConfig(serverEditNetworkingSpec.dnsConfig);
        }
        if (serverEditNetworkingSpec.ipv4Config != null && serverEditNetworkingSpec.ipv4Config.length > 0) {
            for (IPv4Config iPv4Config : serverEditNetworkingSpec.ipv4Config) {
                if (iPv4Config.address == null) {
                    iPv4Config.address = "";
                }
                if (iPv4Config.defaultGateway != null) continue;
                iPv4Config.defaultGateway = "";
            }
            cloudVmService.setIPv4Config(serverEditNetworkingSpec.ipv4Config);
        }
        if (serverEditNetworkingSpec.ipv6Config != null && serverEditNetworkingSpec.ipv6Config.length > 0) {
            cloudVmService.setIPv6Config(serverEditNetworkingSpec.ipv6Config);
        }
    }

    private void setFirewallSpec(CloudVmService cloudVmService, ServerEditFirewallSpec serverEditFirewallSpec) throws CloudVmServiceException {
        if (serverEditFirewallSpec == null) {
            return;
        }
        if (serverEditFirewallSpec.rules != null) {
            cloudVmService.setFirewallRules(serverEditFirewallSpec.rules);
        }
    }

    public OperationResult apply(URI uRI, ServerActiveDirectorySpec serverActiveDirectorySpec) {
        OperationResult operationResult = null;
        operationResult = !StringUtil.isNullOrEmpty((String)serverActiveDirectorySpec.domain) ? this.joinActiveDirectory(uRI, serverActiveDirectorySpec) : this.leaveActiveDirectory(uRI, serverActiveDirectorySpec);
        return operationResult;
    }

    private OperationResult joinActiveDirectory(URI uRI, ServerActiveDirectorySpec serverActiveDirectorySpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            SsoAdminService ssoAdminService = this._ssoServiceManager.getAdminService((Object)uRI);
            SystemManagementService systemManagementService = ssoAdminService.getSystemManagementService();
            systemManagementService.joinActiveDirectory(serverActiveDirectorySpec.username, serverActiveDirectorySpec.password, serverActiveDirectorySpec.domain, serverActiveDirectorySpec.organizationalUnit);
        }
        catch (Exception exception) {
            _logger.error((Object)String.format("Error joining Active Directory for %s", CmReferenceUtil.getServerId(uRI)), (Throwable)exception);
            operationResult.error = ServersMutationProvider.getMethodFault(exception);
        }
        return operationResult;
    }

    private OperationResult leaveActiveDirectory(URI uRI, ServerActiveDirectorySpec serverActiveDirectorySpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            SsoAdminService ssoAdminService = this._ssoServiceManager.getAdminService((Object)uRI);
            SystemManagementService systemManagementService = ssoAdminService.getSystemManagementService();
            systemManagementService.leaveActiveDirectory(serverActiveDirectorySpec.username, serverActiveDirectorySpec.password);
        }
        catch (Exception exception) {
            _logger.error((Object)String.format("Error leaving Active Directory for %s", CmReferenceUtil.getServerId(uRI)), (Throwable)exception);
            operationResult.error = ServersMutationProvider.getMethodFault(exception);
        }
        return operationResult;
    }

    private static PowerOperationConfig getPowerOpConfig(ServerOperationSpec serverOperationSpec) {
        PowerOperationConfig powerOperationConfig = new PowerOperationConfig();
        powerOperationConfig.reason = serverOperationSpec.reason;
        powerOperationConfig.delay = -1L;
        return powerOperationConfig;
    }

    private static MethodFault getMethodFault(Exception exception) {
        Throwable throwable;
        if (exception == null) {
            return null;
        }
        if (exception instanceof MethodFault) {
            return (MethodFault)exception;
        }
        if (exception instanceof Error) {
            return CmUtil.transformVapiError((Error)exception);
        }
        if (exception instanceof InvocationTargetException && (throwable = exception.getCause()) != null && throwable != exception && throwable instanceof Exception) {
            return ServersMutationProvider.getMethodFault((Exception)throwable);
        }
        throwable = new MethodFault(exception.getMessage());
        throwable.initCause(exception);
        return throwable;
    }
}

