/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceManager;
import com.vmware.vise.vim.lookup.UserSpecificLsFactory;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.applmgmt.VapiBackedCloudVmService;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplmgmtServiceRegistry
implements UserSessionListener {
    private static final String APPLMGMT_SERVICE_URL_FORMAT = "https://%s/applmgmt/RPC2";
    private static final String APPLMGMT_ENDPOINT_URL_CACHE_KEY = "applmgmtEndpointUrlCache";
    private static final String APPLMGMT_LS_PRODUCT_ID = "com.vmware.applmgmt";
    private static final String APPLMGMT_LS_TYPE_ID = "applmgmt";
    private static final String APPLMGMT_LS_ENDPOINT_TYPE_ID = "com.vmware.applmgmt";
    private static final Log _logger = LogFactory.getLog(ApplmgmtServiceRegistry.class);
    private final UserSpecificLsFactory _lsFactory;
    private final SsoServiceManager _ssoServiceManager;
    private final VapiConnectionManagerRegistry<String> _applmgmtVapiConnectionRegistry;
    private final CloudVmServiceManager _cvsManager;

    public ApplmgmtServiceRegistry(UserSpecificLsFactory userSpecificLsFactory, SsoServiceManager ssoServiceManager, VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, CloudVmServiceManager cloudVmServiceManager) {
        this._lsFactory = userSpecificLsFactory;
        this._ssoServiceManager = ssoServiceManager;
        this._applmgmtVapiConnectionRegistry = vapiConnectionManagerRegistry;
        this._cvsManager = cloudVmServiceManager;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.removeData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY, (HttpSession)httpSessionEvent.getSession());
        if (!MapUtils.isEmpty((Map)map)) {
            map.clear();
        }
    }

    public CloudVmService getCloudVmService(String string) {
        Validate.notNull((Object)string, (String)"Attempting to get applmgmt for a null server");
        VapiConnectionManager vapiConnectionManager = this._applmgmtVapiConnectionRegistry.getConnectionManager((Object)string);
        if (vapiConnectionManager != null) {
            return new VapiBackedCloudVmService(vapiConnectionManager);
        }
        URL uRL = this.getRelatedApplmgmtServiceUrl(string);
        if (uRL == null) {
            return null;
        }
        CloudVmService cloudVmService = this._cvsManager.getService(uRL);
        return cloudVmService;
    }

    private URL getRelatedApplmgmtServiceUrl(String string) {
        assert (!StringUtil.isNullOrEmpty((String)string));
        Map map = (Map)SessionUtil.getData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY);
        String string2 = string.toLowerCase();
        if (!MapUtils.isEmpty((Map)map) && map.containsKey(string2)) {
            return (URL)map.get(string2);
        }
        return this.getRelatedApplmgmtServiceUrlSynchronized(string2);
    }

    private synchronized URL getRelatedApplmgmtServiceUrlSynchronized(String string) {
        Map<String, URL> map = (Map<String, URL>)SessionUtil.getData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY);
        if (MapUtils.isEmpty((Map)map)) {
            map = this.retrieveApplmgmtEndpointUrls();
            SessionUtil.setData((String)APPLMGMT_ENDPOINT_URL_CACHE_KEY, map);
        }
        return map.get(string);
    }

    private Map<String, URL> retrieveApplmgmtEndpointUrls() {
        InternalServerInfo internalServerInfo2;
        HashMap<String, URL> hashMap = new HashMap<String, URL>();
        Collection<InternalServerInfo> collection = CmUtil.getServers(this._ssoServiceManager);
        for (InternalServerInfo internalServerInfo2 : collection) {
            hashMap.put(internalServerInfo2.getHostname().toLowerCase(), null);
        }
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        internalServerInfo2 = new ServiceRegistration.ServiceType();
        internalServerInfo2.setProduct("com.vmware.applmgmt");
        internalServerInfo2.setType(APPLMGMT_LS_TYPE_ID);
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setProtocol("http");
        endpointType.setType("com.vmware.applmgmt");
        filter.setServiceType((ServiceRegistration.ServiceType)internalServerInfo2);
        filter.setEndpointType(endpointType);
        ServiceRegistration.Info[] infoArray = this._lsFactory.getLookupService().getServiceRegistrationInfos(filter);
        if (infoArray != null) {
            for (ServiceRegistration.Info info : infoArray) {
                ServiceRegistration.Endpoint endpoint = info.getServiceEndpoints()[0];
                URI uRI = endpoint.getUrl();
                String string = uRI.getHost().toLowerCase().replaceAll("[\\]\\[]", "");
                try {
                    hashMap.put(string, uRI.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    _logger.error((Object)("Invalid applmgmgt endpoint URI retrieved for host" + string), (Throwable)malformedURLException);
                    hashMap.put(string, this.buildApplmgmtUrl(string));
                }
            }
        }
        return hashMap;
    }

    private URL buildApplmgmtUrl(String string) {
        try {
            return new URL(String.format(APPLMGMT_SERVICE_URL_FORMAT, string));
        }
        catch (MalformedURLException malformedURLException) {
            _logger.error((Object)("Failed to build URL for server " + string), (Throwable)malformedURLException);
            return null;
        }
    }
}

