/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.google.common.collect.Sets;
import com.vmware.appliance.vmon.Service;
import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.Error;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.sca.ServiceInfo;
import com.vmware.vim.binding.sca.ServiceInstanceContent;
import com.vmware.vim.binding.sca.ServiceManager;
import com.vmware.vim.binding.sca.control.ServiceState;
import com.vmware.vim.binding.sca.control.StartupType;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.sso.admin.ComputerManagementService;
import com.vmware.vim.binding.sso.admin.VmHost;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.common.vapi.localization.VapiLocalizationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.ServiceStartupType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CmUtil {
    public static final String VCENTER_SERVICE_TYPE_ID = "vcenterserver";
    public static final String APPLMGMT_SCA_ID = "applmgmt";
    public static final String CLOUDVM_VPXD_SCA_ID = "vmware-vpxd";
    public static final String CISWIN_VPXD_SCA_ID = "vpxd";
    public static final String VPXD_VMON_ID = "vpxd";
    public static final String VSPHERE_CLIENT_SCA_ID = "vsphere-client";
    public static final Set<String> UNHANDLED_PROPERTIES_TO_IGNORE = Sets.newHashSet((Object[])new String[]{"id", "labelIds", "primaryIconId"});
    public static final String NAME_PROP = "name";
    public static final String SERVER_ICON_ID_PROP = "serverIconId";
    public static final String HEALTH_MESSAGES_PROP = "healthMessages";
    public static final String SERVER_NAME_PROP = "serverName";
    public static final String SERVICE_SHORT_NAME_PROP = "shortName";
    public static final String SERVICE_HEALTH_PROP = "health";
    public static final String SCA_SERVICE_STATE_PROP = "scaServiceState";
    public static final String SERVICE_STARTUP_TYPE_PROP = "startupType";
    public static final String SERVICE_TYPE_PROP = "serviceType";
    public static final String SERVICE_STATUS_PROP = "status";
    public static final String SERVICE_IS_STARTABLE = "isStartable";
    public static final String SERVICE_IS_STOPPABLE = "isStoppable";
    public static final String SERVICE_IS_RESTARTABLE = "isRestartable";
    public static final String SERVICE_STARTUP_TYPE_EDITABLE_PROP = "startupTypeEditable";
    public static final String SERVICE_AUTO_STARTUP_TYPE_SUPPORTED_PROP = "autoStartupTypeSupported";
    public static final String SERVICE_MANUAL_STARTUP_TYPE_SUPPORTED_PROP = "manualStartupTypeSupported";
    public static final String SERVICE_DISABLED_STARTUP_TYPE_SUPPORTED_PROP = "disabledStartupTypeSupported";
    public static final String SERVICE_DESCRIPTION_PROP = "description";
    public static final String SERVER_PROP = "server";
    public static final String SERVICES_PROP = "services";
    public static final String SERVER_SERVICE_INFOS_PROP = "serviceInfos";
    public static final String SERVER_IS_APPLIANCE_MANAGED_PROP = "isApplianceManaged";
    public static final String SERVER_APPLMGMT_DOWN_PROP = "applmgmtExistsAndDown";
    public static final String SERVER_APPLMGMT_UP_PROP = "applmgmtExistsAndUp";
    public static final String SERVER_IS_UNREACHABLE_PROP = "isUnreachable";
    public static final String SERVER_IS_DOMAIN_CONTROLLER = "isDomainController";
    public static final String VC_SERVICE_ROOT_FOLDER_PROP = "relatedVc";
    public static final String SERVER_APPLMGMT_CONTROL_STATE_PROP = "applmgmtControlState";
    public static final String SERVER_DEPLOYMENT_TYPE_PROP = "deploymentType";
    public static final String SERVER_CONSOLE_CLI_ENABLED_PROP = "consoleCliEnabled";
    public static final String SERVER_DCUI_ENABLED_PROP = "dcuiEnabled";
    public static final String SERVER_SHELL_CONFIG_PROP = "shellConfig";
    public static final String SERVER_SSH_ENABLED_PROP = "sshEnabled";
    public static final String SERVER_CPU_STATS_PROP = "cpuStats";
    public static final String SERVER_MEM_STATS_PROP = "memStats";
    public static final String SERVER_NET_STATS_PROP = "netStats";
    public static final String SERVER_STORAGE_STATS_PROP = "storageStats";
    public static final String SERVER_SYSTEM_HEALTH_PROP = "systemHealth";
    public static final String SERVER_STORAGE_HEALTH_PROP = "storageHealth";
    public static final String SERVER_MEM_HEALTH_PROP = "memHealth";
    public static final String SERVER_LOAD_HEALTH_PROP = "loadHealth";
    public static final String SERVER_DNS_DOMAINS_PROP = "domains";
    public static final String SERVER_HOSTNAME_PROP = "hostname";
    public static final String SERVER_DNS_CONFIG_PROP = "dnsConfig";
    public static final String SERVER_NICS_PROP = "nics";
    public static final String SERVER_IPV4_CONFIG_PROP = "ipv4Config";
    public static final String SERVER_IPV6_CONFIG_PROP = "ipv6Config";
    public static final String SERVER_FIREWALL_RULES_PROP = "firewallRules";
    public static final String SERVER_ROUTES_PROP = "routes";
    public static final String SERVER_SWAP_HEALTH_PROP = "swapHealth";
    public static final String SERVER_UPTIME_PROP = "uptime";
    public static final String SERVER_LOG_MANIFEST_ARRAY = "manifestArray";
    public static final String SERVER_ACTIVE_DIRECTORY_INFO_RPOP = "activeDirectoryInfo";
    public static final String SERVER_ACTIVE_DIRECTORY_JOINED_RPOP = "activeDirectoryJoined";
    public static final String SERVER_SUPPORT_BUNDLE_URL_PROP = "supportBundleUrl";
    public static final String VM_INFO_PROP = "vmInfo";
    public static final long SCA_SERVICE_STATES_QUERY_TIMEOUT = 10L;
    public static final int SCA_NO_SUCH_OBJECT_ERROR_CODE = 2;
    private static final String RESOURCE_BUNDLE_NAME = "ComponentManagerService";
    public static final String SERVER_VMCA_CLIENTS_INITIALIZED_PROPERTY = "isvmcainitialized";
    private static final Log _logger = LogFactory.getLog(CmUtil.class);

    public static MethodFault getFault(String string, String ... stringArray) {
        String string2 = CmUtil.getLocalizedString(string, stringArray);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
        MethodFault methodFault = MixedUtil.getMethodFault((Throwable)illegalArgumentException);
        return methodFault;
    }

    public static String getLocalizedString(String string, String ... stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)CmUtil.class.getClassLoader());
    }

    public static String getServerHostname(ServiceRegistration.Info info) {
        Object object;
        String string = null;
        assert (info != null);
        Object[] objectArray = info.getServiceEndpoints();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            _logger.warn((Object)"Unable to get the hostname for server. no endpoints available.");
            return "";
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0; i < n && StringUtil.isNullOrEmpty((String)(string = (object = objectArray2[i]).getUrl().getHost())); ++i) {
        }
        return string;
    }

    public static Collection<InternalServiceInfo> getScaServicesForServer(ScaServiceManager scaServiceManager, String string, String[] stringArray) throws ServiceManagerFault {
        ServiceInstanceContent serviceInstanceContent;
        ArrayList<InternalServiceInfo> arrayList = new ArrayList<InternalServiceInfo>();
        ScaService scaService = scaServiceManager.getService((Object)string);
        ServiceManager serviceManager = (ServiceManager)scaService.getManagedObject((serviceInstanceContent = scaService.getServiceContent()).getServiceManager());
        Object[] objectArray = serviceManager.list(stringArray);
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                arrayList.add(new InternalServiceInfo((ServiceInfo)object, null, null, string));
            }
        }
        return arrayList;
    }

    public static Collection<InternalServiceInfo> getScaServicesForServer(ScaServiceManager scaServiceManager, String string) throws ServiceManagerFault {
        return CmUtil.getScaServicesForServer(scaServiceManager, string, null);
    }

    public static InternalServiceInfo getScaServiceByName(ScaServiceManager scaServiceManager, String string, String string2) throws ServiceManagerFault {
        Object[] objectArray;
        assert (!StringUtil.isNullOrEmpty((String)string) && !StringUtil.isNullOrEmpty((String)string2));
        InternalServiceInfo internalServiceInfo = null;
        ScaService scaService = scaServiceManager.getService((Object)string);
        ServiceManager serviceManager = (ServiceManager)scaService.getManagedObject(scaService.getServiceContent().getServiceManager());
        try {
            objectArray = serviceManager.list(new String[]{string2});
        }
        catch (ServiceManagerFault serviceManagerFault) {
            if (2 == serviceManagerFault.getErrorCode()) {
                return null;
            }
            throw serviceManagerFault;
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray) && objectArray[0] != null) {
            internalServiceInfo = new InternalServiceInfo((ServiceInfo)objectArray[0], null, null, string);
        }
        return internalServiceInfo;
    }

    public static Collection<InternalServiceInfo> getVmonServicesForServer(VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, String string) {
        return CmUtil.getVmonServicesForServer(vapiConnectionManagerRegistry, string, null);
    }

    public static Collection<InternalServiceInfo> getVmonServicesForServer(VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, String string, String[] stringArray) {
        assert (vapiConnectionManagerRegistry != null);
        assert (string != null);
        Service service = (Service)vapiConnectionManagerRegistry.getService(Service.class, (Object)string);
        Map map = service.listDetails();
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<InternalServiceInfo> arrayList = new ArrayList<InternalServiceInfo>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (stringArray != null && !ArrayUtils.contains((Object[])stringArray, entry.getKey())) continue;
            arrayList.add(new InternalServiceInfo(null, (String)entry.getKey(), (ServiceTypes.Info)entry.getValue(), string));
        }
        return arrayList;
    }

    public static ServiceTypes.Info getVmonServiceInfo(VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, String string, String string2) {
        Service service = (Service)vapiConnectionManagerRegistry.getService(Service.class, (Object)string);
        if (service == null) {
            return null;
        }
        try {
            return service.get(string2);
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    public static Collection<InternalServerInfo> getServers(SsoServiceManager ssoServiceManager) {
        try {
            ArrayList<InternalServerInfo> arrayList = new ArrayList<InternalServerInfo>();
            SsoAdminService ssoAdminService = ssoServiceManager.getAdminService(null);
            ComputerManagementService computerManagementService = ssoAdminService.getComputerManagementService();
            Object[] objectArray = computerManagementService.getComputers(false);
            for (VmHost vmHost : (VmHost[])ArrayUtil.toSafe((Object[])objectArray, VmHost.class)) {
                InternalServerInfo internalServerInfo = new InternalServerInfo(vmHost.hostName, vmHost.domainController);
                arrayList.add(internalServerInfo);
            }
            return arrayList;
        }
        catch (Exception exception) {
            _logger.error((Object)"Cannot retrieve server nodes", (Throwable)exception);
            return new ArrayList<InternalServerInfo>();
        }
    }

    public static ServiceStatus scaCodeToServiceStatus(String string) {
        ServiceStatus serviceStatus = ServiceStatus.UNKNOWN;
        if (ServiceState.ControlStatus.RUNNING.toString().equalsIgnoreCase(string)) {
            serviceStatus = ServiceStatus.RUNNING;
        } else if (ServiceState.ControlStatus.STOPPED.toString().equalsIgnoreCase(string)) {
            serviceStatus = ServiceStatus.STOPPED_NORMAL;
        } else if (ServiceState.ControlStatus.STOPPED_ABNORMAL.toString().equalsIgnoreCase(string)) {
            serviceStatus = ServiceStatus.STOPPED_ABNORMAL;
        }
        return serviceStatus;
    }

    public static ServiceStatus vmonCodeToServiceStatus(ServiceTypes.State state) {
        ServiceStatus serviceStatus = ServiceStatus.UNKNOWN;
        if (ServiceTypes.State.STARTED.equals((Object)state)) {
            serviceStatus = ServiceStatus.RUNNING;
        } else if (ServiceTypes.State.STARTING.equals((Object)state)) {
            serviceStatus = ServiceStatus.RUNNING;
        } else if (ServiceTypes.State.STOPPED.equals((Object)state)) {
            serviceStatus = ServiceStatus.STOPPED_NORMAL;
        } else if (ServiceTypes.State.STOPPING.equals((Object)state)) {
            serviceStatus = ServiceStatus.RUNNING;
        }
        return serviceStatus;
    }

    public static String[] extractHealthMessages(ServiceState serviceState) {
        com.vmware.vim.binding.vmodl.LocalizableMessage[] localizableMessageArray;
        com.vmware.vim.binding.vmodl.LocalizableMessage[] localizableMessageArray2 = localizableMessageArray = serviceState != null ? serviceState.healthMessages : null;
        if (localizableMessageArray != null && localizableMessageArray.length > 0) {
            String[] stringArray = new String[localizableMessageArray.length];
            for (int i = 0; i < localizableMessageArray.length; ++i) {
                stringArray[i] = LocalizationUtil.getLocalizedMessage((String)localizableMessageArray[i].getKey(), (KeyAnyValue[])localizableMessageArray[i].getArg());
            }
            return stringArray;
        }
        return null;
    }

    public static String[] extractHealthMessages(ServiceTypes.Info info) {
        List list;
        List list2 = list = info != null ? info.getHealthMessages() : null;
        if (list != null && list.size() > 0) {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = VapiLocalizationUtil.getLocalizedMessage((LocalizableMessage)((LocalizableMessage)list.get(i)));
            }
            return stringArray;
        }
        return null;
    }

    public static HealthState healthStateFromScaHealthStatus(String string) {
        HealthState healthState = HealthState.UNKNOWN;
        if (StringUtil.isNullOrEmpty((String)string)) {
            healthState = HealthState.UNSUPPORTED;
        } else if (ServiceState.HealthStatus.GREEN.toString().equalsIgnoreCase(string)) {
            healthState = HealthState.GOOD;
        } else if (ServiceState.HealthStatus.YELLOW.toString().equalsIgnoreCase(string)) {
            healthState = HealthState.WARNING;
        } else if (ServiceState.HealthStatus.RED.toString().equalsIgnoreCase(string)) {
            healthState = HealthState.CRITICAL;
        } else if (ServiceState.HealthStatus.HEALTH_UNKNOWN.toString().equalsIgnoreCase(string)) {
            healthState = HealthState.UNKNOWN;
        }
        return healthState;
    }

    public static HealthState healthStateFromVmonHealthStatus(ServiceTypes.Health health) {
        HealthState healthState = HealthState.UNKNOWN;
        if (health == null) {
            healthState = HealthState.UNSUPPORTED;
        } else if (health.equals((Object)ServiceTypes.Health.HEALTHY)) {
            healthState = HealthState.GOOD;
        } else if (health.equals((Object)ServiceTypes.Health.HEALTHY_WITH_WARNINGS)) {
            healthState = HealthState.WARNING;
        } else if (health.equals((Object)ServiceTypes.Health.DEGRADED)) {
            healthState = HealthState.CRITICAL;
        }
        return healthState;
    }

    public static ServiceStartupType serviceStartupTypeFromScaStartupType(StartupType startupType) {
        ServiceStartupType serviceStartupType = ServiceStartupType.UNKNOWN;
        if (startupType != null) {
            if (ServiceStartupType.AUTOMATIC.toString().equalsIgnoreCase(startupType.choice)) {
                serviceStartupType = ServiceStartupType.AUTOMATIC;
            } else if (ServiceStartupType.MANUAL.toString().equalsIgnoreCase(startupType.choice)) {
                serviceStartupType = ServiceStartupType.MANUAL;
            } else if (ServiceStartupType.DISABLED.toString().equalsIgnoreCase(startupType.choice)) {
                serviceStartupType = ServiceStartupType.DISABLED;
            }
        }
        return serviceStartupType;
    }

    public static ServiceStartupType serviceStartupTypeFromVmonStartupType(ServiceTypes.StartupType startupType) {
        ServiceStartupType serviceStartupType = ServiceStartupType.UNKNOWN;
        if (ServiceTypes.StartupType.AUTOMATIC.equals((Object)startupType)) {
            serviceStartupType = ServiceStartupType.AUTOMATIC;
        } else if (ServiceTypes.StartupType.MANUAL.equals((Object)startupType)) {
            serviceStartupType = ServiceStartupType.MANUAL;
        } else if (ServiceTypes.StartupType.DISABLED.equals((Object)startupType)) {
            serviceStartupType = ServiceStartupType.DISABLED;
        }
        return serviceStartupType;
    }

    public static String getLocalizedMessage(com.vmware.vim.binding.vmodl.LocalizableMessage localizableMessage) {
        assert (localizableMessage != null);
        String string = LocalizationUtil.getLocalizedMessage((String)localizableMessage.getKey(), (KeyAnyValue[])localizableMessage.getArg());
        if (StringUtils.equals((String)string, (String)localizableMessage.getKey())) {
            string = localizableMessage.getMessage();
        }
        return string;
    }

    public static MethodFault transformVapiError(Error error) {
        assert (error != null);
        MethodFault methodFault = new MethodFault();
        List list = error.getMessages();
        if (list != null) {
            List list2 = VapiLocalizationUtil.getLocalizedMessages((List)list);
            methodFault.setMessage(StringUtils.join((Collection)list2, (String)"\n"));
        } else {
            methodFault.setMessage(error.getMessage());
        }
        methodFault.initCause((Throwable)error);
        return methodFault;
    }
}

