/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.cis.cm.common.ScmDataTypes;
import com.vmware.vim.binding.sca.configuration.Configuration;
import com.vmware.vim.binding.sca.configuration.ConfigurationDefinition;
import com.vmware.vim.binding.sca.configuration.Parameter;
import com.vmware.vim.binding.sca.configuration.ServiceConfigurationManager;
import com.vmware.vim.binding.sca.configuration.metadata.PropertyDescriptor;
import com.vmware.vim.binding.sca.configuration.metadata.TypeDescriptor;
import com.vmware.vim.binding.sca.configuration.metadata.XSFacet;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScmUtil {
    private static final Log _logger = LogFactory.getLog(ScmUtil.class);
    public static final String RESOURCE_REGISTERED_PROPERTY = "configurationRegistered";
    public static final String RESOURCES_PROPERTY = "resources";
    public static final String CONFIGURATIONS_PROPERTY = "configurations";
    public static final String DEFINITIONS_PROPERTY = "definitions";
    public static final String MUTATION_MAPPING_PROPERTY = "settings.{resourceKey*}";
    private static final String ALL_SETTINGS_PROPERTY_REGEX = "settings(\\.)(.+)";
    private static final String SETTINGS_PREFIX_REGEX = "settings(\\.)";
    private static final String SETTINGS_INFO_PROP_REGEX = "@info";
    private static final String SETTINGS_INFO_IMMUTABLE_PROP_REGEX = "@info.immutable";

    public static boolean isSettingsProperty(String string) {
        if (string == null) {
            return false;
        }
        return string.matches(ALL_SETTINGS_PROPERTY_REGEX);
    }

    public static boolean isResourceRegistered(ServiceConfigurationManager serviceConfigurationManager, InternalServiceInfo internalServiceInfo) {
        String string = ScmUtil.getServiceId(internalServiceInfo);
        try {
            String[] stringArray = serviceConfigurationManager.getResources(string);
            return stringArray != null && stringArray.length != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String[] getResources(ServiceConfigurationManager serviceConfigurationManager, InternalServiceInfo internalServiceInfo) {
        String string = ScmUtil.getServiceId(internalServiceInfo);
        if (serviceConfigurationManager == null || string == null) {
            return null;
        }
        try {
            return serviceConfigurationManager.getResources(string);
        }
        catch (ServiceManagerFault serviceManagerFault) {
            return null;
        }
    }

    public static Configuration[] getConfigurations(ServiceConfigurationManager serviceConfigurationManager, InternalServiceInfo internalServiceInfo) {
        String string = ScmUtil.getServiceId(internalServiceInfo);
        if (serviceConfigurationManager == null || string == null) {
            return null;
        }
        try {
            return serviceConfigurationManager.getConfigurations(string);
        }
        catch (ServiceManagerFault serviceManagerFault) {
            return null;
        }
    }

    public static ConfigurationDefinition[] getDefinitions(ServiceConfigurationManager serviceConfigurationManager, InternalServiceInfo internalServiceInfo) {
        String string = ScmUtil.getServiceId(internalServiceInfo);
        if (serviceConfigurationManager == null || string == null) {
            return null;
        }
        try {
            ConfigurationDefinition[] configurationDefinitionArray = serviceConfigurationManager.getDefinitions(string);
            ConfigurationDefinition[] configurationDefinitionArray2 = ScmUtil.localizeResourceTitles(configurationDefinitionArray);
            return configurationDefinitionArray2;
        }
        catch (ServiceManagerFault serviceManagerFault) {
            return null;
        }
    }

    public static Object getSettings(ServiceConfigurationManager serviceConfigurationManager, InternalServiceInfo internalServiceInfo, String string) {
        String string2 = ScmUtil.getServiceId(internalServiceInfo);
        if (serviceConfigurationManager == null || string2 == null || string == null) {
            return null;
        }
        String string3 = string.replaceFirst(SETTINGS_PREFIX_REGEX, "");
        if (string3.endsWith(SETTINGS_INFO_IMMUTABLE_PROP_REGEX)) {
            if (ScmUtil.isResourceRegistered(serviceConfigurationManager, internalServiceInfo)) {
                return false;
            }
            return null;
        }
        if (string3.endsWith(SETTINGS_INFO_PROP_REGEX)) {
            String string4 = string3.substring(0, string3.length() - SETTINGS_INFO_PROP_REGEX.length() - 1);
            try {
                ConfigurationDefinition configurationDefinition = serviceConfigurationManager.getDefinition(string2, string4);
                return ScmUtil.convertToTypeNodeDescriptor(configurationDefinition);
            }
            catch (ServiceManagerFault serviceManagerFault) {
                return new TypeNodeDescriptor();
            }
        }
        try {
            Configuration configuration = serviceConfigurationManager.getConfiguration(string2, string3);
            return ScmUtil.convertToDynamicObject(configuration);
        }
        catch (ServiceManagerFault serviceManagerFault) {
            return null;
        }
    }

    public static Parameter[] convertToParameterArray(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Parameter parameter = ScmUtil.convertToParameter(entry);
            if (parameter == null) continue;
            arrayList.add(parameter);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    private static Parameter convertToParameter(Map.Entry<String, Object> entry) {
        if (entry == null) {
            return null;
        }
        String string = entry.getKey();
        Object object = entry.getValue();
        String string2 = null;
        if (object != null) {
            string2 = object.toString();
        }
        Parameter parameter = new Parameter();
        parameter.setName(string);
        parameter.setValue(string2);
        return parameter;
    }

    private static DynamicObject convertToDynamicObject(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        Parameter[] parameterArray = configuration.getParameters();
        if (parameterArray == null || parameterArray.length == 0) {
            return null;
        }
        int n = parameterArray.length;
        DynamicObject dynamicObject = new DynamicObject();
        dynamicObject.properties = new NameValuePair[n];
        int n2 = 0;
        for (Parameter parameter : parameterArray) {
            dynamicObject.properties[n2++] = new NameValuePair(parameter.getName(), (Object)parameter.getValue());
        }
        return dynamicObject;
    }

    private static TypeNodeDescriptor convertToTypeNodeDescriptor(ConfigurationDefinition configurationDefinition) {
        if (configurationDefinition == null) {
            return null;
        }
        TypeNodeDescriptor typeNodeDescriptor = new TypeNodeDescriptor();
        TypeDescriptor typeDescriptor = configurationDefinition.getMetadata();
        typeNodeDescriptor.title = LocalizationUtil.getLocalizedMessage((String)typeDescriptor.getName());
        typeNodeDescriptor.properties = ScmUtil.convertToPropertyNodeDescriptor(typeDescriptor.getProperties());
        typeNodeDescriptor.name = LocalizationUtil.getLocalizedMessage((String)typeDescriptor.getTitle());
        String string = typeDescriptor.getDescription();
        typeNodeDescriptor.description = LocalizationUtil.getLocalizedMessage((String)string);
        typeNodeDescriptor.tags = ScmUtil.convertToMap(typeDescriptor.getOptions());
        return typeNodeDescriptor;
    }

    private static PropertyNodeDescriptor[] convertToPropertyNodeDescriptor(PropertyDescriptor[] propertyDescriptorArray) {
        if (propertyDescriptorArray == null) {
            return null;
        }
        ArrayList<PropertyNodeDescriptor> arrayList = new ArrayList<PropertyNodeDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            PropertyNodeDescriptor propertyNodeDescriptor = new PropertyNodeDescriptor();
            propertyNodeDescriptor.staticValueSpace = ScmUtil.convertToRfwXSFacet(propertyDescriptor.getStaticValueSpace());
            String string = propertyDescriptor.getDescription();
            propertyNodeDescriptor.description = LocalizationUtil.getLocalizedMessage((String)string);
            propertyNodeDescriptor.immutable = propertyDescriptor.getImmutable();
            if (propertyDescriptor.getOptional() != null) {
                propertyNodeDescriptor.isOptional = propertyDescriptor.getOptional();
            }
            propertyNodeDescriptor.name = propertyDescriptor.getName();
            propertyNodeDescriptor.tags = ScmUtil.convertToMap(propertyDescriptor.getOptions());
            String string2 = propertyDescriptor.getTitle();
            propertyNodeDescriptor.title = LocalizationUtil.getLocalizedMessage((String)string2);
            propertyNodeDescriptor.valueTypeName = ScmUtil.convertToRfwType(propertyDescriptor.getType().getName());
            arrayList.add(propertyNodeDescriptor);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new PropertyNodeDescriptor[arrayList.size()]);
    }

    private static com.vmware.vise.data.common.XSFacet[] convertToRfwXSFacet(XSFacet[] xSFacetArray) {
        if (xSFacetArray == null || xSFacetArray.length == 0) {
            return null;
        }
        ArrayList<com.vmware.vise.data.common.XSFacet> arrayList = new ArrayList<com.vmware.vise.data.common.XSFacet>();
        for (XSFacet xSFacet : xSFacetArray) {
            if (xSFacet.getType() == null || xSFacet.getType().getChoice() == null) {
                _logger.warn((Object)"CIS XSFacet type choice is null.");
                continue;
            }
            com.vmware.vise.data.common.XSFacet xSFacet2 = new com.vmware.vise.data.common.XSFacet();
            xSFacet2.type = XSFacetType.valueOf((String)xSFacet.getType().getChoice());
            xSFacet2.value = xSFacet.getValue();
            arrayList.add(xSFacet2);
        }
        return arrayList.toArray(new com.vmware.vise.data.common.XSFacet[arrayList.size()]);
    }

    private static Map<String, String> convertToMap(KeyAnyValue[] keyAnyValueArray) {
        if (keyAnyValueArray == null || keyAnyValueArray.length == 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            if (keyAnyValue.getKey() == null) continue;
            Object object = keyAnyValue.getValue();
            String string = null;
            if (object != null) {
                string = keyAnyValue.getValue().toString();
            }
            hashMap.put(keyAnyValue.getKey(), string);
        }
        return hashMap;
    }

    private static String convertToRfwType(String string) {
        if (string == null) {
            _logger.error((Object)"SCM type is null.");
            return "string";
        }
        if (ScmDataTypes.DECIMAL.toString().equalsIgnoreCase(string)) {
            return "float";
        }
        if (ScmDataTypes.DOUBLE.toString().equalsIgnoreCase(string)) {
            return "float";
        }
        if (ScmDataTypes.FLOAT.toString().equalsIgnoreCase(string)) {
            return "float";
        }
        if (ScmDataTypes.LONG.toString().equalsIgnoreCase(string)) {
            return "long";
        }
        if (ScmDataTypes.INTEGER.toString().equalsIgnoreCase(string)) {
            return "int";
        }
        if (ScmDataTypes.SHORT.toString().equalsIgnoreCase(string)) {
            return "int";
        }
        if (ScmDataTypes.BYTE.toString().equalsIgnoreCase(string)) {
            return "int";
        }
        if (ScmDataTypes.BOOLEAN.toString().equalsIgnoreCase(string)) {
            return "boolean";
        }
        if (ScmDataTypes.STRING.toString().equalsIgnoreCase(string)) {
            return "string";
        }
        _logger.error((Object)"SCM type is unknown. Attempting to convert to RFW string.");
        return "string";
    }

    private static ConfigurationDefinition[] localizeResourceTitles(ConfigurationDefinition[] configurationDefinitionArray) {
        for (ConfigurationDefinition configurationDefinition : configurationDefinitionArray) {
            TypeDescriptor typeDescriptor = configurationDefinition.getMetadata();
            if (typeDescriptor == null) continue;
            String string = typeDescriptor.getTitle();
            String string2 = LocalizationUtil.getLocalizedMessage((String)string);
            typeDescriptor.setTitle(string2);
        }
        return configurationDefinitionArray;
    }

    private static String getServiceId(InternalServiceInfo internalServiceInfo) {
        if (internalServiceInfo == null) {
            return null;
        }
        return internalServiceInfo.getServiceId();
    }
}

