/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.util.HealthStateComparator;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.ServiceInfoPropertyValueExtractor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public final class ServiceInfoComparator
implements Comparator<InternalServiceInfo> {
    private final OrderingCriteria _orderingCriteria;
    private final ServiceInfoPropertyValueExtractor _serviceValueExtractor;
    private HashMap<String, HashMap<InternalServiceInfo, Object>> _precomputedProperties;
    private InternalServiceInfo[] _services;

    public ServiceInfoComparator(OrderingCriteria orderingCriteria, ServiceInfoPropertyValueExtractor serviceInfoPropertyValueExtractor, InternalServiceInfo[] internalServiceInfoArray) {
        this._orderingCriteria = orderingCriteria;
        this._serviceValueExtractor = serviceInfoPropertyValueExtractor;
        this._services = internalServiceInfoArray;
        this.precomputeNeededProperties();
    }

    private void precomputeNeededProperties() {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        OrderingPropertySpec[] objectArray = this._orderingCriteria.orderingProperties;
        int objectArray2 = objectArray.length;
        for (n = 0; n < objectArray2; ++n) {
            OrderingPropertySpec orderingPropertySpec = objectArray[n];
            for (String string : orderingPropertySpec.propertyNames) {
                hashSet.add(string);
            }
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        Object[][] objectArray3 = this._serviceValueExtractor.getValues(this._services, stringArray);
        this._precomputedProperties = new HashMap();
        for (n = 0; n < stringArray.length; ++n) {
            HashMap<InternalServiceInfo, Object> hashMap = new HashMap<InternalServiceInfo, Object>();
            Object[] objectArray4 = objectArray3[n];
            for (int i = 0; i < this._services.length; ++i) {
                hashMap.put(this._services[i], objectArray4[i]);
            }
            this._precomputedProperties.put(stringArray[n], hashMap);
        }
    }

    @Override
    public int compare(InternalServiceInfo internalServiceInfo, InternalServiceInfo internalServiceInfo2) {
        for (OrderingPropertySpec orderingPropertySpec : this._orderingCriteria.orderingProperties) {
            for (String string : orderingPropertySpec.propertyNames) {
                int n;
                Object object = this.getServiceProperty(internalServiceInfo, string);
                Object object2 = this.getServiceProperty(internalServiceInfo2, string);
                int n2 = 0;
                if (object == null && object2 == null || (n2 = object == null ? 1 : (object2 == null ? -1 : (object instanceof HealthState ? this.compareByHealth((HealthState)((Object)object), (HealthState)((Object)object2)) : (object instanceof Comparable ? (n = ((Comparable)object).compareTo(object2)) : object.toString().compareToIgnoreCase(object2.toString()))))) == 0) continue;
                return orderingPropertySpec.orderingType == SortType.ASCENDING ? n2 : -n2;
            }
        }
        return 0;
    }

    private int compareByHealth(HealthState healthState, HealthState healthState2) {
        return HealthStateComparator.getInstance().compare(healthState, healthState2);
    }

    private Object getServiceProperty(InternalServiceInfo internalServiceInfo, String string) {
        assert (this._precomputedProperties.containsKey(string) && this._precomputedProperties.get(string).containsKey(internalServiceInfo));
        return this._precomputedProperties.get(string).get(internalServiceInfo);
    }
}

