@echo off
REM --- Copyright (c) 2012-2017 VMware, Inc. All rights reserved.
@IF not defined ANT_HOME (
   @echo You must set the env variable ANT_HOME to your Apache Ant folder
   goto end
)

@echo.This script creates a Flex plug-in for VMware Web Client (Hit Return to use default values in [ ])
@echo.
@setlocal

@SET /P pluginName="Enter a plug-in name in lowercase [myplugin]: "
@IF "%pluginName%" == "" SET pluginName=myplugin

@SET /P parentDir="Enter the parent folder path [%CD%]: "
@IF "%parentDir%" == "" SET parentDir=%CD%

@SET pluginDir=%parentDir%\%pluginName%
@IF EXIST %pluginDir% (
   @CHOICE /M "Replace existing %pluginDir%"
   @IF errorlevel 2 goto end
   @RMDIR /s/q %pluginDir%
) ELSE (
   @CHOICE /M "Create the plugin in %pluginDir%"
   @IF errorlevel 2 goto end
)

REM ----- convert the first character of pluginName to uppercase
@SET char1=%pluginName:~0,1%
@SET pluginName2=%pluginName:~1%
FOR %%i IN ("a=A" "b=B" "c=C" "d=D" "e=E" "f=F" "g=G" "h=H" "i=I" "j=J" "k=K" "l=L" "m=M" "n=N" "o=O" "p=P" "q=Q" "r=R" "s=S" "t=T" "u=U" "v=V" "w=W" "x=X" "y=Y" "z=Z") DO CALL SET "char1=%%char1:%%~i%%"
@SET mainClass=%char1%%pluginName2%Module

@SET /P moduleName="Enter the Flex module name [%mainClass%]: "
@IF "%moduleName%" == "" SET moduleName=%mainClass%

@SET /P packageName="Enter the package name [com.acme.%pluginName%]: "
@IF "%packageName%" == "" SET packageName=com.acme.%pluginName%
@SET packageDir=%packageName:.=/%

@CHOICE /M "Add a sample view & mediator?"
@IF errorlevel 1 @SET generateView=true
@SET pluginView=%moduleName%View
@SET pluginMediator=%moduleName%Mediator

REM ----- copy the template files
REM @XCOPY %~dp0..\resources\plugin-template  "%parentDir%/%pluginName%" /E /Q /I

REM ----- run ant script
@CALL "%ANT_HOME%\bin\ant" -f %~dp0\create-flex-plugin.xml ^
      -DprojectDir="%pluginDir%" ^
      -DpluginTemplateDir="%~dp0resources\plugin-template" ^
      -DpluginName="%pluginName%" ^
      -DpackageName="%packageName%" ^
      -DpackageDir="%packageDir%" ^
      -DmoduleName="%moduleName%" ^
      -DpluginView="%pluginView%" ^
      -DpluginMediator="%pluginMediator%" ^
      -DgenerateView="%generateView%"


@CD %pluginDir%
@echo.
@echo Your new Flex plug-in was created in %pluginDir%"
@echo To build it import the .project in Eclipse or run the build script on the command line.

:end
@endlocal
