@echo off
REM --- Copyright (c) 2012-2017 VMware, Inc. All rights reserved.
@IF not defined ANT_HOME (
   @echo You must set the env variable ANT_HOME to your Apache Ant folder
   goto end
)

@echo.This script packages an existing Flex and Java plug-in (Hit Return to use default values in [ ])
@echo.
@setlocal

@SET /P pluginName="Enter your plug-in name in lowercase [myplugin]: "
@IF "%pluginName%" == "" SET pluginName=myplugin

@SET /P pluginDir="Enter your plugin location [%CD%]: "
@IF "%pluginDir%" == "" SET pluginDir=%CD%

@IF NOT EXIST %pluginDir% (
   @echo. "%pluginDir% does not exist!"
   @goto end
)

@SET baseDir=%pluginDir%/war/target/%pluginName%-war

@SET /P packageName="Enter the package name [com.abc.%pluginName%]: "
@IF "%packageName%" == "" SET packageName=com.abc.%pluginName%
@SET packageDir=%packageName:.=/%

@SET /P serviceName="Enter the java service name or leave blank to skip: "
@SET /P sDir="Enter the java service location: "
@SET serviceDir=%sDir%\target\classes

REM ----- run ant script
@CALL "%ANT_HOME%\bin\ant" -f %~dp0\package-plugin.xml ^
      -DprojectDir="%pluginDir%" ^
      -DpluginPackagesDir="%~dp0resources\plugin-packages" ^
      -DpluginName="%pluginName%" ^
      -DpackageName="%packageName%" ^
      -DpackageDir="%packageDir%" ^
      -DbaseDir="%baseDir%" ^
      -Dversion="1.0.0" ^
      -Ddescription="%pluginName%" ^
      -Dvendor="VMware" ^
      -DserviceName="%serviceName%" ^
      -DserviceDir="%serviceDir%"


@CD %pluginDir%
@echo.
@echo Your plug-in package was created in %pluginDir%"

:end
@endlocal
