# Note: unless otherwise noted, changes in this file require a server restart or a new client session.

# To change the Help url reference, change the value to the required url.
# If you are deploying a Help package locally on the vSphere Web Client system, then provide a relative url.
# For example, if you deployed help.war, you would specify help.url=/help/
#help.url=http://techpubs.vmware.com/

# Flag to enable All Users' Tasks in the Recent tasks view (change takes effect immediately)
# It is only recommended for small to medium sized inventories and a limited number of concurrent users.
show.allusers.tasks = true

# Flags that enable the live refresh in different areas of the client.
live.updates.enabled = true
live.updates.alarms.enabled = true
live.updates.navtree.enabled = true
live.updates.lists.enabled = true
live.updates.objectstate.enabled = true

# To revert to the 6.0 behavior where all Related Objects are grouped under one
# tab please uncomment the following line:
#show.relations.in.categorized.tabs = false

# To load all overview performance charts at once uncomment the following line:
#delayed.performance.charts.loading = false

# Interval at which the client will send ping requests to the performance charts service.
# The value is in seconds. Default value: 300. Values below 180 will disable the ping.
# Removing this property will disable the ping.
performance.charts.keep.alive.period=0

# Web client session timeout in minutes, default is 120, i.e. 2 hours
session.timeout = 120

# This value configures the auto-refresh rate of the client, in seconds.  By default it is disabled (-1).
# Warning: auto-refresh prevents client sessions from expiring and can severely affect scalability with many clients!
refresh.rate = -1

# This value configures the auto-refresh rate of the Recent Tasks list when displaying all users' tasks, in seconds.
# Default is 60, value can be between 10 and 600 seconds, or use -1 to disable auto-refresh.
tasks.refresh.rate = 60

# This value configures the maximum number of tasks displayed in the Recent Tasks list.
# Count can between 1 and 100.  The default value is 50 if nothing is set.
tasks.display.count = 50

# This value configures the auto-refresh rate of the Alarms list. The default value is 60 seconds.
# Rate can between 10 and 600 seconds, or use -1 to disable auto-refresh.
alarms.refresh.rate = 60

# This value configures the maximum number of alarms displayed in the Alarms list.
# Count can between 1 and 100.  The default value is 30 if nothing is set.
alarms.display.count = 30

# Global flag to improve the responsiveness of the client, keep it false unless using small inventories.
# When set to true object counts are not displayed in the top inventory lists of the objects navigator
# and other optimizations reduce the load on Inventory Service.
large.inventory.mode = true

# Data Service timeout in seconds.  An error will be displayed in the UI if a data adapter is too slow to respond
# to a query and the logs will provide more details.
dataservice.timeoutSeconds = 120

# Data Service connection timeout in seconds
dataservice.connectionTimeoutSeconds = 10

# This flag controls the client-side data caching. It should remain enabled by default unless prompted by Support
# (cached values are kept for 60 seconds for up to 100 requests by default)
data.cache.enabled = true

# The URL to the my.vmware.com service
#myvmware.com.url = https://psb.vmware.com/services/downloadurl?baseProduct={0}&baseVersion={1}&installProduct={2}

# Use property html.console.port for the VM Console when the Web Client service uses a custom port
# 1) find out the port used by the Web Client service, a custom port is any port other than 9443 (the default)
# 2) open the firewall for that port:
# - on VCSA use this command: sudo iptables -A INPUT -p tcp --dport <CUSTOM_PORT> -j ACCEPT
# - on vCenter for Windows: open up the port for top traffic using firewall settings
#html.console.port = <CUSTOM_PORT>

# Disable sliding animation of the navigator pane.
navigator.disableAnimation = true

# Flag to enable faceted UI in list views, i.e. smart filters.
feature.facetedSearch.enabled = true

# When 'true' all portlets are collapsed by default in summary views to speed up the display.
portlets.collapsed = false

# permissions.mode specifies from where permission information is retrieved.
# Possible values are:
# auto: Uses either VC or AuthZ based on the object for which information is
#       requested. For objects managed by VC 5.1 or earlier the information is
#       taken directly from the VC. For objects managed by VC 6.0 or custom
#       objects - the info is taken from AuthZ
#
# legacy: Gets the permission info using VC as backend for any object managed by VC.
#         For other objects uses AuthZ.
#
# authz: Always use AuthZ as source of information regardless of whether the object
#        is being managed by VC or not.
#
# permissions.mode = auto

# Aggregation thresholds in the navigation tree for different objects like virtual machines, hosts, clusters, etc.
# If there are more objects than the threshold number the list is rolled up. Use 0 to disable aggregation.
aggregationThreshold.VirtualMachine = 5000
aggregationThreshold.HostSystem = 5000
aggregationThreshold.Datastore = 5000
aggregationThreshold.Network = 5000
aggregationThreshold.OpaqueNetwork = 5000
aggregationThreshold.DistributedVirtualPortgroup = 5000

# PagingThreshold in the navigation tree that controls the initial amount of retrieved children per type for
# a node in the tree. The rest of the children will be lazy loaded. For example: if "pagingThreshold=1000" then the
# first 1000 Host, VM, Resource Pool children of a Cluster will be retrieved when the Cluster is expanded,
# the children after the 1000th will be loaded on demand.
# pagingThreshold affects server time.
pagingThreshold = 2000

# The number of days before the notification about expiring password appears.
sso.pending.password.expiration.notification.days = 30

# Manifest Download has a default timeout of 5 hours.
# 5 * 60  = 300 min
manifest.Time = 300

# The SSO clock tolerance in seconds. This value is normally retrieved from the
# SSO server, but can be overridden by this property, if necessary.
#sso.clockTolerance=600

# The maximum amount of time the main login thread should wait for UserSessionListeners
# to finish. After that time, the login will proceed but will not cancel the
# UserSessionListeners that are still not finished. While there are unfinished
# UserSessionListeners, the vSphere Web Client might display indeterminate
# behavior.
# The value is in milliseconds. Default value: 120,000
#UserSessionListener.timeout=120000

# Flag to enable the use of a single TOC view for the configuration of inventory objects.
navigation.tabMode.convertSecondaryToToc=true
# A list of plug-ins which are not capable of supporting a single TOC view for their configuration.
navigation.tabMode.convertSecondaryToToc.excludedPlugins=com.vmware.srm.client,com.vmware.vShieldManager,com.vmware.vsphere.client.cmui,com.vmware.vum.client.updatemanagerui
# A list of plug-ins which are capable of supporting a single TOC view for their configuration. This list supports wildcards as sections of the ID.
# An entry in the list is not allowed to to begin with a wildcard symbol (*).
navigation.tabMode.convertSecondaryToToc.supportedPlugins=com.vmware.*.client.*

# Flag to enable the login of the user without permissions on any vCenter Server systems connected to the client.
# The user without permissions will login in the client and will see empty inventory.
#allow.user.without.permissions.login=true

# Indicates whether the logging of additional diagnostics is enabled for
# certain thread pool types which support additional diagnostics
threadPool.additionalDiagnostics.enabled=true

#Flag for enabling and disabling same origin check.
sameOrigin.check = true