/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.soaphandlers;

import com.vmware.sso.client.soaphandlers.SSOHeaderHandler;
import com.vmware.sso.client.utils.Utils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.TimestampType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimeStampHandler
extends SSOHeaderHandler {
    public static final String GMT = "GMT";

    public static DateFormat createDateFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(GMT));
        return simpleDateFormat;
    }

    private JAXBElement<TimestampType> createTimestamp() {
        ObjectFactory objectFactory = new ObjectFactory();
        TimestampType timestampType = objectFactory.createTimestampType();
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        Date date2 = new Date(l + TimeUnit.MINUTES.toMillis(10L));
        DateFormat dateFormat = TimeStampHandler.createDateFormatter();
        AttributedDateTime attributedDateTime = objectFactory.createAttributedDateTime();
        attributedDateTime.setValue(dateFormat.format(date));
        AttributedDateTime attributedDateTime2 = objectFactory.createAttributedDateTime();
        attributedDateTime2.setValue(dateFormat.format(date2));
        timestampType.setCreated(attributedDateTime);
        timestampType.setExpires(attributedDateTime2);
        return objectFactory.createTimestamp(timestampType);
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (Utils.isOutgoingMessage(sOAPMessageContext)) {
            try {
                Node node = Utils.getSecurityElement(Utils.getSOAPHeader(sOAPMessageContext));
                Element element = Utils.marshallJaxbElement(this.createTimestamp()).getDocumentElement();
                node.appendChild(node.getOwnerDocument().importNode(element, true));
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
                throw new RuntimeException(dOMException);
            }
            catch (SOAPException sOAPException) {
                sOAPException.printStackTrace();
                throw new RuntimeException(sOAPException);
            }
        }
        return true;
    }
}

