/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.soaphandlers;

import com.vmware.sso.client.soaphandlers.SSOHeaderHandler;
import com.vmware.sso.client.utils.Utils;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.AttributedString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.PasswordString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.UsernameTokenType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserCredentialHandler
extends SSOHeaderHandler {
    private final String userName;
    private final String passwd;

    public UserCredentialHandler(String string, String string2) {
        this.userName = string;
        this.passwd = string2;
    }

    private final JAXBElement<UsernameTokenType> createUsernameToken() {
        ObjectFactory objectFactory = new ObjectFactory();
        UsernameTokenType usernameTokenType = objectFactory.createUsernameTokenType();
        AttributedString attributedString = objectFactory.createAttributedString();
        attributedString.setValue(this.userName.toString());
        usernameTokenType.setUsername(attributedString);
        if (this.passwd != null) {
            PasswordString passwordString = objectFactory.createPasswordString();
            passwordString.setValue(this.passwd);
            usernameTokenType.setPassword(passwordString);
        }
        return objectFactory.createUsernameToken(usernameTokenType);
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (Utils.isOutgoingMessage(sOAPMessageContext)) {
            try {
                Node node = Utils.getSecurityElement(Utils.getSOAPHeader(sOAPMessageContext));
                Element element = Utils.marshallJaxbElement(this.createUsernameToken()).getDocumentElement();
                node.appendChild(node.getOwnerDocument().importNode(element, true));
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
                throw new RuntimeException(dOMException);
            }
            catch (SOAPException sOAPException) {
                sOAPException.printStackTrace();
                throw new RuntimeException(sOAPException);
            }
        }
        return true;
    }
}

