/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.io.Serializable;
import java.util.Arrays;
import javax.cim.CIMDataType;
import javax.cim.CIMElement;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import org.sblim.cimclient.internal.cim.CIMElementSorter;
import org.sblim.cimclient.internal.uri.BooleanValue;
import org.sblim.cimclient.internal.uri.CharValue;
import org.sblim.cimclient.internal.uri.DateTimeValue;
import org.sblim.cimclient.internal.uri.IntegerValue;
import org.sblim.cimclient.internal.uri.KeyValuePair;
import org.sblim.cimclient.internal.uri.KeyValuePairs;
import org.sblim.cimclient.internal.uri.RealValue;
import org.sblim.cimclient.internal.uri.ReferenceValue;
import org.sblim.cimclient.internal.uri.StringValue;
import org.sblim.cimclient.internal.uri.URI;
import org.sblim.cimclient.internal.uri.URIString;
import org.sblim.cimclient.internal.uri.Value;
import org.sblim.cimclient.internal.util.MOF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMObjectPath
implements Serializable {
    private static final long serialVersionUID = 4593259690658425064L;
    private String iScheme;
    private String iHost;
    private String iPort;
    private String iNamespace;
    private String iObjectName;
    private CIMProperty<?>[] iKeys;

    private CIMProperty<?>[] getKeysFromURI(URI pURI) {
        KeyValuePairs pairs = pURI.getKeyValuePairs();
        if (pairs == null) {
            return null;
        }
        CIMElement[] keys = new CIMProperty[pairs.size()];
        for (int i = 0; i < pairs.size(); ++i) {
            TypeValuePair typeValue;
            KeyValuePair pair = (KeyValuePair)pairs.elementAt(i);
            String name = pair.getKey();
            Value uriVal = pair.getValue();
            if (uriVal instanceof StringValue) {
                typeValue = new TypeValuePair(CIMDataType.STRING_T, uriVal.toString());
            } else if (uriVal instanceof ReferenceValue) {
                ReferenceValue refVal = (ReferenceValue)uriVal;
                CIMObjectPath op = new CIMObjectPath(refVal.getRef());
                typeValue = new TypeValuePair(new CIMDataType(op.getObjectName()), op);
            } else {
                typeValue = uriVal instanceof BooleanValue ? new TypeValuePair(CIMDataType.BOOLEAN_T, ((BooleanValue)uriVal).getBoolean()) : (uriVal instanceof CharValue ? new TypeValuePair(CIMDataType.CHAR16_T, ((CharValue)uriVal).getCharacter()) : (uriVal instanceof IntegerValue ? new TypeValuePair((IntegerValue)uriVal) : (uriVal instanceof RealValue ? new TypeValuePair((RealValue)uriVal) : (uriVal instanceof DateTimeValue ? new TypeValuePair(CIMDataType.DATETIME_T, ((DateTimeValue)uriVal).getDateTime()) : new TypeValuePair(CIMDataType.INVALID_T, null)))));
            }
            keys[i] = new CIMProperty<Object>(name, typeValue.getType(), typeValue.getValue(), true, false, null);
        }
        return (CIMProperty[])CIMElementSorter.sort(keys);
    }

    private void setURI(URI pURI) {
        this.iNamespace = pURI.getNamespaceName();
        this.iScheme = pURI.getNamespaceType();
        this.iHost = pURI.getHost();
        this.iPort = pURI.getPort();
        this.iObjectName = pURI.getClassName();
        this.iKeys = this.getKeysFromURI(pURI);
    }

    private CIMObjectPath(URI pURI) {
        this.setURI(pURI);
    }

    public CIMObjectPath(String pObjectPath) {
        URI uri;
        try {
            uri = URI.parse(pObjectPath);
        }
        catch (IllegalArgumentException asURI) {
            try {
                uri = URI.parseRef(new URIString(pObjectPath), false);
            }
            catch (IllegalArgumentException asUntypedRef) {
                try {
                    uri = URI.parseRef(new URIString(pObjectPath), true);
                }
                catch (IllegalArgumentException asTypedRef) {
                    String msg = "Parsing of ObjectPath string has failed!\nNested error messages:\nWhen parsing as normal URI string:\n" + asURI.getMessage() + "When parsing as untyped reference:\n" + asUntypedRef.getMessage() + "When parsing as typed reference:\n" + asTypedRef.getMessage();
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        this.setURI(uri);
    }

    public CIMObjectPath(String pElementName, String pNamespace) {
        this(pElementName, pNamespace, null);
    }

    public CIMObjectPath(String pObjectName, String pNamespace, CIMProperty<?>[] pKeys) {
        this(null, pNamespace, pObjectName, pKeys);
    }

    public CIMObjectPath(String pHost, String pNamespace, String pObjectName, CIMProperty<?>[] pKeys) {
        this(null, pHost, null, pNamespace, pObjectName, pKeys);
    }

    public CIMObjectPath(String pScheme, String pHost, String pPort, String pNamespace, String pObjectName, CIMProperty<?>[] pKeys) {
        this.iScheme = pScheme;
        this.iHost = pHost;
        this.iPort = pPort;
        this.iNamespace = pNamespace;
        this.iObjectName = pObjectName;
        this.iKeys = (CIMProperty[])CIMElementSorter.sort(pKeys);
    }

    public CIMObjectPath(String pScheme, String pHost, String pPort, String pNamespace, String pObjectName, CIMProperty<?>[] pKeys, String pXmlSchemaName) {
        this(pScheme, pHost, pPort, pNamespace, pObjectName, pKeys);
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof CIMObjectPath)) {
            return false;
        }
        CIMObjectPath that = (CIMObjectPath)pObj;
        return (this.iNamespace == null ? that.iNamespace == null : this.iNamespace.equalsIgnoreCase(that.iNamespace)) && (this.iObjectName == null ? that.iObjectName == null : this.iObjectName.equalsIgnoreCase(that.iObjectName)) && this.keysEqual(that);
    }

    private boolean keysEqual(CIMObjectPath pThat) {
        if (pThat == this) {
            return true;
        }
        if (this.iKeys == null) {
            return pThat.iKeys == null;
        }
        if (pThat.iKeys == null) {
            return false;
        }
        if (this.iKeys.length != pThat.iKeys.length) {
            return false;
        }
        for (int i = 0; i < this.iKeys.length; ++i) {
            CIMProperty<?> thisKey = this.iKeys[i];
            CIMProperty<?> thatKey = pThat.iKeys[i];
            if (this.equals(thisKey, thatKey)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(CIMProperty<?> pThis, CIMProperty<?> pThat) {
        if (pThis.getDataType() != null && pThis.getDataType().isArray()) {
            return this.ncEqualsIC(pThis.getName(), pThat.getName()) && this.ncEquals(pThis.getDataType(), pThat.getDataType()) && Arrays.equals((Object[])pThis.getValue(), (Object[])pThat.getValue());
        }
        return this.ncEqualsIC(pThis.getName(), pThat.getName()) && this.ncEquals(pThis.getDataType(), pThat.getDataType()) && this.ncEquals(pThis.getValue(), pThat.getValue());
    }

    private boolean ncEquals(Object pThis, Object pThat) {
        return pThis == null ? pThat == null : pThis.equals(pThat);
    }

    private boolean ncEqualsIC(String pThis, String pThat) {
        return pThis == null ? pThat == null : pThis.equalsIgnoreCase(pThat);
    }

    public boolean equalsModelPath(CIMObjectPath pModelPath) {
        return this.equals(pModelPath);
    }

    public String getHost() {
        return this.iHost;
    }

    public CIMProperty<?> getKey(String pName) {
        return (CIMProperty)CIMElementSorter.find(this.iKeys, pName);
    }

    public CIMProperty<?>[] getKeys() {
        return this.iKeys == null ? new CIMProperty[]{} : this.iKeys;
    }

    public String getNamespace() {
        return this.iNamespace;
    }

    public String getObjectName() {
        return this.iObjectName;
    }

    public String getPort() {
        return this.iPort;
    }

    public String getScheme() {
        return this.iScheme;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return MOF.objectHandle(this);
    }

    private static class TypeValuePair {
        private CIMDataType iType;
        private Object iValue;

        public TypeValuePair(CIMDataType pType, Object pValue) {
            this.iType = pType;
            this.iValue = pValue;
        }

        public TypeValuePair(IntegerValue intVal) {
            if (intVal.isSigned()) {
                switch (intVal.getBitWidth()) {
                    case 8: {
                        this.iType = CIMDataType.SINT8_T;
                        this.iValue = new Byte(intVal.byteValue());
                        break;
                    }
                    case 16: {
                        this.iType = CIMDataType.SINT16_T;
                        this.iValue = new Short(intVal.shortValue());
                        break;
                    }
                    case 32: {
                        this.iType = CIMDataType.SINT32_T;
                        this.iValue = new Integer(intVal.intValue());
                        break;
                    }
                    default: {
                        this.iType = CIMDataType.SINT64_T;
                        this.iValue = new Long(intVal.longValue());
                        break;
                    }
                }
            } else {
                switch (intVal.getBitWidth()) {
                    case 8: {
                        this.iType = CIMDataType.UINT8_T;
                        this.iValue = new UnsignedInteger8(intVal.shortValue());
                        break;
                    }
                    case 16: {
                        this.iType = CIMDataType.UINT16_T;
                        this.iValue = new UnsignedInteger16(intVal.intValue());
                        break;
                    }
                    case 32: {
                        this.iType = CIMDataType.UINT32_T;
                        this.iValue = new UnsignedInteger32(intVal.longValue());
                        break;
                    }
                    default: {
                        this.iType = CIMDataType.UINT64_T;
                        this.iValue = new UnsignedInteger64(intVal.bigIntValue());
                    }
                }
            }
        }

        public TypeValuePair(RealValue pRealVal) {
            if (pRealVal.isDouble()) {
                this.iType = CIMDataType.REAL64_T;
                this.iValue = new Double(pRealVal.doubleValue());
            } else {
                this.iType = CIMDataType.REAL32_T;
                this.iValue = new Float(pRealVal.floatValue());
            }
        }

        public CIMDataType getType() {
            return this.iType;
        }

        public Object getValue() {
            return this.iValue;
        }
    }
}

