/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import org.sblim.cimclient.internal.http.HttpContentHandler;
import org.sblim.cimclient.internal.http.HttpException;
import org.sblim.cimclient.internal.http.HttpHeader;
import org.sblim.cimclient.internal.http.HttpServerMethod;
import org.sblim.cimclient.internal.http.MessageReader;
import org.sblim.cimclient.internal.http.MessageWriter;
import org.sblim.cimclient.internal.http.io.ASCIIPrintStream;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class HttpConnectionHandler {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    HttpContentHandler iHandler;

    public HttpConnectionHandler(HttpContentHandler handler) {
        this.iHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = socket.getInputStream();
            os = socket.getOutputStream();
            while (true) {
                MessageWriter writer;
                MessageReader reader = new MessageReader(is);
                boolean persistent = reader.isPersistentConnectionSupported();
                persistent = false;
                boolean chunk = reader.isChunkSupported();
                HttpServerMethod readerMethod = reader.getMethod();
                if (readerMethod.getMethodName().equals("POST") || readerMethod.getMethodName().equals("M-POST")) {
                    writer = new MessageWriter(os, persistent, chunk);
                    try {
                        this.iHandler.handleContent(reader, writer, socket.getInetAddress());
                        writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 200, "OK"));
                    }
                    catch (HttpException e) {
                        writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), e.getStatus(), e.getMessage()));
                    }
                    catch (Throwable t) {
                        writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 501, "Not Implemented"));
                        writer.reset();
                        this.writeError(writer.getOutputStream(), "error", "error");
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing output stream from server socket", e);
                        }
                    }
                } else {
                    persistent = false;
                    writer = new MessageWriter(os, false, false);
                    HttpHeader header = new HttpHeader();
                    writer.setHeader(header);
                    writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 501, "Not Implemented"));
                    this.writeError(writer.getOutputStream(), "", "");
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing output stream from server socket", e);
                    }
                }
                if (persistent) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing input stream from server socket", e);
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while reading from server socket", e);
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing server socket", e);
        }
    }

    public void close() {
        this.iHandler.close();
    }

    private void writeError(ASCIIPrintStream dos, String title, String body) {
        dos.print("<HTTP> <HEAD> <TITLE>" + title + "</TITLE></HEAD><BODY>" + body + "</BODY></HTML>");
    }
}

