/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.uri;

import java.util.regex.Pattern;
import org.sblim.cimclient.internal.uri.Authority;
import org.sblim.cimclient.internal.uri.URIString;

public class NamespaceHandle {
    private Authority iAuth;
    private String iNsName;
    private static final String IDENTIFIER = "[A-Za-z][0-9A-Za-z\\._-]*";
    private static final Pattern NAMESPACENAME_PAT = Pattern.compile("^([A-Za-z][0-9A-Za-z\\._-]*(/[A-Za-z][0-9A-Za-z\\._-]*)*).*");

    public static NamespaceHandle parse(URIString pUriStr) {
        Authority auth;
        URIString uriStr = pUriStr.deepCopy();
        if (uriStr.cutStarting("//")) {
            auth = Authority.parse(uriStr);
            if (auth == null) {
                return null;
            }
        } else {
            auth = null;
        }
        if (!uriStr.cutStarting('/')) {
            return null;
        }
        String nsName = NamespaceHandle.parseNamespaceName(uriStr);
        pUriStr.set(uriStr);
        return new NamespaceHandle(auth, nsName);
    }

    private NamespaceHandle(Authority pAuth, String pNsName) {
        this.iAuth = pAuth;
        this.iNsName = pNsName;
    }

    public NamespaceHandle(String pNamespaceName) {
        this.iAuth = null;
        this.iNsName = pNamespaceName;
    }

    public String toString() {
        return (this.iAuth == null ? "" : "//" + this.iAuth.toString()) + "/" + (this.iNsName == null ? "" : this.iNsName);
    }

    public String getName() {
        return this.iNsName;
    }

    public String getUserInfo() {
        return this.iAuth == null ? null : this.iAuth.getUserInfo();
    }

    public String getHost() {
        return this.iAuth == null ? null : this.iAuth.getHost();
    }

    public String getPort() {
        return this.iAuth == null ? null : this.iAuth.getPort();
    }

    public static String parseNamespaceName(URIString pUriStr) {
        if (!pUriStr.matchAndCut(NAMESPACENAME_PAT, 1)) {
            return null;
        }
        return pUriStr.group(1);
    }
}

