/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.RoleCredential;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sblim.cimclient.WBEMClientSBLIM;
import org.sblim.cimclient.internal.cim.CIMHelper;
import org.sblim.cimclient.internal.cimxml.CIMClientXML_HelperImpl;
import org.sblim.cimclient.internal.cimxml.CIMMessage;
import org.sblim.cimclient.internal.cimxml.CIMResponse;
import org.sblim.cimclient.internal.cimxml.CIMXMLParseException;
import org.sblim.cimclient.internal.cimxml.CIMXMLParserImpl;
import org.sblim.cimclient.internal.cimxml.sax.SAXHelper;
import org.sblim.cimclient.internal.http.AuthorizationHandler;
import org.sblim.cimclient.internal.http.AuthorizationInfo;
import org.sblim.cimclient.internal.http.HttpClientPool;
import org.sblim.cimclient.internal.http.HttpHeader;
import org.sblim.cimclient.internal.http.HttpHeaderParser;
import org.sblim.cimclient.internal.http.HttpUrlConnection;
import org.sblim.cimclient.internal.http.io.DebugInputStream;
import org.sblim.cimclient.internal.http.io.TrailerException;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.MOF;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sblim.cimclient.internal.util.WBEMConstants;
import org.sblim.cimclient.internal.wbem.CloseableIteratorDOM;
import org.sblim.cimclient.internal.wbem.CloseableIteratorPULL;
import org.sblim.cimclient.internal.wbem.CloseableIteratorSAX;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBEMClientCIMXML
implements WBEMClientSBLIM {
    private final WBEMConfiguration iConfiguration = new WBEMConfiguration(new Properties());
    private Locale[] iLocales;
    private HttpClientPool iHttpClientPool;
    private URI iUri;
    private AuthorizationHandler iAuthorizationHandler;
    private CIMClientXML_HelperImpl iXmlHelper;
    private volatile String iAuthorization;
    private volatile int iNsCounter = 10;
    private volatile boolean iMPostFailed = false;
    private volatile long iMPostFailTime = 0L;
    private volatile long iCurrentTime = 0L;
    private volatile boolean iInitialized = false;
    private volatile boolean iClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialize(CIMObjectPath pName, Subject pSubject, Locale[] pLocales) throws IllegalArgumentException, WBEMException {
        if (this.iInitialized) {
            throw new IllegalStateException("WBEMClient is already initialized");
        }
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            String user;
            if (pName == null || pName.getHost() == null || pName.getHost().length() == 0) {
                throw new WBEMException(4, "Empty host path");
            }
            this.iHttpClientPool = new HttpClientPool(this.iConfiguration);
            this.iLocales = pLocales != null && pLocales.length > 0 ? pLocales : WBEMConstants.DEFAULT_LOCALES;
            try {
                this.iUri = CIMHelper.createCimomUri(pName);
            }
            catch (URISyntaxException e) {
                throw new WBEMException(4, "Malformed URI");
            }
            AuthorizationInfo authInfo = AuthorizationInfo.createAuthorizationInfo(this.iConfiguration.getHttpAuthenticationModule(), Boolean.FALSE, this.iUri.getHost(), this.iUri.getPort(), null, null, null);
            Principal principal = pSubject != null && pSubject.getPrincipals() != null && !pSubject.getPrincipals().isEmpty() ? pSubject.getPrincipals().iterator().next() : null;
            Object credential = pSubject != null && pSubject.getPrivateCredentials() != null && !pSubject.getPrivateCredentials().isEmpty() ? pSubject.getPrivateCredentials().iterator().next() : null;
            String string = user = principal != null ? principal.getName() : "";
            String password = credential != null && credential instanceof PasswordCredential ? new String(((PasswordCredential)credential).getUserPassword()) : (credential != null && credential instanceof RoleCredential ? new String(((RoleCredential)credential).getCredential()) : "");
            authInfo.setCredentials(new PasswordAuthentication(user, password.toCharArray()));
            this.iAuthorizationHandler = new AuthorizationHandler();
            this.iAuthorizationHandler.addAuthorizationInfo(authInfo);
            try {
                this.iXmlHelper = new CIMClientXML_HelperImpl();
            }
            catch (ParserConfigurationException e) {
                logger.trace(Level.FINE, "Exception while instantiating CIMClientXML_HelperImpl", e);
                logger.message("CIM3000S");
                throw new RuntimeException(e);
            }
            this.iInitialized = true;
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public Properties getProperties() {
        return this.iConfiguration.getDomainProperties();
    }

    @Override
    public String getProperty(String pKey) {
        return this.iConfiguration.getDomainProperty(pKey);
    }

    @Override
    public void setProperties(Properties pProperties) {
        this.iConfiguration.setDomainProperties(pProperties);
    }

    @Override
    public void setProperty(String pKey, String pValue) {
        this.iConfiguration.setDomainProperty(pKey, pValue);
    }

    @Override
    public CloseableIterator<CIMObjectPath> associatorNames(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass, String pRole, String pResultRole) throws WBEMException {
        String operation = "AssociatorNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.associatorNames_request(doc, pObjectName, pAssociationClass, pResultClass, pRole, pResultRole));
            InputStreamReader is = this.transmitRequest("AssociatorNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "AssociatorNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "AssociatorNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "AssociatorNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator associators(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "Associators";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.associators_request(doc, pObjectName, pAssociationClass, pResultClass, pRole, pResultRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("Associators", hh, doc);
            CloseableIterator closeableIterator = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "Associators request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "Associators request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "Associators request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            this.checkState();
            if (this.iHttpClientPool != null) {
                this.iHttpClientPool.closePool();
            }
        }
        finally {
            this.iClosed = true;
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClass(CIMClass pClass) throws WBEMException {
        String operation = "CreateClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pClass == null || pClass.getObjectPath() == null || pClass.getObjectPath().getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pClass.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.createClass_request(doc, pClass.getObjectPath(), pClass));
            InputStreamReader is = this.transmitRequest("CreateClass", hh, doc);
            CloseableIterator iter = this.getIterator(is, pClass.getObjectPath());
            try {
                iter.hasNext();
            }
            finally {
                iter.close();
            }
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "CreateClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "CreateClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "CreateClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMObjectPath createInstance(CIMInstance pInstance) throws WBEMException {
        String operation = "CreateInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pInstance == null || pInstance.getObjectPath() == null || pInstance.getObjectPath().getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pInstance.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.createInstance_request(doc, pInstance.getObjectPath(), pInstance));
            InputStreamReader is = this.transmitRequest("CreateInstance", hh, doc);
            CloseableIterator iter = this.getIterator(is, pInstance.getObjectPath());
            try {
                if (iter.hasNext()) {
                    CIMObjectPath cIMObjectPath = (CIMObjectPath)iter.next();
                    return cIMObjectPath;
                }
            }
            finally {
                iter.close();
            }
            CIMObjectPath cIMObjectPath = null;
            return cIMObjectPath;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "CreateInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "CreateInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "CreateInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClass(CIMObjectPath pPath) throws WBEMException {
        String operation = "DeleteClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteClass_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteClass", hh, doc);
            CloseableIterator iter = this.getIterator(is, pPath);
            try {
                iter.hasNext();
            }
            finally {
                iter.close();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "DeleteClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "DeleteClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "DeleteClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(CIMObjectPath pPath) throws WBEMException {
        String operation = "DeleteInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteInstance_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteInstance", hh, doc);
            CloseableIterator iter = this.getIterator(is, pPath);
            try {
                iter.hasNext();
            }
            finally {
                iter.close();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "DeleteInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "DeleteInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "DeleteInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQualifierType(CIMObjectPath pPath) throws WBEMException {
        String operation = "DeleteQualifierType";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteQualifierType_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteQualifierType", hh, doc);
            CloseableIterator iter = this.getIterator(is, pPath);
            try {
                iter.hasNext();
            }
            finally {
                iter.close();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "DeleteQualifierType request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "DeleteQualifierType request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "DeleteQualifierType request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMObjectPath> enumerateClassNames(CIMObjectPath pPath, boolean pDeep) throws WBEMException {
        String operation = "EnumerateClassNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pPath == null || pPath.getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateClassNames_request(doc, pPath, pDeep));
            InputStreamReader is = this.transmitRequest("EnumerateClassNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateClassNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateClassNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateClassNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMClass> enumerateClasses(CIMObjectPath pPath, boolean pDeep, boolean pPropagated, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws WBEMException {
        String operation = "EnumerateClasses";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMClass> iter;
            if (pPath == null || pPath.getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateClasses_request(doc, pPath, pDeep, pPropagated, pIncludeQualifiers, pIncludeClassOrigin));
            InputStreamReader is = this.transmitRequest("EnumerateClasses", hh, doc);
            CloseableIterator<CIMClass> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateClasses request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateClasses request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateClasses request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMObjectPath> enumerateInstanceNames(CIMObjectPath pPath) throws WBEMException {
        String operation = "EnumerateInstanceNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateInstanceNames_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("EnumerateInstanceNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateInstanceNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateInstanceNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateInstanceNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pPropagated, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "EnumerateInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMInstance> iter;
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateInstances_request(doc, pPath, pDeep, pPropagated, false, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("EnumerateInstances", hh, doc);
            CloseableIterator<CIMInstance> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(CIMObjectPath pPath) throws WBEMException {
        String operation = "EnumerateQualifiers";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMQualifierType<?>> iter;
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumQualifierTypes_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("EnumerateQualifiers", hh, doc);
            CloseableIterator<CIMQualifierType<?>> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateQualifiers request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateQualifiers request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateQualifiers request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath pPath, String pQuery, String pQueryLanguage) throws WBEMException {
        String operation = "ExecQuery";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMInstance> iter;
            if (pPath == null || pPath.getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.execQuery_request(doc, pPath, pQuery, pQueryLanguage));
            InputStreamReader is = this.transmitRequest("ExecQuery", hh, doc);
            CloseableIterator<CIMInstance> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ExecQuery request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ExecQuery request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ExecQuery request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMClass getClass(CIMObjectPath pName, boolean pPropagated, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "GetClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getClass_request(doc, pName, pPropagated, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("GetClass", hh, doc);
            CloseableIterator iter = this.getIterator(is, pName);
            try {
                if (iter.hasNext()) {
                    CIMClass cIMClass = (CIMClass)iter.next();
                    return cIMClass;
                }
            }
            finally {
                iter.close();
            }
            CIMClass cIMClass = null;
            return cIMClass;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "GetClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "GetClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "GetClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMInstance getInstance(CIMObjectPath pName, boolean pPropagated, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "GetInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getInstance_request(doc, pName, pPropagated, false, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("GetInstance", hh, doc);
            CloseableIterator iter = this.getIterator(is, pName);
            try {
                if (iter.hasNext()) {
                    CIMInstance result = (CIMInstance)iter.next();
                    CIMInstance cIMInstance = new CIMInstance(pName, result.getProperties());
                    return cIMInstance;
                }
            }
            finally {
                iter.close();
            }
            CIMInstance cIMInstance = null;
            return cIMInstance;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "GetInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "GetInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "GetInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMQualifierType<?> getQualifierType(CIMObjectPath pName) throws WBEMException {
        String operation = "GetQualifier";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getQualifier_request(doc, pName, pName.getObjectName()));
            InputStreamReader is = this.transmitRequest("GetQualifier", hh, doc);
            CloseableIterator iter = this.getIterator(is, pName);
            try {
                if (iter.hasNext()) {
                    CIMQualifierType cIMQualifierType = (CIMQualifierType)iter.next();
                    return cIMQualifierType;
                }
            }
            finally {
                iter.close();
            }
            CIMQualifierType<?> cIMQualifierType = null;
            return cIMQualifierType;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "GetQualifier request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "GetQualifier request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "GetQualifier request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public Object invokeMethod(CIMObjectPath pName, String pMethodName, CIMArgument<?>[] pInputArguments, CIMArgument<?>[] pOutputArguments) throws WBEMException {
        String operation = "InvokeMethod";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(MOF.objectHandle(pName, false, true), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.invokeMethod_request(doc, pName, pMethodName, pInputArguments));
            InputStreamReader is = this.transmitRequest(pMethodName, hh, doc);
            CIMResponse response = null;
            String parser = this.iConfiguration.getCimXmlParser();
            if ("SAX".equals(parser) || "PULL".equals(parser)) {
                Object object = SAXHelper.parseInvokeMethodResponse(is, pOutputArguments, null);
                return object;
            }
            response = this.getSingleResponse(is, null);
            response.checkError();
            List<Object> resultSet = response.getFirstReturnValue();
            Object rc = resultSet.size() > 0 ? resultSet.get(0) : null;
            List<Object> outParamValues = response.getParamValues();
            if (pOutputArguments != null && outParamValues != null) {
                Iterator<Object> itr = outParamValues.iterator();
                for (int i = 0; i < pOutputArguments.length && itr.hasNext(); ++i) {
                    pOutputArguments[i] = (CIMArgument)itr.next();
                }
            }
            Object object = rc;
            return object;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "InvokeMethod request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "InvokeMethod request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "InvokeMethod request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyClass(CIMClass pClass) throws WBEMException {
        String operation = "ModifyClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pClass == null || pClass.getObjectPath() == null || pClass.getObjectPath().getNamespace() == null || pClass.getObjectPath().getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pClass.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setClass_request(doc, pClass.getObjectPath(), pClass));
            InputStreamReader is = this.transmitRequest("ModifyClass", hh, doc);
            CloseableIterator iter = this.getIterator(is, pClass.getObjectPath());
            try {
                iter.hasNext();
            }
            finally {
                iter.close();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ModifyClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ModifyClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ModifyClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyInstance(CIMInstance pInst, String[] pPropertyList) throws WBEMException {
        String operation = "ModifyInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        if (pInst == null || pInst.getObjectPath() == null || pInst.getObjectPath().getNamespace() == null || pInst.getObjectPath().getObjectName() == null) {
            throw new WBEMException(4, "Invalid object path");
        }
        CIMObjectPath path = pInst.getObjectPath();
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(path.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setInstance_request(doc, path, pInst, true, pPropertyList));
            InputStreamReader is = this.transmitRequest("ModifyInstance", hh, doc);
            CloseableIterator iter = this.getIterator(is, path);
            try {
                iter.hasNext();
            }
            finally {
                iter.close();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ModifyInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ModifyInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ModifyInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMObjectPath> referenceNames(CIMObjectPath pObjectName, String pResultClass, String pRole) throws WBEMException {
        String operation = "ReferenceNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.referenceNames_request(doc, pObjectName, pResultClass, pRole));
            InputStreamReader is = this.transmitRequest("ReferenceNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ReferenceNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ReferenceNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ReferenceNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator references(CIMObjectPath pObjectName, String pResultClass, String pRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "References";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.references_request(doc, pObjectName, pResultClass, pRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("References", hh, doc);
            CloseableIterator closeableIterator = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "References request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "References request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "References request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public void setLocales(Locale[] pLocales) throws UnsupportedOperationException {
        this.iLocales = pLocales != null && pLocales.length > 0 ? pLocales : WBEMConstants.DEFAULT_LOCALES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQualifierType(CIMQualifierType<?> pQualifierType) throws WBEMException {
        String operation = "SetQualifierType";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pQualifierType == null || pQualifierType.getObjectPath() == null || pQualifierType.getObjectPath().getNamespace() == null || pQualifierType.getObjectPath().getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pQualifierType.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setQualifierType_request(doc, pQualifierType.getObjectPath(), pQualifierType));
            InputStreamReader is = this.transmitRequest("SetQualifierType", hh, doc);
            CloseableIterator iter = this.getIterator(is, pQualifierType.getObjectPath());
            try {
                iter.hasNext();
            }
            finally {
                iter.close();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "SetQualifierType request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "SetQualifierType request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "SetQualifierType request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public SocketFactory getCustomSocketFactory() {
        return this.iConfiguration.getCustomSocketFactory();
    }

    @Override
    public void setCustomSocketFactory(SocketFactory pFactory) throws UnsupportedOperationException {
        this.iConfiguration.setCustomSocketFactory(pFactory);
    }

    private InputStreamReader transmitRequest(String pCimMethod, HttpHeader pHeader, Document pDocument) throws IOException, ProtocolException, WBEMException {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        HttpUrlConnection connection = null;
        if (this.iMPostFailed) {
            this.iCurrentTime = System.currentTimeMillis();
            if (this.iCurrentTime - this.iMPostFailTime > 86400000L) {
                this.iMPostFailed = false;
            }
        }
        boolean useMPost = this.iMPostFailed ? false : this.iConfiguration.isHttpMPost();
        int retries = this.iConfiguration.getHttpConnectRetriesCount();
        block17: do {
            logger.trace(Level.FINE, "Attempting to connect.. number of attempts left:" + retries);
            if (connection != null) {
                connection.disconnect();
            }
            connection = this.newConnection(pCimMethod, pHeader, useMPost);
            try {
                logger.trace(Level.FINE, "Connecting...");
                connection.connect();
            }
            catch (UnknownHostException e) {
                throw new WBEMException(1, "Unknown host", null, e);
            }
            catch (SocketException e) {
                throw new WBEMException(1, "Unable to connect", null, e);
            }
            OutputStream os = connection.getOutputStream();
            if (this.iConfiguration.isCimXmlTracingEnabled()) {
                CIMClientXML_HelperImpl.dumpDocument(LogAndTraceBroker.getBroker().getXmlTraceStream(), pDocument);
            }
            CIMClientXML_HelperImpl.serialize(os, pDocument);
            os.flush();
            os.close();
            int resultCode = 200;
            try {
                resultCode = connection.getResponseCode();
            }
            catch (SocketException e) {
                connection.disconnect();
                throw new WBEMException(1, "Unable to connect", null, e);
            }
            catch (SocketTimeoutException e) {
                connection.disconnect();
                throw new WBEMException(1, "Connection timed out", null, e);
            }
            HttpHeader headers = this.parseHeaders(connection);
            String auth = connection.getRequestProperty("Authorization");
            if (auth != null) {
                this.iAuthorization = auth;
            }
            String cimError = headers.getField("CIMError");
            switch (resultCode) {
                case 200: {
                    int lengthToCheck;
                    int contentLength;
                    String contentLengthField;
                    if (this.iConfiguration.isHttpContentLengthRetryEnabled() && (contentLengthField = headers.getField("Content-length")) != null && contentLengthField.trim().length() > 0 && (contentLength = Integer.parseInt(contentLengthField)) < (lengthToCheck = this.iConfiguration.getHttpContentLengthThreshold())) {
                        logger.trace(Level.FINE, "Content Length below :" + lengthToCheck + " ...retrying !");
                        break;
                    }
                    String charset = this.getCharacterSet(headers);
                    InputStream is = connection.getInputStream();
                    OutputStream debugStream = LogAndTraceBroker.getBroker().getXmlTraceStream();
                    if (this.iConfiguration.isCimXmlTracingEnabled() && debugStream != null) {
                        is = new DebugInputStream(is, debugStream);
                    }
                    return new InputStreamReader(is, charset);
                }
                case 500: {
                    logger.trace(Level.FINER, "Received HTTP Error 500 - HTTP_INTERNAL_ERROR");
                    break;
                }
                case 501: {
                    String cimProtocolVersion = headers.getField("CIMProtocolVersion");
                    if (cimProtocolVersion == null && cimError == null && useMPost) {
                        logger.trace(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - falling back to HTTP POST");
                        this.iMPostFailTime = System.currentTimeMillis();
                        useMPost = false;
                        this.iMPostFailed = true;
                        ++retries;
                        break;
                    }
                    if (cimProtocolVersion == null || cimProtocolVersion.length() == 0) {
                        cimProtocolVersion = "1.0";
                    }
                    logger.trace(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED" + (cimError != null ? " - " + cimError : ""));
                    retries = 0;
                    break;
                }
                case 400: {
                    if (cimError != null) {
                        logger.trace(Level.FINER, "Received HTTP Error 400 - BAD REQUEST - " + cimError);
                    } else {
                        logger.trace(Level.FINER, "Received HTTP Error 400 - BAD REQUEST");
                    }
                    retries = 0;
                    break;
                }
                case 401: {
                    logger.trace(Level.FINER, "Received HTTP Error 401 - UNAUTHORIZED. Throwing WBEMAuthenticationException!");
                    connection.disconnect();
                    throw new WBEMException(2, "HTTP 401 - Unauthorized", null);
                }
                case 403: {
                    logger.trace(Level.FINER, "Received HTTP Error 403 - FORBIDDEN.");
                    retries = 0;
                    break;
                }
                case 407: {
                    logger.trace(Level.FINER, "Received HTTP Error 407 - ERR PROXY AUTHENTICATION. Throwing CIMAuthenticationException!");
                    connection.disconnect();
                    throw new WBEMException(2, "HTTP 407 - Err Proxy Authentication");
                }
                case 405: {
                    logger.trace(Level.FINER, "Received HTTP Error 405 - BAD METHOD.");
                    retries = 0;
                    break;
                }
                case 510: {
                    logger.trace(Level.FINER, "Received HTTP Error 510 on M-POST. Retrying with POST.");
                    if (!useMPost) continue block17;
                    this.iMPostFailTime = System.currentTimeMillis();
                    useMPost = false;
                    this.iMPostFailed = true;
                    ++retries;
                    break;
                }
                default: {
                    logger.trace(Level.FINER, "No known HTTP error recognized. Retrying with POST.");
                    this.iMPostFailTime = System.currentTimeMillis();
                    useMPost = false;
                    this.iMPostFailed = true;
                }
            }
        } while (retries-- > 0);
        String errorMsg = "HTTP " + connection.getResponseCode() + " - " + connection.getResponseMessage() + (connection.getHeaderField("CIMError") != null ? ", CIMError: " + connection.getHeaderField("CIMError") : "");
        connection.disconnect();
        throw new WBEMException(1, errorMsg);
    }

    private HttpUrlConnection newConnection(String pCimMethod, HttpHeader pHeader, boolean pUseMPost) {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        HttpUrlConnection connection = new HttpUrlConnection(this.iUri, this.iHttpClientPool, this.iAuthorizationHandler);
        if (pUseMPost) {
            connection.setRequestMethod("M-POST");
        } else {
            connection.setRequestMethod("POST");
        }
        connection.useHttp11("1.1".equals(this.iConfiguration.getHttpVersion()));
        String firstLocaleStr = this.iLocales[0].getLanguage();
        if (this.iLocales[0].getCountry().length() > 0) {
            firstLocaleStr = firstLocaleStr + '-' + this.iLocales[0].getCountry();
        }
        String restLocaleStr = "";
        for (int i = 1; i < this.iLocales.length; ++i) {
            if (this.iLocales[i] == null || this.iLocales[i].getLanguage().length() <= 0) continue;
            restLocaleStr = restLocaleStr + ", " + this.iLocales[i].getLanguage();
            if (this.iLocales[i].getCountry().length() <= 0) continue;
            restLocaleStr = restLocaleStr + '-' + this.iLocales[i].getCountry();
        }
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml; charset=\"utf-8\"");
        connection.setRequestProperty("Accept", "text/html, text/xml, application/xml");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Content-Language", firstLocaleStr);
        connection.setRequestProperty("Accept-Language", firstLocaleStr + restLocaleStr + ", *");
        if (this.iAuthorization != null) {
            connection.setRequestProperty("Authorization", this.iAuthorization);
        }
        String prefix = "";
        if (connection.getRequestMethod().equalsIgnoreCase("M-POST")) {
            String ns = this.getNextNs();
            connection.setRequestProperty("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + ns);
            prefix = ns + "-";
        }
        connection.setRequestProperty(prefix + "CIMProtocolVersion", "1.0");
        connection.setRequestProperty(prefix + "CIMOperation", "MethodCall");
        try {
            connection.setRequestProperty(prefix + "CIMMethod", HttpHeader.encode(pCimMethod, "UTF-8", "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            logger.trace(Level.FINE, "Exception while encoding http header", e);
            connection.setRequestProperty(prefix + "CIMMethod", pCimMethod);
        }
        Iterator<Map.Entry<HttpHeader.HeaderEntry, String>> iter = pHeader.iterator();
        while (iter.hasNext()) {
            Map.Entry<HttpHeader.HeaderEntry, String> entry = iter.next();
            connection.setRequestProperty(prefix + entry.getKey().toString(), entry.getValue().toString());
        }
        logger.exit();
        return connection;
    }

    private String getNextNs() {
        this.iNsCounter = this.iNsCounter < 99 ? (this.iNsCounter = this.iNsCounter + 1) : 10;
        return String.valueOf(this.iNsCounter);
    }

    private HttpHeader parseHeaders(URLConnection pConnection) {
        String man = pConnection.getHeaderField("Man");
        String opt = pConnection.getHeaderField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.getValue("ns");
        }
        if (ns != null) {
            String key;
            int i = 0;
            while ((key = pConnection.getHeaderFieldKey(++i)) != null) {
                if (key.startsWith(ns + "-")) {
                    headers.addField(key.substring(3), pConnection.getHeaderField(i));
                    continue;
                }
                headers.addField(key, pConnection.getHeaderField(i));
            }
        } else {
            String key;
            int i = 0;
            while ((key = pConnection.getHeaderFieldKey(++i)) != null) {
                headers.addField(key, pConnection.getHeaderField(i));
            }
        }
        return headers;
    }

    private String getCharacterSet(HttpHeader pHeader) {
        String contentType = pHeader.getField("Content-type");
        String charset = "UTF-8";
        if (contentType != null && contentType.length() > 0) {
            HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
            charset = contentTypeHeader.getValue("charset", charset);
        }
        return charset;
    }

    private <T> CloseableIterator<T> getIterator(InputStreamReader pStream, CIMObjectPath pPath) throws IOException, SAXException, ParserConfigurationException, WBEMException {
        String parser = this.iConfiguration.getCimXmlParser();
        CloseableIterator<Object> iter = null;
        if ("SAX".equals(parser)) {
            iter = new CloseableIteratorSAX(pStream, pPath);
        } else if ("PULL".equals(parser)) {
            iter = new CloseableIteratorPULL(pStream, pPath);
        } else if ("DOM".equals(parser)) {
            iter = new CloseableIteratorDOM(pStream, pPath);
        } else {
            throw new IllegalArgumentException("Invalid CIM-XML parser configured (\"" + parser + "\") ");
        }
        try {
            iter.hasNext();
            return iter;
        }
        catch (RuntimeException e) {
            iter.close();
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw e;
        }
    }

    private CIMResponse getSingleResponse(InputStreamReader pStream, CIMObjectPath pLocalPath) throws WBEMException {
        CIMMessage cimMsg;
        Document dom;
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(new InputSource(pStream));
        }
        catch (TrailerException e) {
            throw e.getWBEMException();
        }
        catch (Exception e) {
            String msg = "Exception occurred during DOM parsing!";
            logger.trace(Level.SEVERE, msg, e);
            throw new WBEMException(1, msg, null, e);
        }
        CIMXMLParserImpl.setLocalObjectPath(pLocalPath);
        try {
            cimMsg = CIMXMLParserImpl.parseCIM(dom.getDocumentElement());
        }
        catch (CIMXMLParseException e) {
            String msg = "Exception occurred during parseCIM!";
            logger.trace(Level.SEVERE, msg, e);
            throw new WBEMException(1, msg, null, e);
        }
        if (!(cimMsg instanceof CIMResponse)) {
            String msg = "CIM message must be response!";
            logger.trace(Level.SEVERE, msg);
            throw new WBEMException(msg);
        }
        return (CIMResponse)cimMsg;
    }

    @Override
    public Properties getLocalProperties() {
        return this.iConfiguration.getLocalProperties();
    }

    @Override
    public void setLocalProperties(Properties pProperties) {
        this.iConfiguration.setLocalProperties(pProperties);
    }

    @Override
    public void setLocalProperty(String pKey, String pValue) {
        this.iConfiguration.setLocalProperty(pKey, pValue);
    }

    private synchronized void checkState() throws IllegalStateException {
        if (this.iInitialized && !this.iClosed) {
            return;
        }
        String state = this.iClosed ? "closed." : "not initialized.";
        LogAndTraceBroker.getBroker().trace(Level.FINE, "Illegal state for operation: " + state);
        throw new IllegalStateException("WBEMClient is " + state);
    }
}

