/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.slp.internal.SLPConfig;

public class TRC {
    private static PrintStream cOut;
    private static Level cLevel;
    private static LogAndTraceBroker cLogger;
    private static Pattern[] cDenyPatterns;
    private static Pattern[] cAllowPatterns;
    private static final String NAME;

    public static void setLevel(Level pLevel) {
        cLevel = pLevel;
    }

    public static void setOutput(OutputStream pOutStr) {
        TRC.setOutput(new PrintStream(pOutStr));
    }

    public static void setOutput(PrintStream pOutStr) {
        cOut = pOutStr;
    }

    public static void setPatterns(String[] pDenyPatterns, String[] pAllowPatterns) {
        cDenyPatterns = TRC.compile(pDenyPatterns);
        cAllowPatterns = TRC.compile(pAllowPatterns);
    }

    private static Pattern[] compile(String[] pStrs) {
        if (pStrs == null) {
            return null;
        }
        Pattern[] patterns = new Pattern[pStrs.length];
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = Pattern.compile(pStrs[i]);
        }
        return patterns;
    }

    public static void debug(String pMsg) {
        TRC.debug(pMsg, null);
    }

    public static void debug(String pMsg, Exception pEx) {
        if (cLevel.intValue() > Level.FINEST.intValue()) {
            return;
        }
        TRC.trace(Level.FINEST, pMsg, pEx);
    }

    public static void info(String pMsg) {
        TRC.info(pMsg, null);
    }

    public static void info(String pMsg, Exception pEx) {
        if (cLevel.intValue() > Level.INFO.intValue()) {
            return;
        }
        TRC.trace(Level.INFO, pMsg, pEx);
    }

    public static void warning(String pMsg) {
        TRC.warning(pMsg, null);
    }

    public static void warning(String pMsg, Exception pEx) {
        if (cLevel.intValue() > Level.WARNING.intValue()) {
            return;
        }
        TRC.trace(Level.WARNING, pMsg, pEx);
    }

    public static void error(String pMsg) {
        TRC.error(pMsg, null);
    }

    public static void error(Exception pEx) {
        TRC.error(null, pEx);
    }

    public static void error(String pMsg, Exception pEx) {
        if (cLevel.intValue() > Level.SEVERE.intValue()) {
            return;
        }
        TRC.trace(Level.SEVERE, pMsg, pEx);
    }

    private static boolean hasMatch(Pattern[] pPatterns, String pStr) {
        if (pPatterns == null) {
            return false;
        }
        for (int i = 0; i < pPatterns.length; ++i) {
            Pattern pattern = pPatterns[i];
            Matcher m = pattern.matcher(pStr);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean deny(String pFnStr) {
        return TRC.hasMatch(cDenyPatterns, pFnStr);
    }

    private static boolean allow(String pFnStr) {
        return TRC.hasMatch(cAllowPatterns, pFnStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(Level pLevel, String pMsg, Exception pEx) {
        StackTraceElement location;
        String fnStr;
        if (cLogger == null) {
            cLogger = LogAndTraceBroker.getBroker();
        }
        if (TRC.deny(fnStr = TRC.getFunctionStr(location = TRC.getLocation())) && !TRC.allow(fnStr)) {
            return;
        }
        StringBuffer buf = new StringBuffer('[' + pLevel.toString() + ' ' + Thread.currentThread().getName() + ' ' + TRC.getDate() + ' ' + TRC.getLocationStr(location) + "]\n");
        if (pMsg != null) {
            buf.append(pMsg + '\n');
        }
        if (pEx != null) {
            StringWriter writer = new StringWriter();
            pEx.printStackTrace(new PrintWriter(writer));
            buf.append(writer.toString() + '\n');
        }
        Class<TRC> clazz = TRC.class;
        synchronized (TRC.class) {
            if (cOut != null) {
                cOut.println(buf.toString());
                System.out.flush();
            } else {
                cLogger.trace(pLevel, buf.toString());
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private static StackTraceElement getLocation() {
        Throwable thr = new Throwable();
        StackTraceElement[] elements = thr.getStackTrace();
        StackTraceElement e = null;
        for (int i = 0; i < elements.length; ++i) {
            e = elements[i];
            if (e.getClassName().equals(NAME)) continue;
            return e;
        }
        return null;
    }

    private static String getFunctionStr(StackTraceElement pSTE) {
        return pSTE.getClassName() + '.' + pSTE.getMethodName();
    }

    private static String getLocationStr(StackTraceElement pSTE) {
        return TRC.getFunctionStr(pSTE) + '(' + pSTE.getFileName() + ':' + pSTE.getLineNumber() + ')';
    }

    private static String pad(int pDigits, int pNum) {
        String str = Integer.toString(pNum);
        int len = Math.max(pDigits, str.length());
        char[] cA = new char[len];
        int paddingDigits = pDigits - str.length();
        int dIdx = 0;
        while (dIdx < paddingDigits) {
            cA[dIdx++] = 48;
        }
        int sIdx = 0;
        while (dIdx < len) {
            cA[dIdx++] = str.charAt(sIdx++);
        }
        return new String(cA);
    }

    private static String getDate() {
        long millis = new Date().getTime();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return Integer.toString(cal.get(1)) + '.' + TRC.pad(2, cal.get(2) + 1) + '.' + TRC.pad(2, cal.get(5)) + ' ' + TRC.pad(2, cal.get(11)) + ':' + TRC.pad(2, cal.get(12)) + ':' + TRC.pad(2, cal.get(13)) + ' ' + TRC.pad(3, cal.get(14));
    }

    static {
        cLevel = SLPConfig.getGlobalCfg().getTraceLevel();
        NAME = new TRC().getClass().getName();
    }
}

