/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.ServiceURL;
import org.sblim.slp.internal.msg.MsgHeader;
import org.sblim.slp.internal.msg.ReplyMessage;
import org.sblim.slp.internal.msg.SLPInputStream;
import org.sblim.slp.internal.msg.SLPMessage;
import org.sblim.slp.internal.msg.SLPOutputStream;
import org.sblim.slp.internal.msg.SerializeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReply
extends ReplyMessage {
    private List<ServiceURL> iURLEntries;
    private List<Exception> iURLExceptions;

    public static SLPMessage parse(MsgHeader pHdr, SLPInputStream pInStr) throws ServiceLocationException, IOException {
        int errorCode = pInStr.read16();
        ArrayList<Exception> urlExceptions = new ArrayList<Exception>();
        List<ServiceURL> urlEntries = pInStr.readUrlList(urlExceptions);
        return new ServiceReply(pHdr, errorCode, urlEntries, urlExceptions);
    }

    public ServiceReply(int pErrorCode, List<ServiceURL> pURLEntries) {
        super(2, pErrorCode);
        this.iURLEntries = pURLEntries;
    }

    public ServiceReply(String pLangTag, int pErrorCode, List<ServiceURL> pURLEntries, List<Exception> pURLExceptions) {
        super(2, pLangTag, pErrorCode);
        this.iURLEntries = pURLEntries;
        this.iURLExceptions = pURLExceptions;
    }

    public ServiceReply(MsgHeader pHeader, int pErrorCode, List<ServiceURL> pURLEntries, List<Exception> pURLExceptions) {
        super(pHeader, pErrorCode);
        this.iURLEntries = pURLEntries;
        this.iURLExceptions = pURLExceptions;
    }

    public Iterator<ServiceURL> getResultIterator() {
        return this.iURLEntries == null ? null : this.iURLEntries.iterator();
    }

    public Iterator<Exception> getExceptionIterator() {
        return this.iURLExceptions == null ? null : this.iURLExceptions.iterator();
    }

    public List<ServiceURL> getURLEntries() {
        return this.iURLEntries;
    }

    public List<Exception> getURLExceptions() {
        return this.iURLExceptions;
    }

    @Override
    protected boolean serializeBody(SLPOutputStream pOutStr, SerializeOption pOption) {
        return pOutStr.write16(this.getErrorCode()) && pOutStr.writeURLList(this.iURLEntries);
    }
}

