/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.registry;

public class SampleExecutionRecord {
    public static final SampleExecutionRecord NULL_RECORD = new SampleExecutionRecord(null);
    final Object sample;
    InvocationRecord before = InvocationRecord.NULL_RECORD;
    InvocationRecord action = InvocationRecord.NULL_RECORD;
    InvocationRecord after = InvocationRecord.NULL_RECORD;
    Boolean ran = Boolean.FALSE;

    public SampleExecutionRecord(Object sample) {
        this.sample = sample;
    }

    public boolean isGood() {
        return this.ran != false && this.before.isGood() && this.action.isGood() && this.after.isGood();
    }

    public Object getSample() {
        return this.sample;
    }

    public InvocationRecord getBefore() {
        return this.before;
    }

    public InvocationRecord getAction() {
        return this.action;
    }

    public InvocationRecord getAfter() {
        return this.after;
    }

    SampleExecutionRecord hasRun() {
        this.ran = Boolean.TRUE;
        return this;
    }

    public boolean hasFault() {
        return this.ran != false && (this.before.hasFault() || this.action.hasFault() || this.after.hasFault());
    }

    public Throwable getFault() {
        InvocationRecord record;
        Throwable fault = null;
        InvocationRecord[] arr$ = new InvocationRecord[]{this.before, this.action, this.after};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fault = (record = arr$[i$]).getFault()) == null; ++i$) {
        }
        return fault;
    }

    public static class InvocationRecord {
        Object output;
        Throwable fault;
        public static final InvocationRecord NULL_RECORD = new InvocationRecord(){

            @Override
            public boolean isGood() {
                return true;
            }
        };

        public Object getOutput() {
            return this.output;
        }

        public Throwable getFault() {
            return this.fault;
        }

        public boolean isGood() {
            return this.fault == null;
        }

        public boolean hasFault() {
            return this.fault != null;
        }
    }
}

