/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.samples;

import com.rsa.names._2009._12.product.riat.wsdl.STSService;
import com.rsa.names._2009._12.product.riat.wsdl.STSServicePortType;
import com.vmware.sso.client.samples.AcquireHoKTokenByUserCredentialSample;
import com.vmware.sso.client.soaphandlers.HeaderHandlerResolver;
import com.vmware.sso.client.soaphandlers.SamlTokenExtractionHandler;
import com.vmware.sso.client.soaphandlers.TimeStampHandler;
import com.vmware.sso.client.soaphandlers.WsSecurityUserCertificateSignatureHandler;
import com.vmware.sso.client.utils.SecurityUtil;
import com.vmware.sso.client.utils.Utils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import org.oasis_open.docs.ws_sx.ws_trust._200512.LifetimeType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RenewTargetType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.w3c.dom.Element;

public class RenewTokenSample {
    public static Element renewToken(String string, Element element, PrivateKey privateKey, X509Certificate x509Certificate, long l) throws DatatypeConfigurationException {
        STSService sTSService = new STSService();
        HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
        headerHandlerResolver.addHandler(new TimeStampHandler());
        WsSecurityUserCertificateSignatureHandler wsSecurityUserCertificateSignatureHandler = new WsSecurityUserCertificateSignatureHandler(privateKey, x509Certificate);
        headerHandlerResolver.addHandler(wsSecurityUserCertificateSignatureHandler);
        SamlTokenExtractionHandler samlTokenExtractionHandler = new SamlTokenExtractionHandler();
        headerHandlerResolver.addHandler(samlTokenExtractionHandler);
        sTSService.setHandlerResolver((HandlerResolver)headerHandlerResolver);
        STSServicePortType sTSServicePortType = sTSService.getSTSServicePort();
        RequestSecurityTokenType requestSecurityTokenType = new RequestSecurityTokenType();
        LifetimeType lifetimeType = new LifetimeType();
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
        AttributedDateTime attributedDateTime = new AttributedDateTime();
        attributedDateTime.setValue(xMLGregorianCalendar.toXMLFormat());
        AttributedDateTime attributedDateTime2 = new AttributedDateTime();
        xMLGregorianCalendar.add(datatypeFactory.newDuration(l * 1000L));
        attributedDateTime2.setValue(xMLGregorianCalendar.toXMLFormat());
        lifetimeType.setCreated(attributedDateTime);
        lifetimeType.setExpires(attributedDateTime2);
        requestSecurityTokenType.setLifetime(lifetimeType);
        requestSecurityTokenType.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
        requestSecurityTokenType.setRequestType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew");
        RenewTargetType renewTargetType = new RenewTargetType();
        renewTargetType.setAny(element);
        requestSecurityTokenType.setRenewTarget(renewTargetType);
        Map map = ((BindingProvider)sTSServicePortType).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string);
        sTSServicePortType.renew(requestSecurityTokenType);
        return samlTokenExtractionHandler.getToken();
    }

    private static void printUsage() {
        System.out.println("run.bat com.vmware.sso.client.samples.RenewTokenSample [sso url] [username] [password] [durationInSeconds]");
    }

    public static void main(String[] stringArray) throws DatatypeConfigurationException, InterruptedException {
        if (stringArray.length < 4) {
            RenewTokenSample.printUsage();
            return;
        }
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        Utils.trustAllHttpsCertificates();
        System.out.println("Aquiring a HoK token by using another HoK token acquired using user credentials");
        System.out.println("Inital token acquired using AcquireHoKTokenByUserCredentialSample sample");
        SecurityUtil securityUtil = SecurityUtil.loadFromDefaultFiles();
        Element element = AcquireHoKTokenByUserCredentialSample.getToken(stringArray, securityUtil.getPrivateKey(), securityUtil.getUserCert());
        System.out.println("*****Original token issued*****");
        Utils.printToken(element);
        Thread.sleep(5000L);
        System.out.println("Renewing the token");
        System.out.println("*****Renewed token*****");
        Utils.printToken(RenewTokenSample.renewToken(stringArray[0], element, securityUtil.getPrivateKey(), securityUtil.getUserCert(), Long.parseLong(stringArray[3])));
    }
}

