/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.alarms;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AlarmAction;
import com.vmware.vim25.AlarmExpression;
import com.vmware.vim25.AlarmSpec;
import com.vmware.vim25.AlarmTriggeringAction;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MethodAction;
import com.vmware.vim25.MethodActionArgument;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.StateAlarmExpression;
import com.vmware.vim25.StateAlarmOperator;
import java.util.Arrays;

@Sample(name="vm-power-state-alarm", description="This sample which creates an Alarm to monitor the virtual machine's power state")
public class VMPowerStateAlarm
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private ManagedObjectReference alarmManager;
    private ManagedObjectReference vmMor;
    private String alarm = null;
    private String vmname = null;

    @Option(name="vmname", description="name of the virtual machine to monitor")
    public void setVmname(String string) {
        this.vmname = string;
    }

    @Option(name="alarm", description="Name of the alarms")
    public void setAlarm(String string) {
        this.alarm = string;
    }

    StateAlarmExpression createStateAlarmExpression() {
        StateAlarmExpression stateAlarmExpression = new StateAlarmExpression();
        stateAlarmExpression.setType("VirtualMachine");
        stateAlarmExpression.setStatePath("runtime.powerState");
        stateAlarmExpression.setOperator(StateAlarmOperator.IS_EQUAL);
        stateAlarmExpression.setRed("poweredOff");
        return stateAlarmExpression;
    }

    MethodAction createPowerOnAction() {
        MethodAction methodAction = new MethodAction();
        methodAction.setName("PowerOnVM_Task");
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.setValue(null);
        methodAction.getArgument().addAll(Arrays.asList(methodActionArgument));
        return methodAction;
    }

    AlarmTriggeringAction createAlarmTriggerAction(MethodAction methodAction) {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        alarmTriggeringAction.setYellow2Red(true);
        alarmTriggeringAction.setAction((com.vmware.vim25.Action)methodAction);
        return alarmTriggeringAction;
    }

    AlarmSpec createAlarmSpec(AlarmAction alarmAction, AlarmExpression alarmExpression) {
        AlarmSpec alarmSpec = new AlarmSpec();
        alarmSpec.setAction(alarmAction);
        alarmSpec.setExpression(alarmExpression);
        alarmSpec.setName(this.alarm);
        alarmSpec.setDescription("Monitor VM state and send email if VM power's off");
        alarmSpec.setEnabled(true);
        return alarmSpec;
    }

    void createAlarm(AlarmSpec alarmSpec) throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidNameFaultMsg {
        ManagedObjectReference managedObjectReference = this.vimPort.createAlarm(this.alarmManager, this.vmMor, alarmSpec);
        System.out.println("Successfully created Alarm: " + managedObjectReference.getValue());
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DuplicateNameFaultMsg, InvalidNameFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.alarmManager = this.serviceContent.getAlarmManager();
        this.vmMor = this.getMOREFs.vmByVMname(this.vmname, this.propCollectorRef);
        if (this.vmMor != null) {
            StateAlarmExpression stateAlarmExpression = this.createStateAlarmExpression();
            MethodAction methodAction = this.createPowerOnAction();
            AlarmTriggeringAction alarmTriggeringAction = this.createAlarmTriggerAction(methodAction);
            AlarmSpec alarmSpec = this.createAlarmSpec((AlarmAction)alarmTriggeringAction, (AlarmExpression)stateAlarmExpression);
            this.createAlarm(alarmSpec);
        } else {
            System.out.println("Virtual Machine " + this.vmname + " Not Found");
        }
    }
}

