/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.KeyAnyValue;
import com.vmware.vim25.KeyValue;
import com.vmware.vim25.LicenseAssignmentManagerLicenseAssignment;
import com.vmware.vim25.LicenseEntityNotFoundFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Sample(name="license-manager", description="Demonstrates uses of the Licensing API")
public class LicenseManager
extends ConnectedVimServiceBase {
    String action = null;
    String feature = null;
    String licenseKey = null;
    private ManagedObjectReference licManagerRef = null;
    private ManagedObjectReference licenseAssignmentManagerRef = null;
    private List<LicenseAssignmentManagerLicenseAssignment> licenses;

    @Option(name="action", description="action to be performed: [browse|setserver|featureinfo]")
    public void setAction(String string) {
        this.action = string;
    }

    @Option(name="feature", required=false, description="licensed feature")
    public void setFeature(String string) {
        this.feature = string;
    }

    @Option(name="licensekey", required=false, description="License key for KL servers")
    public void setLicenseKey(String string) {
        this.licenseKey = string;
    }

    public void initLicManagerRef() {
        if (this.serviceContent != null) {
            this.licManagerRef = this.serviceContent.getLicenseManager();
        }
    }

    public void initLicAssignmentManagerRef() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.licenseAssignmentManagerRef = (ManagedObjectReference)this.getMOREFs.entityProps(this.licManagerRef, new String[]{"licenseAssignmentManager"}).get("licenseAssignmentManager");
    }

    public void initLicenseAssignmentManagerLicenseAssignments() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.licenses = this.vimPort.queryAssignedLicenses(this.licenseAssignmentManagerRef, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void useLicenseManager() throws RuntimeFaultFaultMsg, LicenseEntityNotFoundFaultMsg {
        if (this.action.equalsIgnoreCase("browse")) {
            System.out.println("Display the license usage. It gives details of license features like license key  edition key and entity id.");
            this.displayLicenseUsage();
            return;
        } else if (this.action.equalsIgnoreCase("setkey")) {
            System.out.println("Set the license key.");
            this.setLicKey();
            return;
        } else if (this.action.equalsIgnoreCase("featureinfo")) {
            if (this.feature == null) throw new IllegalArgumentException("Expected --feature argument.");
            this.displayFeatureInfo();
            return;
        } else {
            System.out.println("Invalid Action ");
            System.out.println("Valid Actions [browse|setserver|featureinfo]");
        }
    }

    public void displayLicenseUsage() throws RuntimeFaultFaultMsg {
        this.print(this.licenses);
    }

    public void setLicKey() throws RuntimeFaultFaultMsg, LicenseEntityNotFoundFaultMsg {
        boolean bl = true;
        if (this.licenseKey == null) {
            System.out.println("Error:: For KL servers licensekey is a mandatory option");
            bl = false;
        }
        if (bl) {
            String string = this.serviceContent.getAbout().getApiType();
            if (string.equalsIgnoreCase("VirtualCenter")) {
                String string2 = this.serviceContent.getAbout().getInstanceUuid();
                this.vimPort.updateAssignedLicense(this.licenseAssignmentManagerRef, string2, this.licenseKey, null);
                System.out.println("License key set for VC server");
            } else if (string.equalsIgnoreCase("HostAgent")) {
                this.vimPort.decodeLicense(this.licManagerRef, this.licenseKey);
                this.vimPort.updateLicense(this.licManagerRef, this.licenseKey, null);
                System.out.println("License key set for ESX server");
            }
        }
    }

    public void displayFeatureInfo() {
        List<KeyValue> list;
        String string = this.feature;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        for (Object object : this.licenses) {
            if (object.getAssignedLicense() == null || object.getAssignedLicense().getProperties() == null) continue;
            list = new ArrayList();
            for (KeyAnyValue keyAnyValue : object.getAssignedLicense().getProperties()) {
                KeyValue keyValue;
                if (!keyAnyValue.getKey().equalsIgnoreCase("feature") || (keyValue = (KeyValue)keyAnyValue.getValue()) == null) continue;
                if (keyValue.getKey().equalsIgnoreCase(string)) {
                    bl = true;
                    System.out.println("Entity Name: " + object.getEntityDisplayName());
                    System.out.println("License Name: " + object.getAssignedLicense().getName());
                    System.out.println("Feature Name: " + keyValue.getKey());
                    System.out.println("Description: " + keyValue.getValue());
                }
                list.add(keyValue);
            }
            hashMap.put(object.getAssignedLicense().getName(), list);
        }
        if (!bl) {
            System.out.println("Could not find feature " + string);
            if (hashMap.keySet().size() > 0) {
                System.out.println("Available features are: ");
                for (Object object : hashMap.keySet()) {
                    list = (List)hashMap.get(object);
                    for (KeyValue keyValue : list) {
                        System.out.println(keyValue.getKey() + " : " + keyValue.getValue());
                    }
                }
            }
        }
    }

    public void print(List<LicenseAssignmentManagerLicenseAssignment> list) {
        if (list != null) {
            for (LicenseAssignmentManagerLicenseAssignment licenseAssignmentManagerLicenseAssignment : list) {
                String string = licenseAssignmentManagerLicenseAssignment.getEntityId();
                String string2 = licenseAssignmentManagerLicenseAssignment.getAssignedLicense().getEditionKey();
                String string3 = licenseAssignmentManagerLicenseAssignment.getAssignedLicense().getLicenseKey();
                String string4 = licenseAssignmentManagerLicenseAssignment.getAssignedLicense().getName();
                System.out.println("\nName of the license: " + string4 + "\n License Key:  " + string3 + "\n Edition Key: " + string2 + "\n EntityID: " + string + "\n\n");
            }
        }
    }

    @Action
    public void action() throws RuntimeFaultFaultMsg, LicenseEntityNotFoundFaultMsg, InvalidPropertyFaultMsg {
        this.initLicManagerRef();
        this.initLicAssignmentManagerRef();
        this.initLicenseAssignmentManagerLicenseAssignments();
        this.useLicenseManager();
    }
}

