/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.HostConfigFaultFaultMsg;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.HostIpConfig;
import com.vmware.vim25.HostPortGroupSpec;
import com.vmware.vim25.HostVirtualNicSpec;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.lang.reflect.InvocationTargetException;

@Sample(name="add-virtual-nic", description="This sample is used to add a Virtual Nic to a PortGroup")
public class AddVirtualNic
extends ConnectedVimServiceBase {
    private ManagedObjectReference rootFolder;
    private ManagedObjectReference propCollectorRef;
    String datacentername;
    String hostname;
    String portgroupname;
    String ipaddress;

    @Option(name="portgroupname", required=true, description="Name of the port group")
    public void setPortgroupname(String string) {
        this.portgroupname = string;
    }

    @Option(name="ipaddress", required=false, description="ipaddress for the nic, if not set DHCP will be in affect for the nic")
    public void setIpaddress(String string) {
        this.ipaddress = string;
    }

    @Option(name="hostname", required=false, description="Name of the host")
    public void setHostname(String string) {
        this.hostname = string;
    }

    @Option(name="datacentername", required=false, description="Name of the datacenter")
    public void setDatacentername(String string) {
        this.datacentername = string;
    }

    void init() {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.rootFolder = this.serviceContent.getRootFolder();
    }

    HostVirtualNicSpec createVirtualNicSpecification() {
        HostIpConfig hostIpConfig = new HostIpConfig();
        if (this.ipaddress != null && !this.ipaddress.isEmpty()) {
            hostIpConfig.setDhcp(Boolean.FALSE.booleanValue());
            hostIpConfig.setIpAddress(this.ipaddress);
            hostIpConfig.setSubnetMask("255.255.255.0");
        } else {
            hostIpConfig.setDhcp(Boolean.TRUE.booleanValue());
        }
        HostVirtualNicSpec hostVirtualNicSpec = new HostVirtualNicSpec();
        hostVirtualNicSpec.setIp(hostIpConfig);
        return hostVirtualNicSpec;
    }

    void addVirtualNIC() throws HostConfigFaultFaultMsg, AlreadyExistsFaultMsg, InvalidStateFaultMsg, InvalidPropertyFaultMsg, InvocationTargetException, NoSuchMethodException, IllegalAccessException, RuntimeFaultFaultMsg {
        Object object;
        HostConfigManager hostConfigManager;
        ManagedObjectReference managedObjectReference = null;
        if (this.datacentername != null && this.hostname != null || this.datacentername != null && this.hostname == null) {
            hostConfigManager = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "Datacenter", new RetrieveOptions());
            ManagedObjectReference managedObjectReference2 = hostConfigManager.get(this.datacentername);
            if (managedObjectReference2 == null) {
                System.out.println("Datacenter not found");
                return;
            }
            ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"hostFolder"}).get("hostFolder");
            object = this.getMOREFs.inFolderByType(managedObjectReference3, "HostSystem", new RetrieveOptions());
            managedObjectReference = (ManagedObjectReference)object.get(this.hostname);
        } else if (this.datacentername == null && this.hostname != null) {
            hostConfigManager = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
            managedObjectReference = (ManagedObjectReference)hostConfigManager.get(this.hostname);
        }
        if (managedObjectReference != null) {
            hostConfigManager = (HostConfigManager)this.getMOREFs.entityProps(managedObjectReference, new String[]{"configManager"}).get("configManager");
            object = hostConfigManager.getNetworkSystem();
            HostPortGroupSpec hostPortGroupSpec = new HostPortGroupSpec();
            hostPortGroupSpec.setName(this.portgroupname);
            HostVirtualNicSpec hostVirtualNicSpec = this.createVirtualNicSpecification();
            String string = this.vimPort.addVirtualNic((ManagedObjectReference)object, this.portgroupname, hostVirtualNicSpec);
            System.out.println("Successful in creating nic : " + string + " with PortGroup :" + this.portgroupname);
        } else {
            System.out.println("Host not found");
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, AlreadyExistsFaultMsg, InvalidStateFaultMsg, InvocationTargetException, InvalidPropertyFaultMsg, NoSuchMethodException, IllegalAccessException, HostConfigFaultFaultMsg {
        this.init();
        this.addVirtualNIC();
    }
}

