/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.simpleagent;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ESXHostSampleBase;
import com.vmware.security.credstore.CredentialStore;
import com.vmware.security.credstore.CredentialStoreFactory;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.AuthMinimumAdminPermissionFaultMsg;
import com.vmware.vim25.HostAccountSpec;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.Permission;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.UserNotFoundFaultMsg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Sample(name="create-user", description="\n\nCreateUser generates an random username (Usernnnn, where nnnn is a psuedo-randomly generated number) and random password and stores them in the credential store on the local machine. CreateUser works with ESX or ESXi only (not vCenter) \n")
public class CreateUser
extends ESXHostSampleBase {
    private String userName;
    private String password;
    String server = null;

    @Option(name="server", required=false, description="server for which username and password are to be added")
    public void setServer(String string) {
        this.server = string;
    }

    @Option(name="user", required=false, description="provide your own username to create (default is a randomly generated name)")
    public void setUser(String string) {
        this.userName = string;
    }

    public String getUser() {
        return this.userName == null ? this.generateUserName() : this.userName;
    }

    @Option(name="pass", required=false, description="provide your own password for newly created username (default is a randomly generated password)")
    public void setPass(String string) {
        this.password = string;
    }

    public String getPass() {
        return this.password == null ? this.generatePassword() : this.password;
    }

    String generateUserName() {
        int n = (int)(Math.random() * 225.0) + 32;
        String string = "user" + Integer.toString(n);
        System.out.println("Generated username: " + string);
        return string;
    }

    String generatePassword() {
        int n = (int)(Math.random() * 225.0) + 32;
        String string = "Pa$$Word" + Integer.toString(n);
        System.out.println("Generated password: " + string);
        return string;
    }

    String getServerName() {
        if (this.server != null) {
            return this.server;
        }
        String string = this.connection.getUrl();
        if (string.indexOf("https://") != -1) {
            int n = 8;
            int n2 = string.indexOf("/sdk");
            return string.substring(n, n2);
        }
        if (string.indexOf("http://") != -1) {
            int n = 7;
            int n3 = string.indexOf("/sdk");
            return string.substring(n, n3);
        }
        return string;
    }

    @Action
    public void createUser() throws RuntimeFaultFaultMsg, AlreadyExistsFaultMsg, NotFoundFaultMsg, AuthMinimumAdminPermissionFaultMsg, UserNotFoundFaultMsg, IOException {
        this.vimPort.currentTime(this.getServiceInstanceReference());
        ManagedObjectReference managedObjectReference = this.serviceContent.getAccountManager();
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getAuthorizationManager();
        String string = this.getUser();
        String string2 = this.getPass();
        ManagedObjectReference managedObjectReference3 = this.serviceContent.getUserDirectory();
        List list = this.vimPort.retrieveUserGroups(managedObjectReference3, null, string, null, null, true, true, false);
        if (list.isEmpty()) {
            HostAccountSpec hostAccountSpec = new HostAccountSpec();
            hostAccountSpec.setId(string);
            hostAccountSpec.setPassword(string2);
            hostAccountSpec.setDescription("User Description");
            this.vimPort.createUser(managedObjectReference, hostAccountSpec);
            ManagedObjectReference managedObjectReference4 = this.serviceContent.getRootFolder();
            Permission permission = new Permission();
            permission.setGroup(false);
            permission.setPrincipal(string);
            permission.setRoleId(-1);
            permission.setPropagate(true);
            permission.setEntity(managedObjectReference4);
            ArrayList<Permission> arrayList = new ArrayList<Permission>();
            arrayList.add(permission);
            this.vimPort.setEntityPermissions(managedObjectReference2, managedObjectReference4, arrayList);
            CredentialStore credentialStore = CredentialStoreFactory.getCredentialStore();
            credentialStore.addPassword(this.getServerName(), string, string2);
            System.out.println("Successfully created user and populated the credential store");
        } else {
            System.out.println("User " + string + " already Exist");
        }
    }
}

