/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapp;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.HttpNfcLeaseDeviceUrl;
import com.vmware.vim25.HttpNfcLeaseInfo;
import com.vmware.vim25.HttpNfcLeaseState;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.OvfCreateImportSpecParams;
import com.vmware.vim25.OvfCreateImportSpecResult;
import com.vmware.vim25.OvfFileItem;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;

@Sample(name="ovf-manager-import-vapp-from-url", description="This class can be used import or deploy an OVF Appliance from the specified URL.\nDue to some issue with Jax WS deserialization, \"HttpNfcLeaseState\" is deserialized as\nan XML Element and the Value is returned in the ObjectContent as the First Child of Node\nObjectContent[0]->ChangeSet->ElementData[0]->val->firstChild so correct value of HttpNfcLeaseState\nmust be extracted from firstChild node\n")
public class OVFManagerImportVAppFromUrl
extends ConnectedVimServiceBase {
    String cookieValue = "";
    String datastore = null;
    String host = null;
    String urlPath = null;
    String vappName = null;
    boolean vmdkFlag = false;
    volatile long TOTAL_BYTES = 0L;
    volatile long TOTAL_BYTES_WRITTEN = 0L;
    HttpNfcLeaseExtender leaseExtender;

    @Option(name="host", description="Name of the host system")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="urlpath", description="OVFFile urlpath")
    public void setUrlPath(String string) {
        this.urlPath = string;
    }

    @Option(name="vappname", description="New vApp Name")
    public void setVappName(String string) {
        this.vappName = string;
    }

    @Option(name="datastore", required=false, description="Name of the datastore to be used ")
    public void setDatastore(String string) {
        this.datastore = string;
    }

    List<SelectionSpec> buildTraversalSpecForDatastoreToDatacenter() {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("VisitFolders");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setType("Folder");
        traversalSpec.setPath("parent");
        traversalSpec.setSkip(Boolean.FALSE);
        traversalSpec.setName("VisitFolders");
        traversalSpec.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setType("Datastore");
        traversalSpec2.setPath("parent");
        traversalSpec2.setSkip(Boolean.FALSE);
        traversalSpec2.setName("DatastoreToFolder");
        traversalSpec2.getSelectSet().add(selectionSpec);
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add((SelectionSpec)traversalSpec2);
        arrayList.add((SelectionSpec)traversalSpec);
        return arrayList;
    }

    ManagedObjectReference getDatacenterOfDatastore(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference2;
        block0: {
            Iterator iterator;
            managedObjectReference2 = null;
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.setAll(Boolean.FALSE);
            propertySpec.setType("Datacenter");
            propertySpec.getPathSet().add("name");
            ObjectSpec objectSpec = new ObjectSpec();
            objectSpec.setObj(managedObjectReference);
            objectSpec.setSkip(Boolean.TRUE);
            objectSpec.getSelectSet().addAll(this.buildTraversalSpecForDatastoreToDatacenter());
            PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
            propertyFilterSpec.getPropSet().add(propertySpec);
            propertyFilterSpec.getObjectSet().add(objectSpec);
            ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
            arrayList.add(propertyFilterSpec);
            List list = this.vimPort.retrievePropertiesEx(this.serviceContent.getPropertyCollector(), arrayList, new RetrieveOptions()).getObjects();
            if (list == null || !(iterator = list.iterator()).hasNext()) break block0;
            ObjectContent objectContent = (ObjectContent)iterator.next();
            managedObjectReference2 = objectContent.getObj();
        }
        return managedObjectReference2;
    }

    void importVApp() {
        try {
            ManagedObjectReference managedObjectReference5;
            ManagedObjectReference managedObjectReference2 = null;
            ManagedObjectReference managedObjectReference3 = null;
            Map<String, ManagedObjectReference> map = null;
            try {
                map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                runtimeFaultFaultMsg.printStackTrace();
            }
            catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
                invalidPropertyFaultMsg.printStackTrace();
            }
            ManagedObjectReference managedObjectReference4 = (ManagedObjectReference)map.get(this.host);
            if (managedObjectReference4 == null) {
                throw new RuntimeException("Host System " + this.host + " Not Found.");
            }
            Map<String, Object> map2 = this.getMOREFs.entityProps(managedObjectReference4, new String[]{"datastore", "parent"});
            List list = ((ArrayOfManagedObjectReference)map2.get("datastore")).getManagedObjectReference();
            if (list.isEmpty()) {
                throw new RuntimeException("No Datastores accesible from host " + this.host);
            }
            if (this.datastore == null) {
                managedObjectReference2 = (ManagedObjectReference)list.get(0);
            } else {
                for (ManagedObjectReference managedObjectReference5 : list) {
                    if (!this.datastore.equalsIgnoreCase((String)this.getMOREFs.entityProps(managedObjectReference5, new String[]{"name"}).get("name"))) continue;
                    managedObjectReference2 = managedObjectReference5;
                    break;
                }
            }
            if (managedObjectReference2 == null) {
                if (this.datastore != null) {
                    throw new RuntimeException("No Datastore by name " + this.datastore + " is accessible from host " + this.host);
                }
                throw new RuntimeException("No Datastores accesible from host " + this.host);
            }
            managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps((ManagedObjectReference)map2.get("parent"), new String[]{"resourcePool"}).get("resourcePool");
            ManagedObjectReference managedObjectReference6 = this.getDatacenterOfDatastore(managedObjectReference2);
            managedObjectReference5 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference6, new String[]{"vmFolder"}).get("vmFolder");
            OvfCreateImportSpecParams ovfCreateImportSpecParams = this.createImportSpecParams(managedObjectReference4, this.vappName);
            String string = this.getOvfDescriptorFromUrl(this.urlPath);
            if (string == null || string.isEmpty()) {
                return;
            }
            OvfCreateImportSpecResult ovfCreateImportSpecResult = this.vimPort.createImportSpec(this.serviceContent.getOvfManager(), string, managedObjectReference3, managedObjectReference2, ovfCreateImportSpecParams);
            if (ovfCreateImportSpecResult.getError() == null || ovfCreateImportSpecResult.getError().isEmpty()) {
                List list2 = ovfCreateImportSpecResult.getFileItem();
                if (list2 != null) {
                    for (Object[] objectArray : list2) {
                        this.printOvfFileItem((OvfFileItem)objectArray);
                        this.TOTAL_BYTES += objectArray.getSize().longValue();
                    }
                }
                System.out.println("Total bytes: " + this.TOTAL_BYTES);
                if (ovfCreateImportSpecResult != null) {
                    Object[] objectArray;
                    ManagedObjectReference managedObjectReference7 = this.vimPort.importVApp(managedObjectReference3, ovfCreateImportSpecResult.getImportSpec(), managedObjectReference5, managedObjectReference4);
                    objectArray = this.waitForValues.wait(managedObjectReference7, new String[]{"state"}, new String[]{"state"}, new Object[][]{{HttpNfcLeaseState.READY, HttpNfcLeaseState.ERROR}});
                    if (objectArray[0].equals(HttpNfcLeaseState.READY)) {
                        System.out.println("HttpNfcLeaseState: " + objectArray[0]);
                        HttpNfcLeaseInfo httpNfcLeaseInfo = (HttpNfcLeaseInfo)this.getMOREFs.entityProps(managedObjectReference7, new String[]{"info"}).get("info");
                        this.printHttpNfcLeaseInfo(httpNfcLeaseInfo);
                        this.leaseExtender = new HttpNfcLeaseExtender(managedObjectReference7, this.vimPort);
                        Thread thread = new Thread(this.leaseExtender);
                        thread.start();
                        List list3 = httpNfcLeaseInfo.getDeviceUrl();
                        for (HttpNfcLeaseDeviceUrl httpNfcLeaseDeviceUrl : list3) {
                            String string2 = httpNfcLeaseDeviceUrl.getImportKey();
                            for (OvfFileItem ovfFileItem : list2) {
                                if (!string2.equals(ovfFileItem.getDeviceId())) continue;
                                System.out.println("Import key: " + string2);
                                System.out.println("OvfFileItem device id: " + ovfFileItem.getDeviceId());
                                System.out.println("HTTP Post file: " + ovfFileItem.getPath());
                                String string3 = this.urlPath.substring(0, this.urlPath.lastIndexOf("/"));
                                string3 = string3 + "/" + ovfFileItem.getPath();
                                System.out.println("Absolute path: " + string3);
                                this.getVMDKFile(ovfFileItem.isCreate(), string3, httpNfcLeaseDeviceUrl.getUrl().replace("*", this.host), ovfFileItem.getSize());
                                System.out.println("Completed uploading the VMDK file");
                            }
                        }
                        this.vmdkFlag = true;
                        thread.interrupt();
                        this.vimPort.httpNfcLeaseProgress(managedObjectReference7, 100);
                        this.vimPort.httpNfcLeaseComplete(managedObjectReference7);
                    } else {
                        System.out.println("HttpNfcLeaseState not ready");
                        for (Object object : objectArray) {
                            System.out.println("HttpNfcLeaseState: " + object);
                        }
                    }
                }
            } else {
                System.out.println("Cannot import the vAPP because of following:");
                for (LocalizedMethodFault localizedMethodFault : ovfCreateImportSpecResult.getError()) {
                    System.out.println(localizedMethodFault.getLocalizedMessage());
                }
            }
        }
        catch (SOAPFaultException sOAPFaultException) {
            this.printSoapFaultException(sOAPFaultException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    OvfCreateImportSpecParams createImportSpecParams(ManagedObjectReference managedObjectReference, String string) {
        OvfCreateImportSpecParams ovfCreateImportSpecParams = new OvfCreateImportSpecParams();
        ovfCreateImportSpecParams.setHostSystem(managedObjectReference);
        ovfCreateImportSpecParams.setLocale("");
        ovfCreateImportSpecParams.setEntityName(string);
        ovfCreateImportSpecParams.setDeploymentOption("");
        return ovfCreateImportSpecParams;
    }

    String getOvfDescriptorFromUrl(String string) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        HttpURLConnection httpURLConnection = this.getHTTPConnection(string);
        InputStream inputStream = httpURLConnection.getInputStream();
        while ((n = inputStream.read()) != -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer + "";
    }

    HttpURLConnection getHTTPConnection(String string) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        List list = (List)this.headers.get("Set-cookie");
        this.cookieValue = (String)list.get(0);
        StringTokenizer stringTokenizer = new StringTokenizer(this.cookieValue, ";");
        this.cookieValue = stringTokenizer.nextToken();
        String string2 = "$" + stringTokenizer.nextToken();
        String string3 = "$Version=\"1\"; " + this.cookieValue + "; " + string2;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("Cookie", Collections.singletonList(string3));
        ((BindingProvider)this.vimPort).getRequestContext().put("javax.xml.ws.http.request.headers", hashMap);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setAllowUserInteraction(true);
        httpURLConnection.setRequestProperty("Cookie", string3);
        httpURLConnection.connect();
        return httpURLConnection;
    }

    void printOvfFileItem(OvfFileItem ovfFileItem) {
        System.out.println("##########################################################");
        System.out.println("OvfFileItem");
        System.out.println("chunkSize: " + ovfFileItem.getChunkSize());
        System.out.println("create: " + ovfFileItem.isCreate());
        System.out.println("deviceId: " + ovfFileItem.getDeviceId());
        System.out.println("path: " + ovfFileItem.getPath());
        System.out.println("size: " + ovfFileItem.getSize());
        System.out.println("##########################################################");
    }

    void printHttpNfcLeaseInfo(HttpNfcLeaseInfo httpNfcLeaseInfo) {
        System.out.println("########################################################");
        System.out.println("HttpNfcLeaseInfo");
        List list = httpNfcLeaseInfo.getDeviceUrl();
        for (HttpNfcLeaseDeviceUrl httpNfcLeaseDeviceUrl : list) {
            System.out.println("Device URL Import Key: " + httpNfcLeaseDeviceUrl.getImportKey());
            System.out.println("Device URL Key: " + httpNfcLeaseDeviceUrl.getKey());
            System.out.println("Device URL : " + httpNfcLeaseDeviceUrl.getUrl());
            System.out.println("Updated device URL: " + httpNfcLeaseDeviceUrl.getUrl().replace("*", "10.20.140.58"));
        }
        System.out.println("Lease Timeout: " + httpNfcLeaseInfo.getLeaseTimeout());
        System.out.println("Total Disk capacity: " + httpNfcLeaseInfo.getTotalDiskCapacityInKB());
        System.out.println("########################################################");
    }

    void getVMDKFile(boolean bl, String string, String string2, long l) {
        HttpURLConnection httpURLConnection = null;
        BufferedOutputStream bufferedOutputStream = null;
        int n = 65536;
        try {
            System.out.println("Destination host URL: " + string2);
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    System.out.println("Warning: URL Host: " + string + " vs. " + sSLSession.getPeerHost());
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            URL uRL = new URL(string2);
            httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            List list = (List)this.headers.get("Set-cookie");
            this.cookieValue = (String)list.get(0);
            StringTokenizer stringTokenizer = new StringTokenizer(this.cookieValue, ";");
            this.cookieValue = stringTokenizer.nextToken();
            String string3 = "$" + stringTokenizer.nextToken();
            String string4 = "$Version=\"1\"; " + this.cookieValue + "; " + string3;
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            hashMap.put("Cookie", Collections.singletonList(string4));
            ((BindingProvider)this.vimPort).getRequestContext().put("javax.xml.ws.http.request.headers", hashMap);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setChunkedStreamingMode(n);
            if (bl) {
                httpURLConnection.setRequestMethod("PUT");
                System.out.println("HTTP method: PUT");
            } else {
                httpURLConnection.setRequestMethod("POST");
                System.out.println("HTTP method: POST");
            }
            httpURLConnection.setRequestProperty("Cookie", string4);
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-vnd.vmware-streamVmdk");
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(l));
            bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
            System.out.println("Local file path: " + string);
            HttpURLConnection httpURLConnection2 = this.getHTTPConnection(string);
            InputStream inputStream = httpURLConnection2.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n2 = bufferedInputStream.available();
            System.out.println("vmdk available bytes: " + n2);
            int n3 = Math.min(n2, n);
            byte[] byArray = new byte[n3];
            int n4 = bufferedInputStream.read(byArray, 0, n3);
            long l2 = n4;
            this.TOTAL_BYTES_WRITTEN += (long)n4;
            while (n4 >= 0) {
                bufferedOutputStream.write(byArray, 0, n3);
                bufferedOutputStream.flush();
                System.out.println("Bytes Written: " + l2);
                n2 = bufferedInputStream.available();
                n3 = Math.min(n2, n);
                l2 += (long)n3;
                System.out.println("Total bytes written: " + this.TOTAL_BYTES_WRITTEN);
                this.TOTAL_BYTES_WRITTEN += (long)n3;
                byArray = null;
                byArray = new byte[n3];
                n4 = bufferedInputStream.read(byArray, 0, n3);
                System.out.println("Bytes Read: " + n4);
                if (n4 != 0 || l2 < l) continue;
                System.out.println("Total bytes written: " + this.TOTAL_BYTES_WRITTEN);
                n4 = -1;
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                dataInputStream.close();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                System.out.println("From (ServerResponse): " + socketTimeoutException);
            }
            catch (IOException iOException) {
                System.out.println("From (ServerResponse): " + iOException);
            }
            System.out.println("Writing vmdk to the output stream done");
            bufferedInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            throw new CheckedExceptionWrapper((Throwable)malformedURLException);
        }
        catch (IOException iOException) {
            throw new CheckedExceptionWrapper((Throwable)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("this is supposed to be impossible", noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new CheckedExceptionWrapper((Throwable)keyManagementException);
        }
        finally {
            try {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                httpURLConnection.disconnect();
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.printSoapFaultException(sOAPFaultException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void printSoapFaultException(SOAPFaultException sOAPFaultException) {
        System.out.println("SOAP Fault -");
        if (sOAPFaultException.getFault().hasDetail()) {
            System.out.println(sOAPFaultException.getFault().getDetail().getFirstChild().getLocalName());
        }
        if (sOAPFaultException.getFault().getFaultString() != null) {
            System.out.println("\n Message: " + sOAPFaultException.getFault().getFaultString());
        }
    }

    @Action
    public void run() {
        this.importVApp();
    }

    private class CheckedExceptionWrapper
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CheckedExceptionWrapper(Throwable throwable) {
            super(throwable);
        }
    }

    class HttpNfcLeaseExtender
    implements Runnable {
        private ManagedObjectReference httpNfcLease = null;
        private VimPortType vimPort = null;
        private int progressPercent = 0;

        public HttpNfcLeaseExtender(ManagedObjectReference managedObjectReference, VimPortType vimPortType) {
            this.httpNfcLease = managedObjectReference;
            this.vimPort = vimPortType;
        }

        @Override
        public void run() {
            try {
                while (!OVFManagerImportVAppFromUrl.this.vmdkFlag) {
                    System.out.println("\n\n#####################vmdk flag: " + OVFManagerImportVAppFromUrl.this.vmdkFlag + "\n\n");
                    if (OVFManagerImportVAppFromUrl.this.TOTAL_BYTES != 0L) {
                        this.progressPercent = (int)(OVFManagerImportVAppFromUrl.this.TOTAL_BYTES_WRITTEN * 100L / OVFManagerImportVAppFromUrl.this.TOTAL_BYTES);
                    }
                    try {
                        this.vimPort.httpNfcLeaseProgress(this.httpNfcLease, this.progressPercent);
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("********************** Task completed *******************");
                        break;
                    }
                    catch (SOAPFaultException sOAPFaultException) {
                        OVFManagerImportVAppFromUrl.this.printSoapFaultException(sOAPFaultException);
                        break;
                    }
                }
            }
            catch (SOAPFaultException sOAPFaultException) {
                OVFManagerImportVAppFromUrl.this.printSoapFaultException(sOAPFaultException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

