/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.Capability;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.EVCMode;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualMachineCapability;
import java.util.Arrays;
import java.util.List;

@Sample(name="vm-apply-evc", description="This sample applies a Per-VM EVC setting to an existing VM.")
public class VMApplyEvc
extends ConnectedVimServiceBase {
    private String vmPathName;
    private String evcKey;
    private Boolean listModes = false;

    @Option(name="vmpath", required=false, description="inventory path of the VM")
    public void setVmPathName(String string) {
        this.vmPathName = string;
    }

    @Option(name="evc-key", required=false, description="Key of the EVC mode")
    public void setEvcKey(String string) {
        this.evcKey = string;
    }

    @Option(name="list", required=false, parameter=false, description="List only")
    public void setList(Boolean bl) {
        this.listModes = bl;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    Object getDynamicProperty(ManagedObjectReference managedObjectReference, String string) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        String[] stringArray = new String[]{string};
        PropertyFilterSpec propertyFilterSpec = this.waitForValues.propertyFilterSpec(managedObjectReference, new String[]{string});
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.serviceContent.getPropertyCollector(), Arrays.asList(propertyFilterSpec), new RetrieveOptions());
        if (retrieveResult.getObjects().size() == 1 && ((ObjectContent)retrieveResult.getObjects().get(0)).getPropSet().size() == 1) {
            return ((DynamicProperty)((ObjectContent)retrieveResult.getObjects().get(0)).getPropSet().get(0)).getVal();
        }
        throw new RuntimeException("Failed to fetch " + string);
    }

    List<EVCMode> getEvcModes() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.getServiceInstanceReference();
        Capability capability = (Capability)this.getDynamicProperty(managedObjectReference, "capability");
        return capability.getSupportedEVCMode();
    }

    boolean isPerVmEvcSupported(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        VirtualMachineCapability virtualMachineCapability = (VirtualMachineCapability)this.getDynamicProperty(managedObjectReference, "capability");
        if (virtualMachineCapability.isPerVmEvcSupported() != null) {
            return virtualMachineCapability.isPerVmEvcSupported();
        }
        return false;
    }

    void applyEvcModeVm() throws RuntimeFaultFaultMsg, InvalidStateFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        Object object2;
        ManagedObjectReference managedObjectReference;
        if (this.vmPathName == null) {
            System.out.println("--vmpath must be specified unless --list is set.");
            return;
        }
        ManagedObjectReference managedObjectReference2 = this.vimPort.findByInventoryPath(this.serviceContent.getSearchIndex(), this.vmPathName);
        if (managedObjectReference2 == null) {
            System.out.format("The VMPath specified [ %s ] is not found.", this.vmPathName);
            return;
        }
        boolean bl = this.isPerVmEvcSupported(managedObjectReference2);
        if (!bl) {
            System.out.println("Per-VM EVC is not supported for this virtual hardware version.");
            return;
        }
        List list = null;
        if (this.evcKey != null) {
            managedObjectReference = this.getEvcModes();
            for (Object object2 : managedObjectReference) {
                if (!object2.getKey().equals(this.evcKey)) continue;
                list = object2.getFeatureMask();
                break;
            }
            if (list == null) {
                System.out.format("Failed to find EVC mode with key %s", this.evcKey);
                return;
            }
        }
        managedObjectReference = this.vimPort.applyEvcModeVMTask(managedObjectReference2, list, Boolean.valueOf(true));
        String string = this.evcKey == null ? "none" : this.evcKey;
        object2 = this.getTaskResultAfterDone(managedObjectReference) ? "Successfully applied" : "Failed to apply";
        System.out.format("%s EVC mode to [%s]", object2, string);
    }

    void list() throws InvalidCollectorVersionFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List<EVCMode> list = this.getEvcModes();
        System.out.println("EVC modes");
        System.out.println("---------");
        for (EVCMode eVCMode : list) {
            System.out.println(eVCMode.getKey());
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidPropertyFaultMsg {
        if (this.listModes.booleanValue()) {
            this.list();
        } else {
            this.applyEvcModeVm();
        }
    }
}

