/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceConnectInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskCompatibilityMode;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualDiskMode;
import com.vmware.vim25.VirtualDiskRawDiskMappingVer1BackingInfo;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualSCSIController;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="vm-disk-create", description="This sample demonstrates how to create a virtual disk")
public class VMDiskCreate
extends ConnectedVimServiceBase {
    private ManagedObjectReference dataStore;
    final HardDiskBean hDiskBean = new HardDiskBean();
    String virtualMachineName;
    int diskSize;
    String dataStoreName;
    String disktype;
    String persistence;
    String devicename;
    final Map<String, DISKTYPE> disktypehm = new HashMap<String, DISKTYPE>();

    @Option(name="vmname", required=false, description="Name of the virtual machine")
    public void setVirtualMachineName(String string) {
        this.virtualMachineName = string;
    }

    @Option(name="datastorename", required=false, description="name of the DataStore")
    public void setDataStoreName(String string) {
        this.dataStoreName = string;
    }

    @Option(name="disksize", description="Size of the virtual disk in MB")
    public void setDiskSize(String string) {
        this.diskSize = Integer.parseInt(string);
    }

    @Option(name="disktype", required=false, description="Virtual Disk Type\n[thin | preallocated | eagerzeroed | rdm | rdmp]")
    public void setDisktype(String string) {
        this.disktype = string;
    }

    @Option(name="persistence", required=false, description="Persistence mode of the virtual disk\n[persistent | independent_persistent | independent_nonpersistent]")
    public void setPersistence(String string) {
        this.persistence = string;
    }

    @Option(name="devicename", required=false, description="Canonical name of the LUN to use for disk types")
    public void setDevicename(String string) {
        this.devicename = string;
    }

    @Before
    public void init() {
        this.disktypehm.put("thin", DISKTYPE.THIN);
        this.disktypehm.put("thick", DISKTYPE.THICK);
        this.disktypehm.put("pre-allocated", DISKTYPE.PRE_ALLOCATED);
        this.disktypehm.put("rdm", DISKTYPE.RDM);
        this.disktypehm.put("rdmp", DISKTYPE.RDMP);
        this.disktypehm.put("eagerzeroed", DISKTYPE.EAGERZEROED);
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void setDiskInformation() throws IllegalArgumentException {
        DISKTYPE dISKTYPE = null;
        if (this.disktype == null || this.disktype.trim().length() == 0) {
            System.out.println(" Disktype is not specified Assuming disktype [thin] ");
            dISKTYPE = DISKTYPE.THIN;
            this.hDiskBean.setDiskType(dISKTYPE);
            this.hDiskBean.setDiskSize(this.diskSize);
        } else {
            dISKTYPE = this.disktypehm.get(this.disktype.trim().toLowerCase());
            if (dISKTYPE == null) {
                System.out.println("Invalid value for option disktype. Possible values are : " + this.disktypehm.keySet());
                throw new IllegalArgumentException("The DISK Type " + this.disktype + " is Invalid");
            }
            this.hDiskBean.setDiskType(dISKTYPE);
            this.hDiskBean.setDiskSize(this.diskSize);
        }
        this.hDiskBean.setDiskSize(this.diskSize <= 0 ? 1 : this.diskSize);
        if (this.devicename == null || this.devicename.trim().length() == 0) {
            if (dISKTYPE == DISKTYPE.RDM || dISKTYPE == DISKTYPE.RDMP) {
                throw new IllegalArgumentException("The devicename is mandatory for specified disktype [ " + (Object)((Object)dISKTYPE) + " ]");
            }
        } else {
            this.hDiskBean.setDeviceName(this.devicename);
        }
    }

    VirtualDeviceConfigSpec virtualDiskOp(ManagedObjectReference managedObjectReference, HardDiskBean hardDiskBean) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        String string = hardDiskBean.getDeviceName();
        DISKTYPE dISKTYPE = hardDiskBean.getDiskType();
        int n = hardDiskBean.getDiskSize();
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = null;
        List<Integer> list = this.getControllerKey(managedObjectReference);
        String string2 = "Failure Disk Create : SCSI Controller not found";
        if (list.isEmpty()) {
            throw new RuntimeException(string2);
        }
        Integer n2 = list.get(0);
        Integer n3 = list.get(1);
        virtualDeviceConfigSpec = this.createVirtualDiskConfigSpec(string, n2, n3, dISKTYPE, n);
        return virtualDeviceConfigSpec;
    }

    List<Integer> getControllerKey(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(managedObjectReference, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        for (Object object : list) {
            hashMap.put(object.getKey(), object);
        }
        boolean bl = false;
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualSCSIController)) continue;
            VirtualSCSIController virtualSCSIController = (VirtualSCSIController)virtualDevice;
            int[] nArray = new int[CONTROLLERTYPE.SCSI.getMaxDevice()];
            nArray[CONTROLLERTYPE.SCSI.getReserveSlot()] = 1;
            List list2 = virtualSCSIController.getDevice();
            for (Integer n : list2) {
                if (((VirtualDevice)hashMap.get(n)).getUnitNumber() == null) continue;
                nArray[((VirtualDevice)hashMap.get((Object)n)).getUnitNumber().intValue()] = 1;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 1) continue;
                arrayList.add(virtualSCSIController.getKey());
                arrayList.add(i);
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        if (!bl) {
            throw new RuntimeException("The SCSI controller on the vm has maxed out its capacity. Please add an additional SCSI controller");
        }
        return arrayList;
    }

    VirtualDeviceConfigSpec createVirtualDiskConfigSpec(String string, int n, int n2, DISKTYPE dISKTYPE, int n3) {
        VirtualDeviceConnectInfo virtualDeviceConnectInfo = new VirtualDeviceConnectInfo();
        virtualDeviceConnectInfo.setStartConnected(true);
        virtualDeviceConnectInfo.setConnected(true);
        virtualDeviceConnectInfo.setAllowGuestControl(false);
        VirtualDisk virtualDisk = new VirtualDisk();
        virtualDisk.setControllerKey(new Integer(n));
        virtualDisk.setUnitNumber(new Integer(n2));
        virtualDisk.setCapacityInKB((long)(1024 * n3));
        virtualDisk.setKey(-1);
        virtualDisk.setConnectable(virtualDeviceConnectInfo);
        VirtualDiskFlatVer2BackingInfo virtualDiskFlatVer2BackingInfo = new VirtualDiskFlatVer2BackingInfo();
        VirtualDiskRawDiskMappingVer1BackingInfo virtualDiskRawDiskMappingVer1BackingInfo = new VirtualDiskRawDiskMappingVer1BackingInfo();
        switch (dISKTYPE) {
            case RDM: {
                virtualDiskRawDiskMappingVer1BackingInfo.setCompatibilityMode(VirtualDiskCompatibilityMode.VIRTUAL_MODE.value());
                virtualDiskRawDiskMappingVer1BackingInfo.setDeviceName(string);
                virtualDiskRawDiskMappingVer1BackingInfo.setDiskMode(this.persistence);
                virtualDiskRawDiskMappingVer1BackingInfo.setDatastore(this.dataStore);
                virtualDiskRawDiskMappingVer1BackingInfo.setFileName("");
                virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskRawDiskMappingVer1BackingInfo);
                break;
            }
            case RDMP: {
                virtualDiskRawDiskMappingVer1BackingInfo.setCompatibilityMode(VirtualDiskCompatibilityMode.PHYSICAL_MODE.value());
                virtualDiskRawDiskMappingVer1BackingInfo.setDeviceName(string);
                virtualDiskRawDiskMappingVer1BackingInfo.setDatastore(this.dataStore);
                virtualDiskRawDiskMappingVer1BackingInfo.setFileName("");
                virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskRawDiskMappingVer1BackingInfo);
                break;
            }
            case THICK: {
                virtualDiskFlatVer2BackingInfo.setDiskMode(VirtualDiskMode.INDEPENDENT_PERSISTENT.value());
                virtualDiskFlatVer2BackingInfo.setThinProvisioned(Boolean.FALSE);
                virtualDiskFlatVer2BackingInfo.setEagerlyScrub(Boolean.FALSE);
                virtualDiskFlatVer2BackingInfo.setDatastore(this.dataStore);
                virtualDiskFlatVer2BackingInfo.setFileName("");
                virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer2BackingInfo);
                break;
            }
            case THIN: {
                if (this.persistence == null) {
                    this.persistence = "persistent";
                }
                virtualDiskFlatVer2BackingInfo.setDiskMode(this.persistence);
                virtualDiskFlatVer2BackingInfo.setThinProvisioned(Boolean.TRUE);
                virtualDiskFlatVer2BackingInfo.setEagerlyScrub(Boolean.FALSE);
                virtualDiskFlatVer2BackingInfo.setDatastore(this.dataStore);
                virtualDiskFlatVer2BackingInfo.setFileName("");
                virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer2BackingInfo);
                break;
            }
            case PRE_ALLOCATED: {
                virtualDiskFlatVer2BackingInfo.setDiskMode(this.persistence);
                virtualDiskFlatVer2BackingInfo.setThinProvisioned(Boolean.FALSE);
                virtualDiskFlatVer2BackingInfo.setEagerlyScrub(Boolean.FALSE);
                virtualDiskFlatVer2BackingInfo.setDatastore(this.dataStore);
                virtualDiskFlatVer2BackingInfo.setFileName("");
                virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer2BackingInfo);
                break;
            }
            case EAGERZEROED: {
                virtualDiskFlatVer2BackingInfo.setDiskMode(this.persistence);
                virtualDiskFlatVer2BackingInfo.setThinProvisioned(Boolean.FALSE);
                virtualDiskFlatVer2BackingInfo.setEagerlyScrub(Boolean.TRUE);
                virtualDiskFlatVer2BackingInfo.setDatastore(this.dataStore);
                virtualDiskFlatVer2BackingInfo.setFileName("");
                virtualDisk.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer2BackingInfo);
                break;
            }
        }
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        virtualDeviceConfigSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.CREATE);
        virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
        virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualDisk);
        return virtualDeviceConfigSpec;
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, DuplicateNameFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.vmByVMname(this.virtualMachineName, managedObjectReference);
        if (managedObjectReference2 == null) {
            System.out.printf(" Virtual Machine [ %s ] not found", this.virtualMachineName);
            return;
        }
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        this.setDiskInformation();
        this.dataStoreName = "[" + this.dataStoreName + "]";
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = this.virtualDiskOp(managedObjectReference2, this.hDiskBean);
        if (virtualDeviceConfigSpec == null) {
            System.exit(0);
        }
        ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
        arrayList.add(virtualDeviceConfigSpec);
        virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ]", this.virtualMachineName);
        ManagedObjectReference managedObjectReference3 = this.vimPort.reconfigVMTask(managedObjectReference2, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone(managedObjectReference3)) {
            System.out.printf("\n Reconfiguring the Virtual Machine  - [ %s ] Successful", this.virtualMachineName);
        } else {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Failed", this.virtualMachineName);
        }
    }

    private static class HardDiskBean {
        private DISKTYPE diskType;
        private String deviceName;
        private int disksize;

        public void setDiskSize(int n) {
            this.disksize = n;
        }

        public int getDiskSize() {
            return this.disksize;
        }

        public void setDiskType(DISKTYPE dISKTYPE) {
            this.diskType = dISKTYPE;
        }

        public DISKTYPE getDiskType() {
            return this.diskType;
        }

        public void setDeviceName(String string) {
            this.deviceName = string;
        }

        public String getDeviceName() {
            return this.deviceName;
        }
    }

    private static enum CONTROLLERTYPE {
        SCSI(16, 7),
        IDE(2);

        private final int maxdevice;
        private int reserveSlot = -1;

        private CONTROLLERTYPE(int n2) {
            this.maxdevice = n2;
        }

        private CONTROLLERTYPE(int n2, int n3) {
            this.maxdevice = n2;
            this.reserveSlot = n3;
        }

        public int getMaxDevice() {
            return this.maxdevice;
        }

        public int getReserveSlot() {
            return this.reserveSlot;
        }
    }

    private static enum DISKTYPE {
        THIN,
        THICK,
        PRE_ALLOCATED,
        RDM,
        RDMP,
        EAGERZEROED;

    }
}

