/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPowerStateFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDisk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@Sample(name="vm-promote-disks", description="Used to consolidate a linked clone by using promote API.")
public class VMPromoteDisks
extends ConnectedVimServiceBase {
    String vmName = null;
    Boolean unLink = null;
    String diskNames = null;

    @Option(name="vmname", description="name of the virtual machine")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="unlink", description="True|False to unlink")
    public void setUnLink(String string) {
        this.unLink = Boolean.valueOf(string);
    }

    @Option(name="devicenames", required=false, description="disk name to unlink")
    public void setDiskNames(String string) {
        this.diskNames = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void promoteDeltaDisk() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, TaskInProgressFaultMsg, InvalidStateFaultMsg, InvalidPowerStateFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.vmByVMname(this.vmName, managedObjectReference);
        boolean bl = this.unLink;
        ArrayList<VirtualDisk> arrayList = new ArrayList<VirtualDisk>();
        if (managedObjectReference2 != null) {
            String string;
            if (this.diskNames != null) {
                string = this.diskNames;
                String[] stringArray = string.split(":");
                HashMap hashMap = new HashMap();
                for (String string2 : stringArray) {
                    hashMap.put(string2, null);
                }
                List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    VirtualDevice virtualDevice = (VirtualDevice)iterator.next();
                    if (!(virtualDevice instanceof VirtualDisk) || !hashMap.containsKey(virtualDevice.getDeviceInfo().getLabel())) continue;
                    arrayList.add((VirtualDisk)virtualDevice);
                }
            }
            if (this.getTaskResultAfterDone((ManagedObjectReference)(string = this.vimPort.promoteDisksTask(managedObjectReference2, bl, arrayList)))) {
                System.out.println("Virtual Disks Promoted successfully.");
            } else {
                System.out.println("Failure -: Virtual Disks cannot be promoted");
            }
        } else {
            System.out.println("Virtual Machine " + this.vmName + " doesn't exist");
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, TaskInProgressFaultMsg, InvalidPropertyFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidPowerStateFaultMsg {
        this.promoteDeltaDisk();
    }
}

